/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.tunnelpathsrlgs.tunnelpathsrlgs.style.named;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.RouteExcludeSrlg;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.tunnelpathsrlgs.tunnelpathsrlgs.style.named.constraints.Constraint;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of constraints.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultConstraints extends InnerModelObject 
        implements Constraints, MultiInstanceObject<ConstraintsKeys> {
    protected Class<? extends RouteExcludeSrlg> usage;
    protected BitSet valueLeafFlags = new BitSet();
    protected Constraint constraint;

    @Override
    public Class<? extends RouteExcludeSrlg> usage() {
        return usage;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Constraint constraint() {
        return constraint;
    }

    @Override
    public void usage(Class<? extends RouteExcludeSrlg> usage) {
        valueLeafFlags.set(LeafIdentifier.USAGE.getLeafIndex());
        this.usage = usage;
    }

    @Override
    public void constraint(Constraint constraint) {
        this.constraint = constraint;
    }

    @Override
    public int hashCode() {
        return Objects.hash(usage, valueLeafFlags, constraint);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultConstraints) {
            DefaultConstraints other = (DefaultConstraints) obj;
            return
                Objects.deepEquals(usage, other.usage) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(constraint, other.constraint);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("usage=" + usage)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("constraint=" + constraint)
            .toString();
    }


    /**
     * Creates an instance of defaultConstraints.
     */
    public DefaultConstraints() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}