/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.networks.network.augmentedndnetwork;

import org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.LinkId;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of link.
 */
public class LinkKeys implements KeyInfo<DefaultLink> {
    protected LinkId linkId;
    /**
     * Returns the attribute linkId.
     *
     * @return linkId value of linkId
     */
    public LinkId linkId() {
        return linkId;
    }

    /**
     * Sets the value to attribute linkId.
     *
     * @param linkId value of linkId
     */
    public void linkId(LinkId linkId) {
        this.linkId = linkId;
    }


    @Override
    public int hashCode() {
        return Objects.hash(linkId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LinkKeys) {
            LinkKeys other = (LinkKeys) obj;
            return
                Objects.deepEquals(linkId, other.linkId);
        }
        return false;
    }
}