/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.listanydata.rev20160624;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v11.listanydata.rev20160624.listanydata.L1;
import org.onosproject.yang.gen.v11.listanydata.rev20160624.listanydata.Mydata;

/**
 * Abstraction of an entity which represents the functionality of listAnydata.
 */
public interface ListAnydata {

    /**
     * Identify the leaf of ListAnydata.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents leaf1.
         */
        LEAF1(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute leaf1.
     *
     * @return leaf1 list of leaf1
     */
    List<String> leaf1();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute mydata.
     *
     * @return mydata value of mydata
     */
    Mydata mydata();

    /**
     * Returns the attribute l1.
     *
     * @return l1 list of l1
     */
    List<L1> l1();

    /**
     * Sets the attribute leaf1.
     *
     * @param leaf1 list of leaf1
     */
    void leaf1(List<String> leaf1);

    /**
     * Sets the attribute mydata.
     *
     * @param mydata value of mydata
     */
    void mydata(Mydata mydata);

    /**
     * Sets the attribute l1.
     *
     * @param l1 list of l1
     */
    void l1(List<L1> l1);

    /**
     * Adds to the list of leaf1.
     *
     * @param addTo value of leaf1
     */
    void addToLeaf1(String addTo);

    /**
     * Adds to the list of l1.
     *
     * @param addTo value of l1
     */
    void addToL1(L1 addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}