/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.listanydata.rev20160624.listanydata;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.listanydata.rev20160624.listanydata.l1.C1;
import org.onosproject.yang.gen.v11.listanydata.rev20160624.listanydata.l1.Mydata;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of l1.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultL1 extends InnerModelObject 
        implements L1, MultiInstanceObject<L1Keys> {
    protected String k1;
    protected String k2;
    protected String k3;
    protected BitSet valueLeafFlags = new BitSet();
    protected C1 c1;
    protected Mydata mydata;

    @Override
    public String k1() {
        return k1;
    }

    @Override
    public String k2() {
        return k2;
    }

    @Override
    public String k3() {
        return k3;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public C1 c1() {
        return c1;
    }

    @Override
    public Mydata mydata() {
        return mydata;
    }

    @Override
    public void k1(String k1) {
        valueLeafFlags.set(LeafIdentifier.K1.getLeafIndex());
        this.k1 = k1;
    }

    @Override
    public void k2(String k2) {
        valueLeafFlags.set(LeafIdentifier.K2.getLeafIndex());
        this.k2 = k2;
    }

    @Override
    public void k3(String k3) {
        valueLeafFlags.set(LeafIdentifier.K3.getLeafIndex());
        this.k3 = k3;
    }

    @Override
    public void c1(C1 c1) {
        this.c1 = c1;
    }

    @Override
    public void mydata(Mydata mydata) {
        this.mydata = mydata;
    }

    @Override
    public int hashCode() {
        return Objects.hash(k1, k2, k3, valueLeafFlags, c1, mydata);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultL1) {
            DefaultL1 other = (DefaultL1) obj;
            return
                Objects.deepEquals(k1, other.k1) &&
                Objects.deepEquals(k2, other.k2) &&
                Objects.deepEquals(k3, other.k3) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(c1, other.c1) &&
                Objects.deepEquals(mydata, other.mydata);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("k1=" + k1)
            .add("k2=" + k2)
            .add("k3=" + k3)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("c1=" + c1)
            .add("mydata=" + mydata)
            .toString();
    }


    /**
     * Creates an instance of defaultL1.
     */
    public DefaultL1() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}