/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.listanydata.rev20160624.listanydata.l1.c1;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.listanydata.rev20160624.listanydata.l1.c1.augmentedlc1.Mydata;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of augmentedLc1.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAugmentedLc1 extends InnerModelObject implements AugmentedLc1 {
    protected Mydata mydata;

    @Override
    public Mydata mydata() {
        return mydata;
    }

    @Override
    public void mydata(Mydata mydata) {
        this.mydata = mydata;
    }

    @Override
    public int hashCode() {
        return Objects.hash(mydata);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAugmentedLc1) {
            DefaultAugmentedLc1 other = (DefaultAugmentedLc1) obj;
            return
                Objects.deepEquals(mydata, other.mydata);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("mydata=" + mydata)
            .toString();
    }


    /**
     * Creates an instance of defaultAugmentedLc1.
     */
    public DefaultAugmentedLc1() {
    }

}