/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.serializers.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.DefaultResourceData;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.runtime.AnnotatedNodeInfo;
import org.onosproject.yang.runtime.Annotation;
import org.onosproject.yang.runtime.CompositeData;
import org.onosproject.yang.runtime.CompositeStream;
import org.onosproject.yang.runtime.DataNodeListener;
import org.onosproject.yang.runtime.DefaultCompositeData;
import org.onosproject.yang.runtime.DefaultCompositeStream;
import org.onosproject.yang.runtime.DefaultDataNodeWalker;
import org.onosproject.yang.runtime.SerializerHelper;
import org.onosproject.yang.runtime.YangSerializer;
import org.onosproject.yang.runtime.YangSerializerContext;
import org.onosproject.yang.serializers.utils.SerializersUtil;
import org.onosproject.yang.serializers.xml.DataNodeXmlListener;
import org.onosproject.yang.serializers.xml.DefaultXmlWalker;
import org.onosproject.yang.serializers.xml.XmlSerializerException;
import org.onosproject.yang.serializers.xml.XmlSerializerListener;

public class XmlSerializer
implements YangSerializer {
    private static final String XML = "xml";

    public String supportsFormat() {
        return XML;
    }

    public CompositeData decode(CompositeStream external, YangSerializerContext context) {
        try {
            String xmlInput = SerializersUtil.addRootElementWithAnnotation((InputStream)external.resourceData(), (List)context.getProtocolAnnotations());
            Document document = DocumentHelper.parseText((String)xmlInput);
            DefaultCompositeData.Builder cBuilder = DefaultCompositeData.builder();
            DefaultResourceData.Builder rdBuilder = DefaultResourceData.builder();
            DefaultXmlWalker walker = new DefaultXmlWalker();
            XmlSerializerListener listener = new XmlSerializerListener();
            listener.cBuilder((CompositeData.Builder)cBuilder);
            String uri = external.resourceId();
            if (uri == null) {
                listener.dnBuilder(SerializerHelper.initializeDataNode((YangSerializerContext)context));
                walker.walk(listener, document.getRootElement(), document.getRootElement());
                rdBuilder = rdBuilder.addDataNode(listener.dnBuilder().build());
            } else {
                ResourceId.Builder rIdBuilder = SerializersUtil.convertUriToRid((String)uri, (YangSerializerContext)context);
                Element rootElement = document.getRootElement();
                if (rootElement.hasContent() && !rootElement.isTextOnly()) {
                    Iterator i = rootElement.elementIterator();
                    while (i.hasNext()) {
                        Element childElement = (Element)i.next();
                        listener.dnBuilder(SerializerHelper.initializeDataNode((ResourceId.Builder)rIdBuilder));
                        walker.walk(listener, childElement, rootElement);
                        rdBuilder = rdBuilder.addDataNode(listener.dnBuilder().build());
                    }
                }
                rdBuilder.resourceId(rIdBuilder.build());
            }
            return cBuilder.resourceData(rdBuilder.build()).build();
        }
        catch (DocumentException e) {
            throw new XmlSerializerException(e.getMessage());
        }
        catch (IOException e) {
            throw new XmlSerializerException(e.getMessage());
        }
    }

    public CompositeStream encode(CompositeData internal, YangSerializerContext context) {
        ResourceId.Builder builder;
        String uriString = null;
        ResourceId resourceId = internal.resourceData().resourceId();
        if (resourceId != null && resourceId.nodeKeys() != null && !resourceId.nodeKeys().isEmpty()) {
            uriString = SerializersUtil.convertRidToUri((ResourceId)resourceId, (YangSerializerContext)context);
            try {
                builder = resourceId.copyBuilder();
            }
            catch (CloneNotSupportedException e) {
                throw new XmlSerializerException(e.getMessage());
            }
        } else {
            builder = ResourceId.builder();
        }
        HashMap<ResourceId, List<Annotation>> annotations = new HashMap<ResourceId, List<Annotation>>();
        List annotationList = internal.annotatedNodesInfo();
        if (annotationList != null) {
            for (AnnotatedNodeInfo annotationInfo : annotationList) {
                annotations.put(annotationInfo.resourceId(), annotationInfo.annotations());
            }
        }
        List dataNodes = internal.resourceData().dataNodes();
        StringBuilder sb = new StringBuilder();
        for (DataNode dataNode : dataNodes) {
            DataNodeXmlListener listener = new DataNodeXmlListener(annotations, builder);
            DefaultDataNodeWalker.walk((DataNodeListener)listener, (DataNode)dataNode);
            sb.append(listener.xmlData());
        }
        InputStream inputStream = IOUtils.toInputStream((String)sb.toString());
        return new DefaultCompositeStream(uriString, inputStream);
    }
}

