/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.tool;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.onosproject.yangutils.datamodel.ResolvableType;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangReferenceResolver;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.linker.YangLinker;
import org.onosproject.yangutils.linker.exceptions.LinkerException;
import org.onosproject.yangutils.linker.impl.YangLinkerManager;
import org.onosproject.yangutils.linker.impl.YangLinkerUtils;
import org.onosproject.yangutils.parser.YangUtilsParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.YangUtilsParserManager;
import org.onosproject.yangutils.tool.CallablePlugin;
import org.onosproject.yangutils.tool.YangFileInfo;
import org.onosproject.yangutils.tool.exception.YangToolException;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorUtil;
import org.onosproject.yangutils.utils.UtilConstants;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YangToolManager {
    private static final Logger log = LoggerFactory.getLogger(YangToolManager.class);
    public static final String DEFAULT_JAR_RES_PATH = UtilConstants.SLASH + "Temp" + UtilConstants.SLASH + "yang/resources" + UtilConstants.SLASH;
    public static final String YANG_META_DATA = "YangMetaData";
    public static final String SERIALIZED_FILE_EXTENSION = ".ser";
    private Set<YangFileInfo> yangFileInfoSet;
    private final YangUtilsParser yangUtilsParser = new YangUtilsParserManager();
    private final YangLinker yangLinker = new YangLinkerManager();
    private YangFileInfo curYangFileInfo = new YangFileInfo();
    private final Set<YangNode> yangNodeSet = new HashSet<YangNode>();

    private static List<File> getListOfFile(Set<YangFileInfo> yangFileInfo) {
        ArrayList<File> files = new ArrayList<File>();
        for (YangFileInfo yangFile : yangFileInfo) {
            if (!yangFile.isForTranslator()) continue;
            files.add(new File(yangFile.getYangFileName()));
        }
        return files;
    }

    public Set<YangFileInfo> createYangFileInfoSet(List<String> yangFileList) {
        if (this.yangFileInfoSet == null) {
            this.yangFileInfoSet = new HashSet<YangFileInfo>();
        }
        for (String yangFile : yangFileList) {
            YangFileInfo yangFileInfo = new YangFileInfo();
            yangFileInfo.setYangFileName(yangFile);
            this.yangFileInfoSet.add(yangFileInfo);
        }
        return this.yangFileInfoSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileYangFiles(Set<YangFileInfo> yangFiles, List<YangNode> dependentSchema, YangPluginConfig config, CallablePlugin plugin) throws IOException {
        Set<YangFileInfo> set = yangFiles;
        synchronized (set) {
            try {
                if (config == null) {
                    throw new YangToolException("Missing extected input ");
                }
                this.yangFileInfoSet = yangFiles;
                if (config.getCodeGenDir() == null) {
                    throw new YangToolException("Missing plugin code gen directory");
                }
                if (this.yangFileInfoSet == null || this.yangFileInfoSet.isEmpty()) {
                    return;
                }
                YangIoUtils.createDirectories((String)config.resourceGenDir());
                this.addSchemaToFileSet(dependentSchema);
                this.parseYangFileInfoSet();
                this.resolveDependenciesUsingLinker();
                this.translateToJava(config);
                HashSet<YangNode> compiledSchemas = new HashSet<YangNode>();
                for (YangFileInfo fileInfo : this.yangFileInfoSet) {
                    compiledSchemas.add(fileInfo.getRootNode());
                }
                String serFileName = config.resourceGenDir() + YANG_META_DATA + SERIALIZED_FILE_EXTENSION;
                FileOutputStream fileOutputStream = new FileOutputStream(serFileName);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(compiledSchemas);
                objectOutputStream.close();
                fileOutputStream.close();
                List<File> files = YangToolManager.getListOfFile(this.yangFileInfoSet);
                String path = config.resourceGenDir();
                File targetDir = new File(path);
                targetDir.mkdirs();
                for (File file : files) {
                    Files.copy(file.toPath(), new File(path + file.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                if (plugin != null) {
                    plugin.addCompiledSchemaToBundle();
                    plugin.addGeneratedCodeToBundle();
                    plugin.addYangFilesToBundle();
                }
            }
            catch (IOException | ParserException e) {
                YangToolException exception = new YangToolException(e.getMessage(), e);
                exception.setCurYangFile(this.curYangFileInfo);
                if (this.curYangFileInfo != null && this.curYangFileInfo.getRootNode() != null) {
                    try {
                        JavaCodeGeneratorUtil.translatorErrorHandler((YangNode)this.curYangFileInfo.getRootNode(), (YangPluginConfig)config);
                    }
                    catch (IOException ex) {
                        e.printStackTrace();
                        throw ex;
                    }
                }
                throw exception;
            }
        }
    }

    private void addSchemaToFileSet(List<YangNode> dependentSchema) throws IOException {
        if (dependentSchema == null || dependentSchema.isEmpty()) {
            return;
        }
        for (YangNode node : dependentSchema) {
            YangFileInfo dependentFileInfo = new YangFileInfo();
            node.setToTranslate(false);
            dependentFileInfo.setRootNode(node);
            dependentFileInfo.setForTranslator(false);
            dependentFileInfo.setYangFileName(node.getName());
            this.yangFileInfoSet.add(dependentFileInfo);
        }
    }

    public void resolveDependenciesUsingLinker() {
        this.createYangNodeSet();
        try {
            this.yangLinker.resolveDependencies(this.yangNodeSet);
        }
        catch (LinkerException e) {
            this.printLog(e.getFileName(), e.getLineNumber(), e.getCharPositionInLine(), e.getMessage(), e.getLocalizedMessage());
            throw new YangToolException(e.getMessage());
        }
    }

    public void createYangNodeSet() {
        for (YangFileInfo yangFileInfo : this.yangFileInfoSet) {
            this.yangNodeSet.add(yangFileInfo.getRootNode());
        }
    }

    public void parseYangFileInfoSet() throws IOException {
        Iterator<YangFileInfo> iterator = this.yangFileInfoSet.iterator();
        while (iterator.hasNext()) {
            YangFileInfo yangFileInfo;
            this.curYangFileInfo = yangFileInfo = iterator.next();
            if (!yangFileInfo.isForTranslator()) continue;
            try {
                YangNode yangNode = this.yangUtilsParser.getDataModel(yangFileInfo.getYangFileName());
                yangFileInfo.setRootNode(yangNode);
                YangLinkerUtils.resolveGroupingInDefinationScope((YangReferenceResolver)((YangReferenceResolver)yangNode));
                try {
                    ((YangReferenceResolver)yangNode).resolveSelfFileLinking(ResolvableType.YANG_DERIVED_DATA_TYPE);
                    ((YangReferenceResolver)yangNode).resolveSelfFileLinking(ResolvableType.YANG_IDENTITYREF);
                }
                catch (DataModelException e) {
                    this.printLog(e.getFileName(), e.getLineNumber(), e.getCharPositionInLine(), e.getMessage(), e.getLocalizedMessage());
                }
            }
            catch (ParserException e) {
                this.printLog(e.getFileName(), e.getLineNumber(), e.getCharPositionInLine(), e.getMessage(), e.getLocalizedMessage());
                throw e;
            }
        }
    }

    public void translateToJava(YangPluginConfig pluginConfig) throws IOException {
        LinkedList<YangNode> yangNodeSortedList = new LinkedList<YangNode>();
        yangNodeSortedList.addAll(this.yangNodeSet);
        Collections.sort(yangNodeSortedList);
        for (YangNode node : yangNodeSortedList) {
            if (!node.isToTranslate()) continue;
            JavaCodeGeneratorUtil.generateJavaCode((YangNode)node, (YangPluginConfig)pluginConfig);
        }
    }

    private void printLog(String fileName, int line, int position, String msg, String localMsg) {
        String logInfo = "Error in file: " + fileName;
        if (line != 0) {
            logInfo = logInfo + " at line: " + line + " at position: " + position;
        }
        if (msg != null) {
            logInfo = logInfo + "\n" + localMsg;
        }
        log.info(logInfo);
    }
}

