// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver10;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFActionEnqueueVer10 implements OFActionEnqueue {
    private static final Logger logger = LoggerFactory.getLogger(OFActionEnqueueVer10.class);
    // version: 1.0
    final static byte WIRE_VERSION = 1;
    final static int LENGTH = 16;

        private final static OFPort DEFAULT_PORT = OFPort.ANY;
        private final static long DEFAULT_QUEUE_ID = 0x0L;

    // OF message fields
    private final OFPort port;
    private final long queueId;
//
    // Immutable default instance
    final static OFActionEnqueueVer10 DEFAULT = new OFActionEnqueueVer10(
        DEFAULT_PORT, DEFAULT_QUEUE_ID
    );

    // package private constructor - used by readers, builders, and factory
    OFActionEnqueueVer10(OFPort port, long queueId) {
        this.port = port;
        this.queueId = queueId;
    }

    // Accessors for OF message fields
    @Override
    public OFActionType getType() {
        return OFActionType.ENQUEUE;
    }

    @Override
    public OFPort getPort() {
        return port;
    }

    @Override
    public long getQueueId() {
        return queueId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }



    public OFActionEnqueue.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFActionEnqueue.Builder {
        final OFActionEnqueueVer10 parentMessage;

        // OF message fields
        private boolean portSet;
        private OFPort port;
        private boolean queueIdSet;
        private long queueId;

        BuilderWithParent(OFActionEnqueueVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public OFActionType getType() {
        return OFActionType.ENQUEUE;
    }

    @Override
    public OFPort getPort() {
        return port;
    }

    @Override
    public OFActionEnqueue.Builder setPort(OFPort port) {
        this.port = port;
        this.portSet = true;
        return this;
    }
    @Override
    public long getQueueId() {
        return queueId;
    }

    @Override
    public OFActionEnqueue.Builder setQueueId(long queueId) {
        this.queueId = queueId;
        this.queueIdSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }



        @Override
        public OFActionEnqueue build() {
                OFPort port = this.portSet ? this.port : parentMessage.port;
                if(port == null)
                    throw new NullPointerException("Property port must not be null");
                long queueId = this.queueIdSet ? this.queueId : parentMessage.queueId;

                //
                return new OFActionEnqueueVer10(
                    port,
                    queueId
                );
        }

    }

    static class Builder implements OFActionEnqueue.Builder {
        // OF message fields
        private boolean portSet;
        private OFPort port;
        private boolean queueIdSet;
        private long queueId;

    @Override
    public OFActionType getType() {
        return OFActionType.ENQUEUE;
    }

    @Override
    public OFPort getPort() {
        return port;
    }

    @Override
    public OFActionEnqueue.Builder setPort(OFPort port) {
        this.port = port;
        this.portSet = true;
        return this;
    }
    @Override
    public long getQueueId() {
        return queueId;
    }

    @Override
    public OFActionEnqueue.Builder setQueueId(long queueId) {
        this.queueId = queueId;
        this.queueIdSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

//
        @Override
        public OFActionEnqueue build() {
            OFPort port = this.portSet ? this.port : DEFAULT_PORT;
            if(port == null)
                throw new NullPointerException("Property port must not be null");
            long queueId = this.queueIdSet ? this.queueId : DEFAULT_QUEUE_ID;


            return new OFActionEnqueueVer10(
                    port,
                    queueId
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFActionEnqueue> {
        @Override
        public OFActionEnqueue readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property type == 11
            short type = bb.readShort();
            if(type != (short) 0xb)
                throw new OFParseError("Wrong type: Expected=OFActionType.ENQUEUE(11), got="+type);
            int length = U16.f(bb.readShort());
            if(length != 16)
                throw new OFParseError("Wrong length: Expected=16(16), got="+length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            OFPort port = OFPort.read2Bytes(bb);
            // pad: 6 bytes
            bb.skipBytes(6);
            long queueId = U32.f(bb.readInt());

            OFActionEnqueueVer10 actionEnqueueVer10 = new OFActionEnqueueVer10(
                    port,
                      queueId
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", actionEnqueueVer10);
            return actionEnqueueVer10;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFActionEnqueueVer10Funnel FUNNEL = new OFActionEnqueueVer10Funnel();
    static class OFActionEnqueueVer10Funnel implements Funnel<OFActionEnqueueVer10> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFActionEnqueueVer10 message, PrimitiveSink sink) {
            // fixed value property type = 11
            sink.putShort((short) 0xb);
            // fixed value property length = 16
            sink.putShort((short) 0x10);
            message.port.putTo(sink);
            // skip pad (6 bytes)
            sink.putLong(message.queueId);
        }
    }


    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFActionEnqueueVer10> {
        @Override
        public void write(ChannelBuffer bb, OFActionEnqueueVer10 message) {
            // fixed value property type = 11
            bb.writeShort((short) 0xb);
            // fixed value property length = 16
            bb.writeShort((short) 0x10);
            message.port.write2Bytes(bb);
            // pad: 6 bytes
            bb.writeZero(6);
            bb.writeInt(U32.t(message.queueId));


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFActionEnqueueVer10(");
        b.append("port=").append(port);
        b.append(", ");
        b.append("queueId=").append(queueId);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFActionEnqueueVer10 other = (OFActionEnqueueVer10) obj;

        if (port == null) {
            if (other.port != null)
                return false;
        } else if (!port.equals(other.port))
            return false;
        if( queueId != other.queueId)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((port == null) ? 0 : port.hashCode());
        result = prime *  (int) (queueId ^ (queueId >>> 32));
        return result;
    }

}
