// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFOxmVlanPcpVer13 implements OFOxmVlanPcp {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmVlanPcpVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 5;

        private final static VlanPcp DEFAULT_VALUE = VlanPcp.NONE;

    // OF message fields
    private final VlanPcp value;
//
    // Immutable default instance
    final static OFOxmVlanPcpVer13 DEFAULT = new OFOxmVlanPcpVer13(
        DEFAULT_VALUE
    );

    // package private constructor - used by readers, builders, and factory
    OFOxmVlanPcpVer13(VlanPcp value) {
        this.value = value;
    }

    // Accessors for OF message fields
    @Override
    public long getTypeLen() {
        return 0x80000e01L;
    }

    @Override
    public VlanPcp getValue() {
        return value;
    }

    @Override
    public MatchField<VlanPcp> getMatchField() {
        return MatchField.VLAN_PCP;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    public OFOxm<VlanPcp> getCanonical() {
        // exact match OXM is always canonical
        return this;
    }

    @Override
    public VlanPcp getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFOxmVlanPcp.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFOxmVlanPcp.Builder {
        final OFOxmVlanPcpVer13 parentMessage;

        // OF message fields
        private boolean valueSet;
        private VlanPcp value;

        BuilderWithParent(OFOxmVlanPcpVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public long getTypeLen() {
        return 0x80000e01L;
    }

    @Override
    public VlanPcp getValue() {
        return value;
    }

    @Override
    public OFOxmVlanPcp.Builder setValue(VlanPcp value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public MatchField<VlanPcp> getMatchField() {
        return MatchField.VLAN_PCP;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<VlanPcp> getCanonical()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
    }

    @Override
    public VlanPcp getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFOxmVlanPcp build() {
                VlanPcp value = this.valueSet ? this.value : parentMessage.value;
                if(value == null)
                    throw new NullPointerException("Property value must not be null");

                //
                return new OFOxmVlanPcpVer13(
                    value
                );
        }

    }

    static class Builder implements OFOxmVlanPcp.Builder {
        // OF message fields
        private boolean valueSet;
        private VlanPcp value;

    @Override
    public long getTypeLen() {
        return 0x80000e01L;
    }

    @Override
    public VlanPcp getValue() {
        return value;
    }

    @Override
    public OFOxmVlanPcp.Builder setValue(VlanPcp value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public MatchField<VlanPcp> getMatchField() {
        return MatchField.VLAN_PCP;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<VlanPcp> getCanonical()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
    }

    @Override
    public VlanPcp getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFOxmVlanPcp build() {
            VlanPcp value = this.valueSet ? this.value : DEFAULT_VALUE;
            if(value == null)
                throw new NullPointerException("Property value must not be null");


            return new OFOxmVlanPcpVer13(
                    value
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFOxmVlanPcp> {
        @Override
        public OFOxmVlanPcp readFrom(ChannelBuffer bb) throws OFParseError {
            // fixed value property typeLen == 0x80000e01L
            int typeLen = bb.readInt();
            if(typeLen != (int) 0x80000e01)
                throw new OFParseError("Wrong typeLen: Expected=0x80000e01L(0x80000e01L), got="+typeLen);
            VlanPcp value = VlanPcp.readByte(bb);

            OFOxmVlanPcpVer13 oxmVlanPcpVer13 = new OFOxmVlanPcpVer13(
                    value
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", oxmVlanPcpVer13);
            return oxmVlanPcpVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFOxmVlanPcpVer13Funnel FUNNEL = new OFOxmVlanPcpVer13Funnel();
    static class OFOxmVlanPcpVer13Funnel implements Funnel<OFOxmVlanPcpVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFOxmVlanPcpVer13 message, PrimitiveSink sink) {
            // fixed value property typeLen = 0x80000e01L
            sink.putInt((int) 0x80000e01);
            message.value.putTo(sink);
        }
    }


    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFOxmVlanPcpVer13> {
        @Override
        public void write(ChannelBuffer bb, OFOxmVlanPcpVer13 message) {
            // fixed value property typeLen = 0x80000e01L
            bb.writeInt((int) 0x80000e01);
            message.value.writeByte(bb);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmVlanPcpVer13(");
        b.append("value=").append(value);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFOxmVlanPcpVer13 other = (OFOxmVlanPcpVer13) obj;

        if (value == null) {
            if (other.value != null)
                return false;
        } else if (!value.equals(other.value))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((value == null) ? 0 : value.hashCode());
        return result;
    }

}
