/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFPacketOut;
import org.projectfloodlight.openflow.protocol.ver10.OFFactoryVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFPacketOutVer10;

public class OFPacketOutVer10Test {
    OFFactory factory;
    static final byte[] PACKET_OUT_SERIALIZED = new byte[]{1, 13, 0, 35, 18, 52, 86, 120, -85, -51, -17, 1, -1, -2, 0, 16, 0, 0, 0, 8, 0, 1, 0, 0, 0, 0, 0, 8, 0, 2, 0, 0, 97, 98, 99};

    @Before
    public void setup() {
        this.factory = OFFactoryVer10.INSTANCE;
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])PACKET_OUT_SERIALIZED);
        OFPacketOut packetOut = OFPacketOutVer10.READER.readFrom(input);
        Assert.assertEquals((long)PACKET_OUT_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        packetOut.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PACKET_OUT_SERIALIZED));
    }
}

