/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdOutput;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIds;
import org.projectfloodlight.openflow.protocol.ver13.OFActionIdOutputVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFActionIdsVer13;

public class OFActionIdOutputVer13Test {
    OFActionIds factory;
    static final byte[] ACTION_ID_OUTPUT_SERIALIZED = new byte[]{0, 0, 0, 4};

    @Before
    public void setup() {
        this.factory = OFActionIdsVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFActionIdOutput actionIdOutput = this.factory.output();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        actionIdOutput.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ACTION_ID_OUTPUT_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFActionIdOutput actionIdOutputBuilt = this.factory.output();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])ACTION_ID_OUTPUT_SERIALIZED);
        OFActionIdOutput actionIdOutputRead = OFActionIdOutputVer13.READER.readFrom(input);
        Assert.assertEquals((long)ACTION_ID_OUTPUT_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)actionIdOutputBuilt, (Object)actionIdOutputRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])ACTION_ID_OUTPUT_SERIALIZED);
        OFActionIdOutput actionIdOutput = OFActionIdOutputVer13.READER.readFrom(input);
        Assert.assertEquals((long)ACTION_ID_OUTPUT_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        actionIdOutput.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ACTION_ID_OUTPUT_SERIALIZED));
    }
}

