/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.action.OFActionOutput;
import org.projectfloodlight.openflow.protocol.action.OFActions;
import org.projectfloodlight.openflow.protocol.ver13.OFActionOutputVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFActionsVer13;
import org.projectfloodlight.openflow.types.OFPort;

public class OFActionOutputVer13Test {
    OFActions factory;
    static final byte[] ACTION_OUTPUT_SERIALIZED = new byte[]{0, 0, 0, 16, 0, 0, 0, 50, -1, -1, 0, 0, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFActionsVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFActionOutput.Builder builder = this.factory.buildOutput();
        builder.setPort(OFPort.of((int)50)).setMaxLen(65535);
        OFActionOutput actionOutput = builder.build();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        actionOutput.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ACTION_OUTPUT_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFActionOutput.Builder builder = this.factory.buildOutput();
        builder.setPort(OFPort.of((int)50)).setMaxLen(65535);
        OFActionOutput actionOutputBuilt = builder.build();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])ACTION_OUTPUT_SERIALIZED);
        OFActionOutput actionOutputRead = OFActionOutputVer13.READER.readFrom(input);
        Assert.assertEquals((long)ACTION_OUTPUT_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)actionOutputBuilt, (Object)actionOutputRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])ACTION_OUTPUT_SERIALIZED);
        OFActionOutput actionOutput = OFActionOutputVer13.READER.readFrom(input);
        Assert.assertEquals((long)ACTION_OUTPUT_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        actionOutput.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ACTION_OUTPUT_SERIALIZED));
    }
}

