/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetField;
import org.projectfloodlight.openflow.protocol.action.OFActions;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxms;
import org.projectfloodlight.openflow.protocol.ver13.OFActionSetFieldVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFActionsVer13;
import org.projectfloodlight.openflow.types.IPv6Address;

public class OFActionSetFieldVer13Ipv6SrcTest {
    OFActions factory;
    static final byte[] ACTION_SET_FIELD_SERIALIZED = new byte[]{0, 25, 0, 24, -128, 0, 52, 16, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};

    @Before
    public void setup() {
        this.factory = OFActionsVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFActionSetField.Builder builder = this.factory.buildSetField();
        OFOxms oxms = OFFactories.getFactory((OFVersion)OFVersion.OF_13).oxms();
        builder.setField((OFOxm)oxms.ipv6Src(IPv6Address.of((String)"0001:0203:0405:0607:0809:0a0b:0c0d:0e0f")));
        OFActionSetField actionSetField = builder.build();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        actionSetField.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ACTION_SET_FIELD_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFActionSetField.Builder builder = this.factory.buildSetField();
        OFOxms oxms = OFFactories.getFactory((OFVersion)OFVersion.OF_13).oxms();
        builder.setField((OFOxm)oxms.ipv6Src(IPv6Address.of((String)"0001:0203:0405:0607:0809:0a0b:0c0d:0e0f")));
        OFActionSetField actionSetFieldBuilt = builder.build();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])ACTION_SET_FIELD_SERIALIZED);
        OFActionSetField actionSetFieldRead = OFActionSetFieldVer13.READER.readFrom(input);
        Assert.assertEquals((long)ACTION_SET_FIELD_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)actionSetFieldBuilt, (Object)actionSetFieldRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])ACTION_SET_FIELD_SERIALIZED);
        OFActionSetField actionSetField = OFActionSetFieldVer13.READER.readFrom(input);
        Assert.assertEquals((long)ACTION_SET_FIELD_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        actionSetField.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ACTION_SET_FIELD_SERIALIZED));
    }
}

