/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.Sets;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFConfigFlags;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFGetConfigReply;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFGetConfigReplyVer13;

public class OFGetConfigReplyVer13Test {
    OFFactory factory;
    static final byte[] GET_CONFIG_REPLY_SERIALIZED = new byte[]{4, 8, 0, 12, 18, 52, 86, 120, 0, 2, -1, -1};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFGetConfigReply.Builder builder = this.factory.buildGetConfigReply();
        builder.setXid(305419896L).setFlags((Set)Sets.immutableEnumSet((Enum)OFConfigFlags.FRAG_REASM, (Enum[])new OFConfigFlags[0])).setMissSendLen(65535).build();
        OFGetConfigReply getConfigReply = builder.build();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        getConfigReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GET_CONFIG_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFGetConfigReply.Builder builder = this.factory.buildGetConfigReply();
        builder.setXid(305419896L).setFlags((Set)Sets.immutableEnumSet((Enum)OFConfigFlags.FRAG_REASM, (Enum[])new OFConfigFlags[0])).setMissSendLen(65535).build();
        OFGetConfigReply getConfigReplyBuilt = builder.build();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])GET_CONFIG_REPLY_SERIALIZED);
        OFGetConfigReply getConfigReplyRead = OFGetConfigReplyVer13.READER.readFrom(input);
        Assert.assertEquals((long)GET_CONFIG_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)getConfigReplyBuilt, (Object)getConfigReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])GET_CONFIG_REPLY_SERIALIZED);
        OFGetConfigReply getConfigReply = OFGetConfigReplyVer13.READER.readFrom(input);
        Assert.assertEquals((long)GET_CONFIG_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        getConfigReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GET_CONFIG_REPLY_SERIALIZED));
    }
}

