/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.Assert;
import org.junit.Test;
import org.projectfloodlight.openflow.types.IPAddress;
import org.projectfloodlight.openflow.types.IPAddressWithMask;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.IPv6Address;

public class IPAddressTest {
    @Test
    public void testOfException() {
        try {
            IPAddress.of((String)"Foobar");
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            IPAddressWithMask.of((String)"Foobar");
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            IPAddress.of((String)null);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            IPAddressWithMask.of(null);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            IPAddress.of((String)null);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            IPAddressWithMask.of(null);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testOfString() {
        IPAddress ip0 = IPAddress.of((String)"1.2.3.4");
        IPAddress ip1 = IPAddress.of((String)"abcd::1234");
        Assert.assertTrue((boolean)(ip0 instanceof IPv4Address));
        Assert.assertTrue((boolean)(ip1 instanceof IPv6Address));
        Assert.assertEquals((Object)ip0, (Object)IPv4Address.of((String)"1.2.3.4"));
        Assert.assertEquals((Object)ip1, (Object)IPv6Address.of((String)"abcd::1234"));
    }

    @Test
    public void testOfInetAddress() throws Exception {
        InetAddress ia0 = InetAddress.getByName("192.168.1.123");
        InetAddress ia1 = InetAddress.getByName("fd00::4321");
        IPAddress ip0 = IPAddress.of((InetAddress)ia0);
        IPAddress ip1 = IPAddress.of((InetAddress)ia1);
        Assert.assertTrue((boolean)(ip0 instanceof IPv4Address));
        Assert.assertTrue((boolean)(ip1 instanceof IPv6Address));
        Assert.assertEquals((Object)ip0, (Object)IPv4Address.of((InetAddress)ia0));
        Assert.assertEquals((Object)ip1, (Object)IPv6Address.of((InetAddress)ia1));
    }

    @Test
    public void testFromInetAddressException() throws UnknownHostException {
        try {
            IPAddress.fromInetAddress(null);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testContains() {
        IPAddressWithMask mask = IPAddressWithMask.of((String)"1.2.3.4/24");
        IPAddress validIp = IPAddress.of((String)"1.2.3.5");
        Assert.assertTrue((boolean)mask.contains(validIp));
        IPAddress invalidIp = IPAddress.of((String)"1.2.5.5");
        Assert.assertFalse((boolean)mask.contains(invalidIp));
        IPAddress invalidIpv6 = IPAddress.of((String)"10:10::ffff");
        Assert.assertFalse((boolean)mask.contains(invalidIpv6));
        mask = IPAddressWithMask.of((String)"10:10::1/112");
        validIp = IPAddress.of((String)"10:10::f");
        Assert.assertTrue((boolean)mask.contains(validIp));
        invalidIp = IPAddress.of((String)"11:10::f");
        Assert.assertFalse((boolean)mask.contains(invalidIp));
        IPAddress invalidIpv4 = IPAddress.of((String)"10.0.0.1");
        Assert.assertFalse((boolean)mask.contains(invalidIpv4));
    }

    @Test
    public void testContainsException() {
        try {
            IPAddressWithMask mask = IPAddressWithMask.of((String)"1.2.3.4/24");
            mask.contains(null);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }
}

