/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.projectfloodlight.openflow.types.OFBitMask128;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFPortBitMap;

public class OFPortBitMapTest
extends TestCase {
    @Test
    public void testCreateAndIterate() {
        OFPortBitMap map = OFPortBitMap.ofPorts((OFPort[])new OFPort[]{OFPort.of((int)1), OFPort.of((int)2), OFPort.of((int)5)});
        Assert.assertThat((Object)map.getOnPorts(), (Matcher)Matchers.contains((Object[])new OFPort[]{OFPort.of((int)1), OFPort.of((int)2), OFPort.of((int)5)}));
    }

    @Test
    public void testOFBitMap() {
        OFBitMask128 bitmap = OFBitMask128.of((long)-1L, (long)-39L);
        OFPortBitMap map = OFPortBitMap.of((OFBitMask128)bitmap);
        Assert.assertThat((Object)map.getOnPorts(), (Matcher)Matchers.contains((Object[])new OFPort[]{OFPort.of((int)1), OFPort.of((int)2), OFPort.of((int)5)}));
    }

    @Test
    public void testOFPortBitMap() {
        int i;
        Object[] on = new Boolean[127];
        for (int i2 = 0; i2 < 127; ++i2) {
            on[i2] = false;
        }
        OFPortBitMap.Builder builder = new OFPortBitMap.Builder();
        for (int i3 = 0; i3 < 127; i3 += 3) {
            OFPort p = OFPort.of((int)i3);
            builder.set(p);
            on[p.getPortNumber()] = true;
        }
        OFPortBitMap portmap = builder.build();
        Object[] actual = new Boolean[127];
        for (i = 0; i < 127; ++i) {
            actual[i] = false;
        }
        for (i = 0; i < 127; ++i) {
            actual[i] = portmap.isOn(OFPort.of((int)i));
        }
        Assert.assertArrayEquals((Object[])on, (Object[])actual);
        for (i = 0; i < 127; i += 7) {
            on[i] = false;
            builder.unset(OFPort.of((int)i));
        }
        portmap = builder.build();
        actual = new Boolean[127];
        for (i = 0; i < 127; ++i) {
            actual[i] = false;
        }
        for (i = 0; i < 127; ++i) {
            actual[i] = portmap.isOn(OFPort.of((int)i));
        }
        Assert.assertArrayEquals((Object[])on, (Object[])actual);
    }
}

