/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetNwDst;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetNwDstVer10
implements OFActionSetNwDst {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetNwDstVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 8;
    private static final IPv4Address DEFAULT_NW_ADDR = IPv4Address.NONE;
    private final IPv4Address nwAddr;
    static final OFActionSetNwDstVer10 DEFAULT = new OFActionSetNwDstVer10(DEFAULT_NW_ADDR);
    static final Reader READER = new Reader();
    static final OFActionSetNwDstVer10Funnel FUNNEL = new OFActionSetNwDstVer10Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetNwDstVer10(IPv4Address nwAddr) {
        this.nwAddr = nwAddr;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_NW_DST;
    }

    @Override
    public IPv4Address getNwAddr() {
        return this.nwAddr;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFActionSetNwDst.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetNwDstVer10(");
        b.append("nwAddr=").append(this.nwAddr);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetNwDstVer10 other = (OFActionSetNwDstVer10)obj;
        return !(this.nwAddr == null ? other.nwAddr != null : !this.nwAddr.equals(other.nwAddr));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nwAddr == null ? 0 : this.nwAddr.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetNwDstVer10> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionSetNwDstVer10 message) {
            bb.writeShort(7);
            bb.writeShort(8);
            message.nwAddr.write4Bytes(bb);
        }
    }

    static class OFActionSetNwDstVer10Funnel
    implements Funnel<OFActionSetNwDstVer10> {
        private static final long serialVersionUID = 1L;

        OFActionSetNwDstVer10Funnel() {
        }

        public void funnel(OFActionSetNwDstVer10 message, PrimitiveSink sink) {
            sink.putShort((short)7);
            sink.putShort((short)8);
            message.nwAddr.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetNwDst> {
        Reader() {
        }

        @Override
        public OFActionSetNwDst readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 7) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_NW_DST(7), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            IPv4Address nwAddr = IPv4Address.read4Bytes(bb);
            OFActionSetNwDstVer10 actionSetNwDstVer10 = new OFActionSetNwDstVer10(nwAddr);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetNwDstVer10);
            }
            return actionSetNwDstVer10;
        }
    }

    static class Builder
    implements OFActionSetNwDst.Builder {
        private boolean nwAddrSet;
        private IPv4Address nwAddr;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_NW_DST;
        }

        @Override
        public IPv4Address getNwAddr() {
            return this.nwAddr;
        }

        @Override
        public OFActionSetNwDst.Builder setNwAddr(IPv4Address nwAddr) {
            this.nwAddr = nwAddr;
            this.nwAddrSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFActionSetNwDst build() {
            IPv4Address nwAddr;
            IPv4Address iPv4Address = nwAddr = this.nwAddrSet ? this.nwAddr : DEFAULT_NW_ADDR;
            if (nwAddr == null) {
                throw new NullPointerException("Property nwAddr must not be null");
            }
            return new OFActionSetNwDstVer10(nwAddr);
        }
    }

    static class BuilderWithParent
    implements OFActionSetNwDst.Builder {
        final OFActionSetNwDstVer10 parentMessage;
        private boolean nwAddrSet;
        private IPv4Address nwAddr;

        BuilderWithParent(OFActionSetNwDstVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_NW_DST;
        }

        @Override
        public IPv4Address getNwAddr() {
            return this.nwAddr;
        }

        @Override
        public OFActionSetNwDst.Builder setNwAddr(IPv4Address nwAddr) {
            this.nwAddr = nwAddr;
            this.nwAddrSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFActionSetNwDst build() {
            IPv4Address nwAddr;
            IPv4Address iPv4Address = nwAddr = this.nwAddrSet ? this.nwAddr : this.parentMessage.nwAddr;
            if (nwAddr == null) {
                throw new NullPointerException("Property nwAddr must not be null");
            }
            return new OFActionSetNwDstVer10(nwAddr);
        }
    }
}

