/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBarrierRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBarrierRequestVer10
implements OFBarrierRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBarrierRequestVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 8;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    static final OFBarrierRequestVer10 DEFAULT = new OFBarrierRequestVer10(0L);
    static final Reader READER = new Reader();
    static final OFBarrierRequestVer10Funnel FUNNEL = new OFBarrierRequestVer10Funnel();
    static final Writer WRITER = new Writer();

    OFBarrierRequestVer10(long xid) {
        this.xid = xid;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFType getType() {
        return OFType.BARRIER_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFBarrierRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBarrierRequestVer10(");
        b.append("xid=").append(this.xid);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBarrierRequestVer10 other = (OFBarrierRequestVer10)obj;
        return this.xid == other.xid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBarrierRequestVer10> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBarrierRequestVer10 message) {
            bb.writeByte(1);
            bb.writeByte(18);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.xid));
        }
    }

    static class OFBarrierRequestVer10Funnel
    implements Funnel<OFBarrierRequestVer10> {
        private static final long serialVersionUID = 1L;

        OFBarrierRequestVer10Funnel() {
        }

        public void funnel(OFBarrierRequestVer10 message, PrimitiveSink sink) {
            sink.putByte((byte)1);
            sink.putByte((byte)18);
            sink.putShort((short)8);
            sink.putLong(message.xid);
        }
    }

    static class Reader
    implements OFMessageReader<OFBarrierRequest> {
        Reader() {
        }

        @Override
        public OFBarrierRequest readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.BARRIER_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFBarrierRequestVer10 barrierRequestVer10 = new OFBarrierRequestVer10(xid);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)barrierRequestVer10);
            }
            return barrierRequestVer10;
        }
    }

    static class Builder
    implements OFBarrierRequest.Builder {
        private boolean xidSet;
        private long xid;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.BARRIER_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBarrierRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFBarrierRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            return new OFBarrierRequestVer10(xid);
        }
    }

    static class BuilderWithParent
    implements OFBarrierRequest.Builder {
        final OFBarrierRequestVer10 parentMessage;
        private boolean xidSet;
        private long xid;

        BuilderWithParent(OFBarrierRequestVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.BARRIER_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBarrierRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFBarrierRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            return new OFBarrierRequestVer10(xid);
        }
    }
}

