/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFlowModCommand;
import org.projectfloodlight.openflow.protocol.OFFlowModFlags;
import org.projectfloodlight.openflow.protocol.OFFlowModify;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.projectfloodlight.openflow.protocol.instruction.OFInstruction;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.ver10.ChannelUtilsVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFActionVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFFactoryVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFFlowModFlagsSerializerVer10;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFFlowModifyVer10
implements OFFlowModify {
    private static final Logger logger = LoggerFactory.getLogger(OFFlowModifyVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int MINIMUM_LENGTH = 72;
    private static final long DEFAULT_XID = 0L;
    private static final Match DEFAULT_MATCH = OFFactoryVer10.MATCH_WILDCARD_ALL;
    private static final U64 DEFAULT_COOKIE = U64.ZERO;
    private static final int DEFAULT_IDLE_TIMEOUT = 0;
    private static final int DEFAULT_HARD_TIMEOUT = 0;
    private static final int DEFAULT_PRIORITY = 0;
    private static final OFBufferId DEFAULT_BUFFER_ID = OFBufferId.NO_BUFFER;
    private static final OFPort DEFAULT_OUT_PORT = OFPort.ANY;
    private static final Set<OFFlowModFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final List<OFAction> DEFAULT_ACTIONS = ImmutableList.of();
    private final long xid;
    private final Match match;
    private final U64 cookie;
    private final int idleTimeout;
    private final int hardTimeout;
    private final int priority;
    private final OFBufferId bufferId;
    private final OFPort outPort;
    private final Set<OFFlowModFlags> flags;
    private final List<OFAction> actions;
    static final OFFlowModifyVer10 DEFAULT = new OFFlowModifyVer10(0L, DEFAULT_MATCH, DEFAULT_COOKIE, 0, 0, 0, DEFAULT_BUFFER_ID, DEFAULT_OUT_PORT, DEFAULT_FLAGS, DEFAULT_ACTIONS);
    static final Reader READER = new Reader();
    static final OFFlowModifyVer10Funnel FUNNEL = new OFFlowModifyVer10Funnel();
    static final Writer WRITER = new Writer();

    OFFlowModifyVer10(long xid, Match match, U64 cookie, int idleTimeout, int hardTimeout, int priority, OFBufferId bufferId, OFPort outPort, Set<OFFlowModFlags> flags, List<OFAction> actions) {
        this.xid = xid;
        this.match = match;
        this.cookie = cookie;
        this.idleTimeout = idleTimeout;
        this.hardTimeout = hardTimeout;
        this.priority = priority;
        this.bufferId = bufferId;
        this.outPort = outPort;
        this.flags = flags;
        this.actions = actions;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFType getType() {
        return OFType.FLOW_MOD;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public U64 getCookie() {
        return this.cookie;
    }

    @Override
    public U64 getCookieMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property cookieMask not supported in version 1.0");
    }

    @Override
    public TableId getTableId() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property tableId not supported in version 1.0");
    }

    @Override
    public OFFlowModCommand getCommand() {
        return OFFlowModCommand.MODIFY;
    }

    @Override
    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public int getHardTimeout() {
        return this.hardTimeout;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public OFBufferId getBufferId() {
        return this.bufferId;
    }

    @Override
    public OFPort getOutPort() {
        return this.outPort;
    }

    @Override
    public OFGroup getOutGroup() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property outGroup not supported in version 1.0");
    }

    @Override
    public Set<OFFlowModFlags> getFlags() {
        return this.flags;
    }

    @Override
    public Match getMatch() {
        return this.match;
    }

    @Override
    public List<OFInstruction> getInstructions() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property instructions not supported in version 1.0");
    }

    @Override
    public List<OFAction> getActions() {
        return this.actions;
    }

    @Override
    public OFFlowModify.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFFlowModifyVer10(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("match=").append(this.match);
        b.append(", ");
        b.append("cookie=").append(this.cookie);
        b.append(", ");
        b.append("idleTimeout=").append(this.idleTimeout);
        b.append(", ");
        b.append("hardTimeout=").append(this.hardTimeout);
        b.append(", ");
        b.append("priority=").append(this.priority);
        b.append(", ");
        b.append("bufferId=").append(this.bufferId);
        b.append(", ");
        b.append("outPort=").append(this.outPort);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("actions=").append(this.actions);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFlowModifyVer10 other = (OFFlowModifyVer10)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        if (this.cookie == null ? other.cookie != null : !this.cookie.equals(other.cookie)) {
            return false;
        }
        if (this.idleTimeout != other.idleTimeout) {
            return false;
        }
        if (this.hardTimeout != other.hardTimeout) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.bufferId == null ? other.bufferId != null : !this.bufferId.equals(other.bufferId)) {
            return false;
        }
        if (this.outPort == null ? other.outPort != null : !this.outPort.equals(other.outPort)) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.actions == null ? other.actions != null : !this.actions.equals(other.actions));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * result + (this.cookie == null ? 0 : this.cookie.hashCode());
        result = 31 * result + this.idleTimeout;
        result = 31 * result + this.hardTimeout;
        result = 31 * result + this.priority;
        result = 31 * result + (this.bufferId == null ? 0 : this.bufferId.hashCode());
        result = 31 * result + (this.outPort == null ? 0 : this.outPort.hashCode());
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFFlowModifyVer10> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFFlowModifyVer10 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(1);
            bb.writeByte(14);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            message.match.writeTo(bb);
            bb.writeLong(message.cookie.getValue());
            bb.writeShort(1);
            bb.writeShort((int)U16.t(message.idleTimeout));
            bb.writeShort((int)U16.t(message.hardTimeout));
            bb.writeShort((int)U16.t(message.priority));
            bb.writeInt(message.bufferId.getInt());
            message.outPort.write2Bytes(bb);
            OFFlowModFlagsSerializerVer10.writeTo(bb, message.flags);
            ChannelUtils.writeList(bb, message.actions);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFFlowModifyVer10Funnel
    implements Funnel<OFFlowModifyVer10> {
        private static final long serialVersionUID = 1L;

        OFFlowModifyVer10Funnel() {
        }

        public void funnel(OFFlowModifyVer10 message, PrimitiveSink sink) {
            sink.putByte((byte)1);
            sink.putByte((byte)14);
            sink.putLong(message.xid);
            message.match.putTo(sink);
            message.cookie.putTo(sink);
            sink.putShort((short)1);
            sink.putInt(message.idleTimeout);
            sink.putInt(message.hardTimeout);
            sink.putInt(message.priority);
            message.bufferId.putTo(sink);
            message.outPort.putTo(sink);
            OFFlowModFlagsSerializerVer10.putTo(message.flags, sink);
            FunnelUtils.putList(message.actions, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFFlowModify> {
        Reader() {
        }

        @Override
        public OFFlowModify readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 14) {
                throw new OFParseError("Wrong type: Expected=OFType.FLOW_MOD(14), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 72) {
                throw new OFParseError("Wrong length: Expected to be >= 72, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            Match match = ChannelUtilsVer10.readOFMatch(bb);
            U64 cookie = U64.ofRaw(bb.readLong());
            short command = bb.readShort();
            if (command != 1) {
                throw new OFParseError("Wrong command: Expected=OFFlowModCommand.MODIFY(1), got=" + command);
            }
            int idleTimeout = U16.f(bb.readShort());
            int hardTimeout = U16.f(bb.readShort());
            int priority = U16.f(bb.readShort());
            OFBufferId bufferId = OFBufferId.of(bb.readInt());
            OFPort outPort = OFPort.read2Bytes(bb);
            Set<OFFlowModFlags> flags = OFFlowModFlagsSerializerVer10.readFrom(bb);
            List<OFAction> actions = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFActionVer10.READER);
            OFFlowModifyVer10 flowModifyVer10 = new OFFlowModifyVer10(xid, match, cookie, idleTimeout, hardTimeout, priority, bufferId, outPort, flags, actions);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)flowModifyVer10);
            }
            return flowModifyVer10;
        }
    }

    static class Builder
    implements OFFlowModify.Builder {
        private boolean xidSet;
        private long xid;
        private boolean matchSet;
        private Match match;
        private boolean cookieSet;
        private U64 cookie;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean prioritySet;
        private int priority;
        private boolean bufferIdSet;
        private OFBufferId bufferId;
        private boolean outPortSet;
        private OFPort outPort;
        private boolean flagsSet;
        private Set<OFFlowModFlags> flags;
        private boolean actionsSet;
        private List<OFAction> actions;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.FLOW_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFlowModify.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFFlowModify.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public U64 getCookieMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookieMask not supported in version 1.0");
        }

        @Override
        public OFFlowModify.Builder setCookieMask(U64 cookieMask) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookieMask not supported in version 1.0");
        }

        @Override
        public TableId getTableId() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property tableId not supported in version 1.0");
        }

        @Override
        public OFFlowModify.Builder setTableId(TableId tableId) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property tableId not supported in version 1.0");
        }

        @Override
        public OFFlowModCommand getCommand() {
            return OFFlowModCommand.MODIFY;
        }

        @Override
        public int getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public OFFlowModify.Builder setIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.idleTimeoutSet = true;
            return this;
        }

        @Override
        public int getHardTimeout() {
            return this.hardTimeout;
        }

        @Override
        public OFFlowModify.Builder setHardTimeout(int hardTimeout) {
            this.hardTimeout = hardTimeout;
            this.hardTimeoutSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFFlowModify.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public OFBufferId getBufferId() {
            return this.bufferId;
        }

        @Override
        public OFFlowModify.Builder setBufferId(OFBufferId bufferId) {
            this.bufferId = bufferId;
            this.bufferIdSet = true;
            return this;
        }

        @Override
        public OFPort getOutPort() {
            return this.outPort;
        }

        @Override
        public OFFlowModify.Builder setOutPort(OFPort outPort) {
            this.outPort = outPort;
            this.outPortSet = true;
            return this;
        }

        @Override
        public OFGroup getOutGroup() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property outGroup not supported in version 1.0");
        }

        @Override
        public OFFlowModify.Builder setOutGroup(OFGroup outGroup) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property outGroup not supported in version 1.0");
        }

        @Override
        public Set<OFFlowModFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFFlowModify.Builder setFlags(Set<OFFlowModFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFFlowModify.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public List<OFInstruction> getInstructions() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property instructions not supported in version 1.0");
        }

        @Override
        public OFFlowModify.Builder setInstructions(List<OFInstruction> instructions) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property instructions not supported in version 1.0");
        }

        @Override
        public List<OFAction> getActions() {
            return this.actions;
        }

        @Override
        public OFFlowModify.Builder setActions(List<OFAction> actions) {
            this.actions = actions;
            this.actionsSet = true;
            return this;
        }

        @Override
        public OFFlowModify build() {
            List<OFAction> actions;
            Set<OFFlowModFlags> flags;
            OFPort outPort;
            OFBufferId bufferId;
            U64 cookie;
            Match match;
            long xid = this.xidSet ? this.xid : 0L;
            Match match2 = match = this.matchSet ? this.match : DEFAULT_MATCH;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            U64 u64 = cookie = this.cookieSet ? this.cookie : DEFAULT_COOKIE;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : 0;
            int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : 0;
            int priority = this.prioritySet ? this.priority : 0;
            OFBufferId oFBufferId = bufferId = this.bufferIdSet ? this.bufferId : DEFAULT_BUFFER_ID;
            if (bufferId == null) {
                throw new NullPointerException("Property bufferId must not be null");
            }
            OFPort oFPort = outPort = this.outPortSet ? this.outPort : DEFAULT_OUT_PORT;
            if (outPort == null) {
                throw new NullPointerException("Property outPort must not be null");
            }
            Set<OFFlowModFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List<OFAction> list = actions = this.actionsSet ? this.actions : DEFAULT_ACTIONS;
            if (actions == null) {
                throw new NullPointerException("Property actions must not be null");
            }
            return new OFFlowModifyVer10(xid, match, cookie, idleTimeout, hardTimeout, priority, bufferId, outPort, flags, actions);
        }
    }

    static class BuilderWithParent
    implements OFFlowModify.Builder {
        final OFFlowModifyVer10 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean matchSet;
        private Match match;
        private boolean cookieSet;
        private U64 cookie;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean prioritySet;
        private int priority;
        private boolean bufferIdSet;
        private OFBufferId bufferId;
        private boolean outPortSet;
        private OFPort outPort;
        private boolean flagsSet;
        private Set<OFFlowModFlags> flags;
        private boolean actionsSet;
        private List<OFAction> actions;

        BuilderWithParent(OFFlowModifyVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.FLOW_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFlowModify.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFFlowModify.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public U64 getCookieMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookieMask not supported in version 1.0");
        }

        @Override
        public OFFlowModify.Builder setCookieMask(U64 cookieMask) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookieMask not supported in version 1.0");
        }

        @Override
        public TableId getTableId() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property tableId not supported in version 1.0");
        }

        @Override
        public OFFlowModify.Builder setTableId(TableId tableId) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property tableId not supported in version 1.0");
        }

        @Override
        public OFFlowModCommand getCommand() {
            return OFFlowModCommand.MODIFY;
        }

        @Override
        public int getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public OFFlowModify.Builder setIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.idleTimeoutSet = true;
            return this;
        }

        @Override
        public int getHardTimeout() {
            return this.hardTimeout;
        }

        @Override
        public OFFlowModify.Builder setHardTimeout(int hardTimeout) {
            this.hardTimeout = hardTimeout;
            this.hardTimeoutSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFFlowModify.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public OFBufferId getBufferId() {
            return this.bufferId;
        }

        @Override
        public OFFlowModify.Builder setBufferId(OFBufferId bufferId) {
            this.bufferId = bufferId;
            this.bufferIdSet = true;
            return this;
        }

        @Override
        public OFPort getOutPort() {
            return this.outPort;
        }

        @Override
        public OFFlowModify.Builder setOutPort(OFPort outPort) {
            this.outPort = outPort;
            this.outPortSet = true;
            return this;
        }

        @Override
        public OFGroup getOutGroup() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property outGroup not supported in version 1.0");
        }

        @Override
        public OFFlowModify.Builder setOutGroup(OFGroup outGroup) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property outGroup not supported in version 1.0");
        }

        @Override
        public Set<OFFlowModFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFFlowModify.Builder setFlags(Set<OFFlowModFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFFlowModify.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public List<OFInstruction> getInstructions() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property instructions not supported in version 1.0");
        }

        @Override
        public OFFlowModify.Builder setInstructions(List<OFInstruction> instructions) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property instructions not supported in version 1.0");
        }

        @Override
        public List<OFAction> getActions() {
            return this.actions;
        }

        @Override
        public OFFlowModify.Builder setActions(List<OFAction> actions) {
            this.actions = actions;
            this.actionsSet = true;
            return this;
        }

        @Override
        public OFFlowModify build() {
            List actions;
            Set flags;
            OFPort outPort;
            OFBufferId bufferId;
            U64 cookie;
            Match match;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Match match2 = match = this.matchSet ? this.match : this.parentMessage.match;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            U64 u64 = cookie = this.cookieSet ? this.cookie : this.parentMessage.cookie;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : this.parentMessage.idleTimeout;
            int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : this.parentMessage.hardTimeout;
            int priority = this.prioritySet ? this.priority : this.parentMessage.priority;
            OFBufferId oFBufferId = bufferId = this.bufferIdSet ? this.bufferId : this.parentMessage.bufferId;
            if (bufferId == null) {
                throw new NullPointerException("Property bufferId must not be null");
            }
            OFPort oFPort = outPort = this.outPortSet ? this.outPort : this.parentMessage.outPort;
            if (outPort == null) {
                throw new NullPointerException("Property outPort must not be null");
            }
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List list = actions = this.actionsSet ? this.actions : this.parentMessage.actions;
            if (actions == null) {
                throw new NullPointerException("Property actions must not be null");
            }
            return new OFFlowModifyVer10(xid, match, cookie, idleTimeout, hardTimeout, priority, bufferId, outPort, flags, actions);
        }
    }
}

