/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFlowRemoved;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.ver10.ChannelUtilsVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFFactoryVer10;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFFlowRemovedVer10
implements OFFlowRemoved {
    private static final Logger logger = LoggerFactory.getLogger(OFFlowRemovedVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 88;
    private static final long DEFAULT_XID = 0L;
    private static final Match DEFAULT_MATCH = OFFactoryVer10.MATCH_WILDCARD_ALL;
    private static final U64 DEFAULT_COOKIE = U64.ZERO;
    private static final int DEFAULT_PRIORITY = 0;
    private static final short DEFAULT_REASON = 0;
    private static final long DEFAULT_DURATION_SEC = 0L;
    private static final long DEFAULT_DURATION_NSEC = 0L;
    private static final int DEFAULT_IDLE_TIMEOUT = 0;
    private static final U64 DEFAULT_PACKET_COUNT = U64.ZERO;
    private static final U64 DEFAULT_BYTE_COUNT = U64.ZERO;
    private final long xid;
    private final Match match;
    private final U64 cookie;
    private final int priority;
    private final short reason;
    private final long durationSec;
    private final long durationNsec;
    private final int idleTimeout;
    private final U64 packetCount;
    private final U64 byteCount;
    static final OFFlowRemovedVer10 DEFAULT = new OFFlowRemovedVer10(0L, DEFAULT_MATCH, DEFAULT_COOKIE, 0, 0, 0L, 0L, 0, DEFAULT_PACKET_COUNT, DEFAULT_BYTE_COUNT);
    static final Reader READER = new Reader();
    static final OFFlowRemovedVer10Funnel FUNNEL = new OFFlowRemovedVer10Funnel();
    static final Writer WRITER = new Writer();

    OFFlowRemovedVer10(long xid, Match match, U64 cookie, int priority, short reason, long durationSec, long durationNsec, int idleTimeout, U64 packetCount, U64 byteCount) {
        this.xid = xid;
        this.match = match;
        this.cookie = cookie;
        this.priority = priority;
        this.reason = reason;
        this.durationSec = durationSec;
        this.durationNsec = durationNsec;
        this.idleTimeout = idleTimeout;
        this.packetCount = packetCount;
        this.byteCount = byteCount;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFType getType() {
        return OFType.FLOW_REMOVED;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public U64 getCookie() {
        return this.cookie;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public short getReason() {
        return this.reason;
    }

    @Override
    public TableId getTableId() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property tableId not supported in version 1.0");
    }

    @Override
    public long getDurationSec() {
        return this.durationSec;
    }

    @Override
    public long getDurationNsec() {
        return this.durationNsec;
    }

    @Override
    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public int getHardTimeout() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property hardTimeout not supported in version 1.0");
    }

    @Override
    public U64 getPacketCount() {
        return this.packetCount;
    }

    @Override
    public U64 getByteCount() {
        return this.byteCount;
    }

    @Override
    public Match getMatch() {
        return this.match;
    }

    @Override
    public OFFlowRemoved.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFFlowRemovedVer10(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("match=").append(this.match);
        b.append(", ");
        b.append("cookie=").append(this.cookie);
        b.append(", ");
        b.append("priority=").append(this.priority);
        b.append(", ");
        b.append("reason=").append(this.reason);
        b.append(", ");
        b.append("durationSec=").append(this.durationSec);
        b.append(", ");
        b.append("durationNsec=").append(this.durationNsec);
        b.append(", ");
        b.append("idleTimeout=").append(this.idleTimeout);
        b.append(", ");
        b.append("packetCount=").append(this.packetCount);
        b.append(", ");
        b.append("byteCount=").append(this.byteCount);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFlowRemovedVer10 other = (OFFlowRemovedVer10)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        if (this.cookie == null ? other.cookie != null : !this.cookie.equals(other.cookie)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.reason != other.reason) {
            return false;
        }
        if (this.durationSec != other.durationSec) {
            return false;
        }
        if (this.durationNsec != other.durationNsec) {
            return false;
        }
        if (this.idleTimeout != other.idleTimeout) {
            return false;
        }
        if (this.packetCount == null ? other.packetCount != null : !this.packetCount.equals(other.packetCount)) {
            return false;
        }
        return !(this.byteCount == null ? other.byteCount != null : !this.byteCount.equals(other.byteCount));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * result + (this.cookie == null ? 0 : this.cookie.hashCode());
        result = 31 * result + this.priority;
        result = 31 * result + this.reason;
        result = 31 * (int)(this.durationSec ^ this.durationSec >>> 32);
        result = 31 * (int)(this.durationNsec ^ this.durationNsec >>> 32);
        result = 31 * result + this.idleTimeout;
        result = 31 * result + (this.packetCount == null ? 0 : this.packetCount.hashCode());
        result = 31 * result + (this.byteCount == null ? 0 : this.byteCount.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFFlowRemovedVer10> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFFlowRemovedVer10 message) {
            bb.writeByte(1);
            bb.writeByte(11);
            bb.writeShort(88);
            bb.writeInt(U32.t(message.xid));
            message.match.writeTo(bb);
            bb.writeLong(message.cookie.getValue());
            bb.writeShort((int)U16.t(message.priority));
            bb.writeByte((int)U8.t(message.reason));
            bb.writeZero(1);
            bb.writeInt(U32.t(message.durationSec));
            bb.writeInt(U32.t(message.durationNsec));
            bb.writeShort((int)U16.t(message.idleTimeout));
            bb.writeZero(2);
            bb.writeLong(message.packetCount.getValue());
            bb.writeLong(message.byteCount.getValue());
        }
    }

    static class OFFlowRemovedVer10Funnel
    implements Funnel<OFFlowRemovedVer10> {
        private static final long serialVersionUID = 1L;

        OFFlowRemovedVer10Funnel() {
        }

        public void funnel(OFFlowRemovedVer10 message, PrimitiveSink sink) {
            sink.putByte((byte)1);
            sink.putByte((byte)11);
            sink.putShort((short)88);
            sink.putLong(message.xid);
            message.match.putTo(sink);
            message.cookie.putTo(sink);
            sink.putInt(message.priority);
            sink.putShort(message.reason);
            sink.putLong(message.durationSec);
            sink.putLong(message.durationNsec);
            sink.putInt(message.idleTimeout);
            message.packetCount.putTo(sink);
            message.byteCount.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFFlowRemoved> {
        Reader() {
        }

        @Override
        public OFFlowRemoved readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 11) {
                throw new OFParseError("Wrong type: Expected=OFType.FLOW_REMOVED(11), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 88) {
                throw new OFParseError("Wrong length: Expected=88(88), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            Match match = ChannelUtilsVer10.readOFMatch(bb);
            U64 cookie = U64.ofRaw(bb.readLong());
            int priority = U16.f(bb.readShort());
            short reason = U8.f(bb.readByte());
            bb.skipBytes(1);
            long durationSec = U32.f(bb.readInt());
            long durationNsec = U32.f(bb.readInt());
            int idleTimeout = U16.f(bb.readShort());
            bb.skipBytes(2);
            U64 packetCount = U64.ofRaw(bb.readLong());
            U64 byteCount = U64.ofRaw(bb.readLong());
            OFFlowRemovedVer10 flowRemovedVer10 = new OFFlowRemovedVer10(xid, match, cookie, priority, reason, durationSec, durationNsec, idleTimeout, packetCount, byteCount);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)flowRemovedVer10);
            }
            return flowRemovedVer10;
        }
    }

    static class Builder
    implements OFFlowRemoved.Builder {
        private boolean xidSet;
        private long xid;
        private boolean matchSet;
        private Match match;
        private boolean cookieSet;
        private U64 cookie;
        private boolean prioritySet;
        private int priority;
        private boolean reasonSet;
        private short reason;
        private boolean durationSecSet;
        private long durationSec;
        private boolean durationNsecSet;
        private long durationNsec;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean packetCountSet;
        private U64 packetCount;
        private boolean byteCountSet;
        private U64 byteCount;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.FLOW_REMOVED;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFlowRemoved.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFFlowRemoved.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFFlowRemoved.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public short getReason() {
            return this.reason;
        }

        @Override
        public OFFlowRemoved.Builder setReason(short reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public TableId getTableId() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property tableId not supported in version 1.0");
        }

        @Override
        public OFFlowRemoved.Builder setTableId(TableId tableId) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property tableId not supported in version 1.0");
        }

        @Override
        public long getDurationSec() {
            return this.durationSec;
        }

        @Override
        public OFFlowRemoved.Builder setDurationSec(long durationSec) {
            this.durationSec = durationSec;
            this.durationSecSet = true;
            return this;
        }

        @Override
        public long getDurationNsec() {
            return this.durationNsec;
        }

        @Override
        public OFFlowRemoved.Builder setDurationNsec(long durationNsec) {
            this.durationNsec = durationNsec;
            this.durationNsecSet = true;
            return this;
        }

        @Override
        public int getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public OFFlowRemoved.Builder setIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.idleTimeoutSet = true;
            return this;
        }

        @Override
        public int getHardTimeout() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property hardTimeout not supported in version 1.0");
        }

        @Override
        public OFFlowRemoved.Builder setHardTimeout(int hardTimeout) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property hardTimeout not supported in version 1.0");
        }

        @Override
        public U64 getPacketCount() {
            return this.packetCount;
        }

        @Override
        public OFFlowRemoved.Builder setPacketCount(U64 packetCount) {
            this.packetCount = packetCount;
            this.packetCountSet = true;
            return this;
        }

        @Override
        public U64 getByteCount() {
            return this.byteCount;
        }

        @Override
        public OFFlowRemoved.Builder setByteCount(U64 byteCount) {
            this.byteCount = byteCount;
            this.byteCountSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFFlowRemoved.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public OFFlowRemoved build() {
            U64 byteCount;
            U64 packetCount;
            U64 cookie;
            Match match;
            long xid = this.xidSet ? this.xid : 0L;
            Match match2 = match = this.matchSet ? this.match : DEFAULT_MATCH;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            U64 u64 = cookie = this.cookieSet ? this.cookie : DEFAULT_COOKIE;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            int priority = this.prioritySet ? this.priority : 0;
            short reason = this.reasonSet ? this.reason : (short)0;
            long durationSec = this.durationSecSet ? this.durationSec : 0L;
            long durationNsec = this.durationNsecSet ? this.durationNsec : 0L;
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : 0;
            U64 u642 = packetCount = this.packetCountSet ? this.packetCount : DEFAULT_PACKET_COUNT;
            if (packetCount == null) {
                throw new NullPointerException("Property packetCount must not be null");
            }
            U64 u643 = byteCount = this.byteCountSet ? this.byteCount : DEFAULT_BYTE_COUNT;
            if (byteCount == null) {
                throw new NullPointerException("Property byteCount must not be null");
            }
            return new OFFlowRemovedVer10(xid, match, cookie, priority, reason, durationSec, durationNsec, idleTimeout, packetCount, byteCount);
        }
    }

    static class BuilderWithParent
    implements OFFlowRemoved.Builder {
        final OFFlowRemovedVer10 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean matchSet;
        private Match match;
        private boolean cookieSet;
        private U64 cookie;
        private boolean prioritySet;
        private int priority;
        private boolean reasonSet;
        private short reason;
        private boolean durationSecSet;
        private long durationSec;
        private boolean durationNsecSet;
        private long durationNsec;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean packetCountSet;
        private U64 packetCount;
        private boolean byteCountSet;
        private U64 byteCount;

        BuilderWithParent(OFFlowRemovedVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.FLOW_REMOVED;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFlowRemoved.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFFlowRemoved.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFFlowRemoved.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public short getReason() {
            return this.reason;
        }

        @Override
        public OFFlowRemoved.Builder setReason(short reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public TableId getTableId() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property tableId not supported in version 1.0");
        }

        @Override
        public OFFlowRemoved.Builder setTableId(TableId tableId) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property tableId not supported in version 1.0");
        }

        @Override
        public long getDurationSec() {
            return this.durationSec;
        }

        @Override
        public OFFlowRemoved.Builder setDurationSec(long durationSec) {
            this.durationSec = durationSec;
            this.durationSecSet = true;
            return this;
        }

        @Override
        public long getDurationNsec() {
            return this.durationNsec;
        }

        @Override
        public OFFlowRemoved.Builder setDurationNsec(long durationNsec) {
            this.durationNsec = durationNsec;
            this.durationNsecSet = true;
            return this;
        }

        @Override
        public int getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public OFFlowRemoved.Builder setIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.idleTimeoutSet = true;
            return this;
        }

        @Override
        public int getHardTimeout() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property hardTimeout not supported in version 1.0");
        }

        @Override
        public OFFlowRemoved.Builder setHardTimeout(int hardTimeout) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property hardTimeout not supported in version 1.0");
        }

        @Override
        public U64 getPacketCount() {
            return this.packetCount;
        }

        @Override
        public OFFlowRemoved.Builder setPacketCount(U64 packetCount) {
            this.packetCount = packetCount;
            this.packetCountSet = true;
            return this;
        }

        @Override
        public U64 getByteCount() {
            return this.byteCount;
        }

        @Override
        public OFFlowRemoved.Builder setByteCount(U64 byteCount) {
            this.byteCount = byteCount;
            this.byteCountSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFFlowRemoved.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public OFFlowRemoved build() {
            U64 byteCount;
            U64 packetCount;
            U64 cookie;
            Match match;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Match match2 = match = this.matchSet ? this.match : this.parentMessage.match;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            U64 u64 = cookie = this.cookieSet ? this.cookie : this.parentMessage.cookie;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            int priority = this.prioritySet ? this.priority : this.parentMessage.priority;
            short reason = this.reasonSet ? this.reason : this.parentMessage.reason;
            long durationSec = this.durationSecSet ? this.durationSec : this.parentMessage.durationSec;
            long durationNsec = this.durationNsecSet ? this.durationNsec : this.parentMessage.durationNsec;
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : this.parentMessage.idleTimeout;
            U64 u642 = packetCount = this.packetCountSet ? this.packetCount : this.parentMessage.packetCount;
            if (packetCount == null) {
                throw new NullPointerException("Property packetCount must not be null");
            }
            U64 u643 = byteCount = this.byteCountSet ? this.byteCount : this.parentMessage.byteCount;
            if (byteCount == null) {
                throw new NullPointerException("Property byteCount must not be null");
            }
            return new OFFlowRemovedVer10(xid, match, cookie, priority, reason, durationSec, durationNsec, idleTimeout, packetCount, byteCount);
        }
    }
}

