/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFNiciraControllerRole;
import org.projectfloodlight.openflow.protocol.OFNiciraControllerRoleReply;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver10.OFNiciraControllerRoleSerializerVer10;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFNiciraControllerRoleReplyVer10
implements OFNiciraControllerRoleReply {
    private static final Logger logger = LoggerFactory.getLogger(OFNiciraControllerRoleReplyVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 20;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    private final OFNiciraControllerRole role;
    static final Reader READER = new Reader();
    static final OFNiciraControllerRoleReplyVer10Funnel FUNNEL = new OFNiciraControllerRoleReplyVer10Funnel();
    static final Writer WRITER = new Writer();

    OFNiciraControllerRoleReplyVer10(long xid, OFNiciraControllerRole role) {
        this.xid = xid;
        this.role = role;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public long getSubtype() {
        return 11L;
    }

    @Override
    public OFNiciraControllerRole getRole() {
        return this.role;
    }

    @Override
    public OFNiciraControllerRoleReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFNiciraControllerRoleReplyVer10(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("role=").append((Object)this.role);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFNiciraControllerRoleReplyVer10 other = (OFNiciraControllerRoleReplyVer10)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return !(this.role == null ? other.role != null : !this.role.equals((Object)other.role));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFNiciraControllerRoleReplyVer10> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFNiciraControllerRoleReplyVer10 message) {
            bb.writeByte(1);
            bb.writeByte(4);
            bb.writeShort(20);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(8992);
            bb.writeInt(11);
            OFNiciraControllerRoleSerializerVer10.writeTo(bb, message.role);
        }
    }

    static class OFNiciraControllerRoleReplyVer10Funnel
    implements Funnel<OFNiciraControllerRoleReplyVer10> {
        private static final long serialVersionUID = 1L;

        OFNiciraControllerRoleReplyVer10Funnel() {
        }

        public void funnel(OFNiciraControllerRoleReplyVer10 message, PrimitiveSink sink) {
            sink.putByte((byte)1);
            sink.putByte((byte)4);
            sink.putShort((short)20);
            sink.putLong(message.xid);
            sink.putInt(8992);
            sink.putInt(11);
            OFNiciraControllerRoleSerializerVer10.putTo(message.role, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFNiciraControllerRoleReply> {
        Reader() {
        }

        @Override
        public OFNiciraControllerRoleReply readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 20) {
                throw new OFParseError("Wrong length: Expected=20(20), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 11) {
                throw new OFParseError("Wrong subtype: Expected=0xbL(0xbL), got=" + subtype);
            }
            OFNiciraControllerRole role = OFNiciraControllerRoleSerializerVer10.readFrom(bb);
            OFNiciraControllerRoleReplyVer10 niciraControllerRoleReplyVer10 = new OFNiciraControllerRoleReplyVer10(xid, role);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)niciraControllerRoleReplyVer10);
            }
            return niciraControllerRoleReplyVer10;
        }
    }

    static class Builder
    implements OFNiciraControllerRoleReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean roleSet;
        private OFNiciraControllerRole role;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFNiciraControllerRoleReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public long getSubtype() {
            return 11L;
        }

        @Override
        public OFNiciraControllerRole getRole() {
            return this.role;
        }

        @Override
        public OFNiciraControllerRoleReply.Builder setRole(OFNiciraControllerRole role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public OFNiciraControllerRoleReply build() {
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.roleSet) {
                throw new IllegalStateException("Property role doesn't have default value -- must be set");
            }
            if (this.role == null) {
                throw new NullPointerException("Property role must not be null");
            }
            return new OFNiciraControllerRoleReplyVer10(xid, this.role);
        }
    }

    static class BuilderWithParent
    implements OFNiciraControllerRoleReply.Builder {
        final OFNiciraControllerRoleReplyVer10 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean roleSet;
        private OFNiciraControllerRole role;

        BuilderWithParent(OFNiciraControllerRoleReplyVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFNiciraControllerRoleReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 8992L;
        }

        @Override
        public long getSubtype() {
            return 11L;
        }

        @Override
        public OFNiciraControllerRole getRole() {
            return this.role;
        }

        @Override
        public OFNiciraControllerRoleReply.Builder setRole(OFNiciraControllerRole role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public OFNiciraControllerRoleReply build() {
            OFNiciraControllerRole role;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFNiciraControllerRole oFNiciraControllerRole = role = this.roleSet ? this.role : this.parentMessage.role;
            if (role == null) {
                throw new NullPointerException("Property role must not be null");
            }
            return new OFNiciraControllerRoleReplyVer10(xid, role);
        }
    }
}

