/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFQueueStatsEntry;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFQueueStatsEntryVer10
implements OFQueueStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFQueueStatsEntryVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 32;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final long DEFAULT_QUEUE_ID = 0L;
    private static final U64 DEFAULT_TX_BYTES = U64.ZERO;
    private static final U64 DEFAULT_TX_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_TX_ERRORS = U64.ZERO;
    private final OFPort portNo;
    private final long queueId;
    private final U64 txBytes;
    private final U64 txPackets;
    private final U64 txErrors;
    static final OFQueueStatsEntryVer10 DEFAULT = new OFQueueStatsEntryVer10(DEFAULT_PORT_NO, 0L, DEFAULT_TX_BYTES, DEFAULT_TX_PACKETS, DEFAULT_TX_ERRORS);
    static final Reader READER = new Reader();
    static final OFQueueStatsEntryVer10Funnel FUNNEL = new OFQueueStatsEntryVer10Funnel();
    static final Writer WRITER = new Writer();

    OFQueueStatsEntryVer10(OFPort portNo, long queueId, U64 txBytes, U64 txPackets, U64 txErrors) {
        this.portNo = portNo;
        this.queueId = queueId;
        this.txBytes = txBytes;
        this.txPackets = txPackets;
        this.txErrors = txErrors;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public long getQueueId() {
        return this.queueId;
    }

    @Override
    public U64 getTxBytes() {
        return this.txBytes;
    }

    @Override
    public U64 getTxPackets() {
        return this.txPackets;
    }

    @Override
    public U64 getTxErrors() {
        return this.txErrors;
    }

    @Override
    public long getDurationSec() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationSec not supported in version 1.0");
    }

    @Override
    public long getDurationNsec() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationNsec not supported in version 1.0");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFQueueStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFQueueStatsEntryVer10(");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("queueId=").append(this.queueId);
        b.append(", ");
        b.append("txBytes=").append(this.txBytes);
        b.append(", ");
        b.append("txPackets=").append(this.txPackets);
        b.append(", ");
        b.append("txErrors=").append(this.txErrors);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFQueueStatsEntryVer10 other = (OFQueueStatsEntryVer10)obj;
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.queueId != other.queueId) {
            return false;
        }
        if (this.txBytes == null ? other.txBytes != null : !this.txBytes.equals(other.txBytes)) {
            return false;
        }
        if (this.txPackets == null ? other.txPackets != null : !this.txPackets.equals(other.txPackets)) {
            return false;
        }
        return !(this.txErrors == null ? other.txErrors != null : !this.txErrors.equals(other.txErrors));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * (int)(this.queueId ^ this.queueId >>> 32);
        result = 31 * result + (this.txBytes == null ? 0 : this.txBytes.hashCode());
        result = 31 * result + (this.txPackets == null ? 0 : this.txPackets.hashCode());
        result = 31 * result + (this.txErrors == null ? 0 : this.txErrors.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFQueueStatsEntryVer10> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFQueueStatsEntryVer10 message) {
            message.portNo.write2Bytes(bb);
            bb.writeZero(2);
            bb.writeInt(U32.t(message.queueId));
            bb.writeLong(message.txBytes.getValue());
            bb.writeLong(message.txPackets.getValue());
            bb.writeLong(message.txErrors.getValue());
        }
    }

    static class OFQueueStatsEntryVer10Funnel
    implements Funnel<OFQueueStatsEntryVer10> {
        private static final long serialVersionUID = 1L;

        OFQueueStatsEntryVer10Funnel() {
        }

        public void funnel(OFQueueStatsEntryVer10 message, PrimitiveSink sink) {
            message.portNo.putTo(sink);
            sink.putLong(message.queueId);
            message.txBytes.putTo(sink);
            message.txPackets.putTo(sink);
            message.txErrors.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFQueueStatsEntry> {
        Reader() {
        }

        @Override
        public OFQueueStatsEntry readFrom(ChannelBuffer bb) throws OFParseError {
            OFPort portNo = OFPort.read2Bytes(bb);
            bb.skipBytes(2);
            long queueId = U32.f(bb.readInt());
            U64 txBytes = U64.ofRaw(bb.readLong());
            U64 txPackets = U64.ofRaw(bb.readLong());
            U64 txErrors = U64.ofRaw(bb.readLong());
            OFQueueStatsEntryVer10 queueStatsEntryVer10 = new OFQueueStatsEntryVer10(portNo, queueId, txBytes, txPackets, txErrors);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)queueStatsEntryVer10);
            }
            return queueStatsEntryVer10;
        }
    }

    static class Builder
    implements OFQueueStatsEntry.Builder {
        private boolean portNoSet;
        private OFPort portNo;
        private boolean queueIdSet;
        private long queueId;
        private boolean txBytesSet;
        private U64 txBytes;
        private boolean txPacketsSet;
        private U64 txPackets;
        private boolean txErrorsSet;
        private U64 txErrors;

        Builder() {
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFQueueStatsEntry.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFQueueStatsEntry.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public U64 getTxBytes() {
            return this.txBytes;
        }

        @Override
        public OFQueueStatsEntry.Builder setTxBytes(U64 txBytes) {
            this.txBytes = txBytes;
            this.txBytesSet = true;
            return this;
        }

        @Override
        public U64 getTxPackets() {
            return this.txPackets;
        }

        @Override
        public OFQueueStatsEntry.Builder setTxPackets(U64 txPackets) {
            this.txPackets = txPackets;
            this.txPacketsSet = true;
            return this;
        }

        @Override
        public U64 getTxErrors() {
            return this.txErrors;
        }

        @Override
        public OFQueueStatsEntry.Builder setTxErrors(U64 txErrors) {
            this.txErrors = txErrors;
            this.txErrorsSet = true;
            return this;
        }

        @Override
        public long getDurationSec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.0");
        }

        @Override
        public OFQueueStatsEntry.Builder setDurationSec(long durationSec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.0");
        }

        @Override
        public long getDurationNsec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.0");
        }

        @Override
        public OFQueueStatsEntry.Builder setDurationNsec(long durationNsec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.0");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFQueueStatsEntry build() {
            U64 txErrors;
            U64 txPackets;
            U64 txBytes;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            long queueId = this.queueIdSet ? this.queueId : 0L;
            U64 u64 = txBytes = this.txBytesSet ? this.txBytes : DEFAULT_TX_BYTES;
            if (txBytes == null) {
                throw new NullPointerException("Property txBytes must not be null");
            }
            U64 u642 = txPackets = this.txPacketsSet ? this.txPackets : DEFAULT_TX_PACKETS;
            if (txPackets == null) {
                throw new NullPointerException("Property txPackets must not be null");
            }
            U64 u643 = txErrors = this.txErrorsSet ? this.txErrors : DEFAULT_TX_ERRORS;
            if (txErrors == null) {
                throw new NullPointerException("Property txErrors must not be null");
            }
            return new OFQueueStatsEntryVer10(portNo, queueId, txBytes, txPackets, txErrors);
        }
    }

    static class BuilderWithParent
    implements OFQueueStatsEntry.Builder {
        final OFQueueStatsEntryVer10 parentMessage;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean queueIdSet;
        private long queueId;
        private boolean txBytesSet;
        private U64 txBytes;
        private boolean txPacketsSet;
        private U64 txPackets;
        private boolean txErrorsSet;
        private U64 txErrors;

        BuilderWithParent(OFQueueStatsEntryVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFQueueStatsEntry.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFQueueStatsEntry.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public U64 getTxBytes() {
            return this.txBytes;
        }

        @Override
        public OFQueueStatsEntry.Builder setTxBytes(U64 txBytes) {
            this.txBytes = txBytes;
            this.txBytesSet = true;
            return this;
        }

        @Override
        public U64 getTxPackets() {
            return this.txPackets;
        }

        @Override
        public OFQueueStatsEntry.Builder setTxPackets(U64 txPackets) {
            this.txPackets = txPackets;
            this.txPacketsSet = true;
            return this;
        }

        @Override
        public U64 getTxErrors() {
            return this.txErrors;
        }

        @Override
        public OFQueueStatsEntry.Builder setTxErrors(U64 txErrors) {
            this.txErrors = txErrors;
            this.txErrorsSet = true;
            return this;
        }

        @Override
        public long getDurationSec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.0");
        }

        @Override
        public OFQueueStatsEntry.Builder setDurationSec(long durationSec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.0");
        }

        @Override
        public long getDurationNsec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.0");
        }

        @Override
        public OFQueueStatsEntry.Builder setDurationNsec(long durationNsec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.0");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFQueueStatsEntry build() {
            U64 txErrors;
            U64 txPackets;
            U64 txBytes;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            long queueId = this.queueIdSet ? this.queueId : this.parentMessage.queueId;
            U64 u64 = txBytes = this.txBytesSet ? this.txBytes : this.parentMessage.txBytes;
            if (txBytes == null) {
                throw new NullPointerException("Property txBytes must not be null");
            }
            U64 u642 = txPackets = this.txPacketsSet ? this.txPackets : this.parentMessage.txPackets;
            if (txPackets == null) {
                throw new NullPointerException("Property txPackets must not be null");
            }
            U64 u643 = txErrors = this.txErrorsSet ? this.txErrors : this.parentMessage.txErrors;
            if (txErrors == null) {
                throw new NullPointerException("Property txErrors must not be null");
            }
            return new OFQueueStatsEntryVer10(portNo, queueId, txBytes, txPackets, txErrors);
        }
    }
}

