/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionBsnMirror;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionBsnMirrorVer11
implements OFActionBsnMirror {
    private static final Logger logger = LoggerFactory.getLogger(OFActionBsnMirrorVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 24;
    private static final OFPort DEFAULT_DEST_PORT = OFPort.ANY;
    private static final long DEFAULT_VLAN_TAG = 0L;
    private static final short DEFAULT_COPY_STAGE = 0;
    private final OFPort destPort;
    private final long vlanTag;
    private final short copyStage;
    static final OFActionBsnMirrorVer11 DEFAULT = new OFActionBsnMirrorVer11(DEFAULT_DEST_PORT, 0L, 0);
    static final Reader READER = new Reader();
    static final OFActionBsnMirrorVer11Funnel FUNNEL = new OFActionBsnMirrorVer11Funnel();
    static final Writer WRITER = new Writer();

    OFActionBsnMirrorVer11(OFPort destPort, long vlanTag, short copyStage) {
        this.destPort = destPort;
        this.vlanTag = vlanTag;
        this.copyStage = copyStage;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 1L;
    }

    @Override
    public OFPort getDestPort() {
        return this.destPort;
    }

    @Override
    public long getVlanTag() {
        return this.vlanTag;
    }

    @Override
    public short getCopyStage() {
        return this.copyStage;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFActionBsnMirror.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionBsnMirrorVer11(");
        b.append("destPort=").append(this.destPort);
        b.append(", ");
        b.append("vlanTag=").append(this.vlanTag);
        b.append(", ");
        b.append("copyStage=").append(this.copyStage);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionBsnMirrorVer11 other = (OFActionBsnMirrorVer11)obj;
        if (this.destPort == null ? other.destPort != null : !this.destPort.equals(other.destPort)) {
            return false;
        }
        if (this.vlanTag != other.vlanTag) {
            return false;
        }
        return this.copyStage == other.copyStage;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destPort == null ? 0 : this.destPort.hashCode());
        result = 31 * (int)(this.vlanTag ^ this.vlanTag >>> 32);
        result = 31 * result + this.copyStage;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionBsnMirrorVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionBsnMirrorVer11 message) {
            bb.writeShort(-1);
            bb.writeShort(24);
            bb.writeInt(6035143);
            bb.writeInt(1);
            message.destPort.write4Bytes(bb);
            bb.writeInt(U32.t(message.vlanTag));
            bb.writeByte((int)U8.t(message.copyStage));
            bb.writeZero(3);
        }
    }

    static class OFActionBsnMirrorVer11Funnel
    implements Funnel<OFActionBsnMirrorVer11> {
        private static final long serialVersionUID = 1L;

        OFActionBsnMirrorVer11Funnel() {
        }

        public void funnel(OFActionBsnMirrorVer11 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)24);
            sink.putInt(6035143);
            sink.putInt(1);
            message.destPort.putTo(sink);
            sink.putLong(message.vlanTag);
            sink.putShort(message.copyStage);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionBsnMirror> {
        Reader() {
        }

        @Override
        public OFActionBsnMirror readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 1) {
                throw new OFParseError("Wrong subtype: Expected=0x1L(0x1L), got=" + subtype);
            }
            OFPort destPort = OFPort.read4Bytes(bb);
            long vlanTag = U32.f(bb.readInt());
            short copyStage = U8.f(bb.readByte());
            bb.skipBytes(3);
            OFActionBsnMirrorVer11 actionBsnMirrorVer11 = new OFActionBsnMirrorVer11(destPort, vlanTag, copyStage);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionBsnMirrorVer11);
            }
            return actionBsnMirrorVer11;
        }
    }

    static class Builder
    implements OFActionBsnMirror.Builder {
        private boolean destPortSet;
        private OFPort destPort;
        private boolean vlanTagSet;
        private long vlanTag;
        private boolean copyStageSet;
        private short copyStage;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 1L;
        }

        @Override
        public OFPort getDestPort() {
            return this.destPort;
        }

        @Override
        public OFActionBsnMirror.Builder setDestPort(OFPort destPort) {
            this.destPort = destPort;
            this.destPortSet = true;
            return this;
        }

        @Override
        public long getVlanTag() {
            return this.vlanTag;
        }

        @Override
        public OFActionBsnMirror.Builder setVlanTag(long vlanTag) {
            this.vlanTag = vlanTag;
            this.vlanTagSet = true;
            return this;
        }

        @Override
        public short getCopyStage() {
            return this.copyStage;
        }

        @Override
        public OFActionBsnMirror.Builder setCopyStage(short copyStage) {
            this.copyStage = copyStage;
            this.copyStageSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionBsnMirror build() {
            OFPort destPort;
            OFPort oFPort = destPort = this.destPortSet ? this.destPort : DEFAULT_DEST_PORT;
            if (destPort == null) {
                throw new NullPointerException("Property destPort must not be null");
            }
            long vlanTag = this.vlanTagSet ? this.vlanTag : 0L;
            short copyStage = this.copyStageSet ? this.copyStage : (short)0;
            return new OFActionBsnMirrorVer11(destPort, vlanTag, copyStage);
        }
    }

    static class BuilderWithParent
    implements OFActionBsnMirror.Builder {
        final OFActionBsnMirrorVer11 parentMessage;
        private boolean destPortSet;
        private OFPort destPort;
        private boolean vlanTagSet;
        private long vlanTag;
        private boolean copyStageSet;
        private short copyStage;

        BuilderWithParent(OFActionBsnMirrorVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 1L;
        }

        @Override
        public OFPort getDestPort() {
            return this.destPort;
        }

        @Override
        public OFActionBsnMirror.Builder setDestPort(OFPort destPort) {
            this.destPort = destPort;
            this.destPortSet = true;
            return this;
        }

        @Override
        public long getVlanTag() {
            return this.vlanTag;
        }

        @Override
        public OFActionBsnMirror.Builder setVlanTag(long vlanTag) {
            this.vlanTag = vlanTag;
            this.vlanTagSet = true;
            return this;
        }

        @Override
        public short getCopyStage() {
            return this.copyStage;
        }

        @Override
        public OFActionBsnMirror.Builder setCopyStage(short copyStage) {
            this.copyStage = copyStage;
            this.copyStageSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionBsnMirror build() {
            OFPort destPort;
            OFPort oFPort = destPort = this.destPortSet ? this.destPort : this.parentMessage.destPort;
            if (destPort == null) {
                throw new NullPointerException("Property destPort must not be null");
            }
            long vlanTag = this.vlanTagSet ? this.vlanTag : this.parentMessage.vlanTag;
            short copyStage = this.copyStageSet ? this.copyStage : this.parentMessage.copyStage;
            return new OFActionBsnMirrorVer11(destPort, vlanTag, copyStage);
        }
    }
}

