/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetDlSrc;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetDlSrcVer11
implements OFActionSetDlSrc {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetDlSrcVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 16;
    private static final MacAddress DEFAULT_DL_ADDR = MacAddress.NONE;
    private final MacAddress dlAddr;
    static final OFActionSetDlSrcVer11 DEFAULT = new OFActionSetDlSrcVer11(DEFAULT_DL_ADDR);
    static final Reader READER = new Reader();
    static final OFActionSetDlSrcVer11Funnel FUNNEL = new OFActionSetDlSrcVer11Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetDlSrcVer11(MacAddress dlAddr) {
        this.dlAddr = dlAddr;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_DL_SRC;
    }

    @Override
    public MacAddress getDlAddr() {
        return this.dlAddr;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFActionSetDlSrc.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetDlSrcVer11(");
        b.append("dlAddr=").append(this.dlAddr);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetDlSrcVer11 other = (OFActionSetDlSrcVer11)obj;
        return !(this.dlAddr == null ? other.dlAddr != null : !this.dlAddr.equals(other.dlAddr));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dlAddr == null ? 0 : this.dlAddr.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetDlSrcVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionSetDlSrcVer11 message) {
            bb.writeShort(3);
            bb.writeShort(16);
            message.dlAddr.write6Bytes(bb);
            bb.writeZero(6);
        }
    }

    static class OFActionSetDlSrcVer11Funnel
    implements Funnel<OFActionSetDlSrcVer11> {
        private static final long serialVersionUID = 1L;

        OFActionSetDlSrcVer11Funnel() {
        }

        public void funnel(OFActionSetDlSrcVer11 message, PrimitiveSink sink) {
            sink.putShort((short)3);
            sink.putShort((short)16);
            message.dlAddr.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetDlSrc> {
        Reader() {
        }

        @Override
        public OFActionSetDlSrc readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 3) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_DL_SRC(3), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            MacAddress dlAddr = MacAddress.read6Bytes(bb);
            bb.skipBytes(6);
            OFActionSetDlSrcVer11 actionSetDlSrcVer11 = new OFActionSetDlSrcVer11(dlAddr);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetDlSrcVer11);
            }
            return actionSetDlSrcVer11;
        }
    }

    static class Builder
    implements OFActionSetDlSrc.Builder {
        private boolean dlAddrSet;
        private MacAddress dlAddr;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_DL_SRC;
        }

        @Override
        public MacAddress getDlAddr() {
            return this.dlAddr;
        }

        @Override
        public OFActionSetDlSrc.Builder setDlAddr(MacAddress dlAddr) {
            this.dlAddr = dlAddr;
            this.dlAddrSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionSetDlSrc build() {
            MacAddress dlAddr;
            MacAddress macAddress = dlAddr = this.dlAddrSet ? this.dlAddr : DEFAULT_DL_ADDR;
            if (dlAddr == null) {
                throw new NullPointerException("Property dlAddr must not be null");
            }
            return new OFActionSetDlSrcVer11(dlAddr);
        }
    }

    static class BuilderWithParent
    implements OFActionSetDlSrc.Builder {
        final OFActionSetDlSrcVer11 parentMessage;
        private boolean dlAddrSet;
        private MacAddress dlAddr;

        BuilderWithParent(OFActionSetDlSrcVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_DL_SRC;
        }

        @Override
        public MacAddress getDlAddr() {
            return this.dlAddr;
        }

        @Override
        public OFActionSetDlSrc.Builder setDlAddr(MacAddress dlAddr) {
            this.dlAddr = dlAddr;
            this.dlAddrSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionSetDlSrc build() {
            MacAddress dlAddr;
            MacAddress macAddress = dlAddr = this.dlAddrSet ? this.dlAddr : this.parentMessage.dlAddr;
            if (dlAddr == null) {
                throw new NullPointerException("Property dlAddr must not be null");
            }
            return new OFActionSetDlSrcVer11(dlAddr);
        }
    }
}

