/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetMplsLabel;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetMplsLabelVer11
implements OFActionSetMplsLabel {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetMplsLabelVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 8;
    private static final long DEFAULT_MPLS_LABEL = 0L;
    private final long mplsLabel;
    static final OFActionSetMplsLabelVer11 DEFAULT = new OFActionSetMplsLabelVer11(0L);
    static final Reader READER = new Reader();
    static final OFActionSetMplsLabelVer11Funnel FUNNEL = new OFActionSetMplsLabelVer11Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetMplsLabelVer11(long mplsLabel) {
        this.mplsLabel = mplsLabel;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_MPLS_LABEL;
    }

    @Override
    public long getMplsLabel() {
        return this.mplsLabel;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFActionSetMplsLabel.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetMplsLabelVer11(");
        b.append("mplsLabel=").append(this.mplsLabel);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetMplsLabelVer11 other = (OFActionSetMplsLabelVer11)obj;
        return this.mplsLabel == other.mplsLabel;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.mplsLabel ^ this.mplsLabel >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetMplsLabelVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionSetMplsLabelVer11 message) {
            bb.writeShort(13);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.mplsLabel));
        }
    }

    static class OFActionSetMplsLabelVer11Funnel
    implements Funnel<OFActionSetMplsLabelVer11> {
        private static final long serialVersionUID = 1L;

        OFActionSetMplsLabelVer11Funnel() {
        }

        public void funnel(OFActionSetMplsLabelVer11 message, PrimitiveSink sink) {
            sink.putShort((short)13);
            sink.putShort((short)8);
            sink.putLong(message.mplsLabel);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetMplsLabel> {
        Reader() {
        }

        @Override
        public OFActionSetMplsLabel readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 13) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_MPLS_LABEL(13), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long mplsLabel = U32.f(bb.readInt());
            OFActionSetMplsLabelVer11 actionSetMplsLabelVer11 = new OFActionSetMplsLabelVer11(mplsLabel);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetMplsLabelVer11);
            }
            return actionSetMplsLabelVer11;
        }
    }

    static class Builder
    implements OFActionSetMplsLabel.Builder {
        private boolean mplsLabelSet;
        private long mplsLabel;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_MPLS_LABEL;
        }

        @Override
        public long getMplsLabel() {
            return this.mplsLabel;
        }

        @Override
        public OFActionSetMplsLabel.Builder setMplsLabel(long mplsLabel) {
            this.mplsLabel = mplsLabel;
            this.mplsLabelSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionSetMplsLabel build() {
            long mplsLabel = this.mplsLabelSet ? this.mplsLabel : 0L;
            return new OFActionSetMplsLabelVer11(mplsLabel);
        }
    }

    static class BuilderWithParent
    implements OFActionSetMplsLabel.Builder {
        final OFActionSetMplsLabelVer11 parentMessage;
        private boolean mplsLabelSet;
        private long mplsLabel;

        BuilderWithParent(OFActionSetMplsLabelVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_MPLS_LABEL;
        }

        @Override
        public long getMplsLabel() {
            return this.mplsLabel;
        }

        @Override
        public OFActionSetMplsLabel.Builder setMplsLabel(long mplsLabel) {
            this.mplsLabel = mplsLabel;
            this.mplsLabelSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionSetMplsLabel build() {
            long mplsLabel = this.mplsLabelSet ? this.mplsLabel : this.parentMessage.mplsLabel;
            return new OFActionSetMplsLabelVer11(mplsLabel);
        }
    }
}

