/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetVlanVid;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.VlanVid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetVlanVidVer11
implements OFActionSetVlanVid {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetVlanVidVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 8;
    private static final VlanVid DEFAULT_VLAN_VID = VlanVid.ZERO;
    private final VlanVid vlanVid;
    static final OFActionSetVlanVidVer11 DEFAULT = new OFActionSetVlanVidVer11(DEFAULT_VLAN_VID);
    static final Reader READER = new Reader();
    static final OFActionSetVlanVidVer11Funnel FUNNEL = new OFActionSetVlanVidVer11Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetVlanVidVer11(VlanVid vlanVid) {
        this.vlanVid = vlanVid;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_VLAN_VID;
    }

    @Override
    public VlanVid getVlanVid() {
        return this.vlanVid;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFActionSetVlanVid.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetVlanVidVer11(");
        b.append("vlanVid=").append(this.vlanVid);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetVlanVidVer11 other = (OFActionSetVlanVidVer11)obj;
        return !(this.vlanVid == null ? other.vlanVid != null : !this.vlanVid.equals(other.vlanVid));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.vlanVid == null ? 0 : this.vlanVid.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetVlanVidVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionSetVlanVidVer11 message) {
            bb.writeShort(1);
            bb.writeShort(8);
            message.vlanVid.write2Bytes(bb);
            bb.writeZero(2);
        }
    }

    static class OFActionSetVlanVidVer11Funnel
    implements Funnel<OFActionSetVlanVidVer11> {
        private static final long serialVersionUID = 1L;

        OFActionSetVlanVidVer11Funnel() {
        }

        public void funnel(OFActionSetVlanVidVer11 message, PrimitiveSink sink) {
            sink.putShort((short)1);
            sink.putShort((short)8);
            message.vlanVid.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetVlanVid> {
        Reader() {
        }

        @Override
        public OFActionSetVlanVid readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_VLAN_VID(1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            VlanVid vlanVid = VlanVid.read2Bytes(bb);
            bb.skipBytes(2);
            OFActionSetVlanVidVer11 actionSetVlanVidVer11 = new OFActionSetVlanVidVer11(vlanVid);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetVlanVidVer11);
            }
            return actionSetVlanVidVer11;
        }
    }

    static class Builder
    implements OFActionSetVlanVid.Builder {
        private boolean vlanVidSet;
        private VlanVid vlanVid;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_VLAN_VID;
        }

        @Override
        public VlanVid getVlanVid() {
            return this.vlanVid;
        }

        @Override
        public OFActionSetVlanVid.Builder setVlanVid(VlanVid vlanVid) {
            this.vlanVid = vlanVid;
            this.vlanVidSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionSetVlanVid build() {
            VlanVid vlanVid;
            VlanVid vlanVid2 = vlanVid = this.vlanVidSet ? this.vlanVid : DEFAULT_VLAN_VID;
            if (vlanVid == null) {
                throw new NullPointerException("Property vlanVid must not be null");
            }
            return new OFActionSetVlanVidVer11(vlanVid);
        }
    }

    static class BuilderWithParent
    implements OFActionSetVlanVid.Builder {
        final OFActionSetVlanVidVer11 parentMessage;
        private boolean vlanVidSet;
        private VlanVid vlanVid;

        BuilderWithParent(OFActionSetVlanVidVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_VLAN_VID;
        }

        @Override
        public VlanVid getVlanVid() {
            return this.vlanVid;
        }

        @Override
        public OFActionSetVlanVid.Builder setVlanVid(VlanVid vlanVid) {
            this.vlanVid = vlanVid;
            this.vlanVidSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionSetVlanVid build() {
            VlanVid vlanVid;
            VlanVid vlanVid2 = vlanVid = this.vlanVidSet ? this.vlanVid : this.parentMessage.vlanVid;
            if (vlanVid == null) {
                throw new NullPointerException("Property vlanVid must not be null");
            }
            return new OFActionSetVlanVidVer11(vlanVid);
        }
    }
}

