/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnPduTxReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnPduTxReplyVer11
implements OFBsnPduTxReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnPduTxReplyVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 25;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_STATUS = 0L;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final short DEFAULT_SLOT_NUM = 0;
    private final long xid;
    private final long status;
    private final OFPort portNo;
    private final short slotNum;
    static final OFBsnPduTxReplyVer11 DEFAULT = new OFBsnPduTxReplyVer11(0L, 0L, DEFAULT_PORT_NO, 0);
    static final Reader READER = new Reader();
    static final OFBsnPduTxReplyVer11Funnel FUNNEL = new OFBsnPduTxReplyVer11Funnel();
    static final Writer WRITER = new Writer();

    OFBsnPduTxReplyVer11(long xid, long status, OFPort portNo, short slotNum) {
        this.xid = xid;
        this.status = status;
        this.portNo = portNo;
        this.slotNum = slotNum;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 32L;
    }

    @Override
    public long getStatus() {
        return this.status;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public short getSlotNum() {
        return this.slotNum;
    }

    @Override
    public OFBsnPduTxReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnPduTxReplyVer11(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("status=").append(this.status);
        b.append(", ");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("slotNum=").append(this.slotNum);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnPduTxReplyVer11 other = (OFBsnPduTxReplyVer11)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        return this.slotNum == other.slotNum;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.status ^ this.status >>> 32);
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + this.slotNum;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnPduTxReplyVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnPduTxReplyVer11 message) {
            bb.writeByte(2);
            bb.writeByte(4);
            bb.writeShort(25);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(32);
            bb.writeInt(U32.t(message.status));
            message.portNo.write4Bytes(bb);
            bb.writeByte((int)U8.t(message.slotNum));
        }
    }

    static class OFBsnPduTxReplyVer11Funnel
    implements Funnel<OFBsnPduTxReplyVer11> {
        private static final long serialVersionUID = 1L;

        OFBsnPduTxReplyVer11Funnel() {
        }

        public void funnel(OFBsnPduTxReplyVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)4);
            sink.putShort((short)25);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(32);
            sink.putLong(message.status);
            message.portNo.putTo(sink);
            sink.putShort(message.slotNum);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnPduTxReply> {
        Reader() {
        }

        @Override
        public OFBsnPduTxReply readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 25) {
                throw new OFParseError("Wrong length: Expected=25(25), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 32) {
                throw new OFParseError("Wrong subtype: Expected=0x20L(0x20L), got=" + subtype);
            }
            long status = U32.f(bb.readInt());
            OFPort portNo = OFPort.read4Bytes(bb);
            short slotNum = U8.f(bb.readByte());
            OFBsnPduTxReplyVer11 bsnPduTxReplyVer11 = new OFBsnPduTxReplyVer11(xid, status, portNo, slotNum);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnPduTxReplyVer11);
            }
            return bsnPduTxReplyVer11;
        }
    }

    static class Builder
    implements OFBsnPduTxReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean statusSet;
        private long status;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean slotNumSet;
        private short slotNum;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnPduTxReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 32L;
        }

        @Override
        public long getStatus() {
            return this.status;
        }

        @Override
        public OFBsnPduTxReply.Builder setStatus(long status) {
            this.status = status;
            this.statusSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnPduTxReply.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public short getSlotNum() {
            return this.slotNum;
        }

        @Override
        public OFBsnPduTxReply.Builder setSlotNum(short slotNum) {
            this.slotNum = slotNum;
            this.slotNumSet = true;
            return this;
        }

        @Override
        public OFBsnPduTxReply build() {
            OFPort portNo;
            long xid = this.xidSet ? this.xid : 0L;
            long status = this.statusSet ? this.status : 0L;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            short slotNum = this.slotNumSet ? this.slotNum : (short)0;
            return new OFBsnPduTxReplyVer11(xid, status, portNo, slotNum);
        }
    }

    static class BuilderWithParent
    implements OFBsnPduTxReply.Builder {
        final OFBsnPduTxReplyVer11 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean statusSet;
        private long status;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean slotNumSet;
        private short slotNum;

        BuilderWithParent(OFBsnPduTxReplyVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnPduTxReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 32L;
        }

        @Override
        public long getStatus() {
            return this.status;
        }

        @Override
        public OFBsnPduTxReply.Builder setStatus(long status) {
            this.status = status;
            this.statusSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnPduTxReply.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public short getSlotNum() {
            return this.slotNum;
        }

        @Override
        public OFBsnPduTxReply.Builder setSlotNum(short slotNum) {
            this.slotNum = slotNum;
            this.slotNumSet = true;
            return this;
        }

        @Override
        public OFBsnPduTxReply build() {
            OFPort portNo;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long status = this.statusSet ? this.status : this.parentMessage.status;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            short slotNum = this.slotNumSet ? this.slotNum : this.parentMessage.slotNum;
            return new OFBsnPduTxReplyVer11(xid, status, portNo, slotNum);
        }
    }
}

