/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnPduTxRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnPduTxRequestVer11
implements OFBsnPduTxRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnPduTxRequestVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 28;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_TX_INTERVAL_MS = 0L;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final short DEFAULT_SLOT_NUM = 0;
    private static final byte[] DEFAULT_DATA = new byte[0];
    private final long xid;
    private final long txIntervalMs;
    private final OFPort portNo;
    private final short slotNum;
    private final byte[] data;
    static final OFBsnPduTxRequestVer11 DEFAULT = new OFBsnPduTxRequestVer11(0L, 0L, DEFAULT_PORT_NO, 0, DEFAULT_DATA);
    static final Reader READER = new Reader();
    static final OFBsnPduTxRequestVer11Funnel FUNNEL = new OFBsnPduTxRequestVer11Funnel();
    static final Writer WRITER = new Writer();

    OFBsnPduTxRequestVer11(long xid, long txIntervalMs, OFPort portNo, short slotNum, byte[] data) {
        this.xid = xid;
        this.txIntervalMs = txIntervalMs;
        this.portNo = portNo;
        this.slotNum = slotNum;
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 31L;
    }

    @Override
    public long getTxIntervalMs() {
        return this.txIntervalMs;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public short getSlotNum() {
        return this.slotNum;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public OFBsnPduTxRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnPduTxRequestVer11(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("txIntervalMs=").append(this.txIntervalMs);
        b.append(", ");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("slotNum=").append(this.slotNum);
        b.append(", ");
        b.append("data=").append(Arrays.toString(this.data));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnPduTxRequestVer11 other = (OFBsnPduTxRequestVer11)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.txIntervalMs != other.txIntervalMs) {
            return false;
        }
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.slotNum != other.slotNum) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.txIntervalMs ^ this.txIntervalMs >>> 32);
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + this.slotNum;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnPduTxRequestVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnPduTxRequestVer11 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(2);
            bb.writeByte(4);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(31);
            bb.writeInt(U32.t(message.txIntervalMs));
            message.portNo.write4Bytes(bb);
            bb.writeByte((int)U8.t(message.slotNum));
            bb.writeZero(3);
            bb.writeBytes(message.data);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnPduTxRequestVer11Funnel
    implements Funnel<OFBsnPduTxRequestVer11> {
        private static final long serialVersionUID = 1L;

        OFBsnPduTxRequestVer11Funnel() {
        }

        public void funnel(OFBsnPduTxRequestVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)4);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(31);
            sink.putLong(message.txIntervalMs);
            message.portNo.putTo(sink);
            sink.putShort(message.slotNum);
            sink.putBytes(message.data);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnPduTxRequest> {
        Reader() {
        }

        @Override
        public OFBsnPduTxRequest readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 28) {
                throw new OFParseError("Wrong length: Expected to be >= 28, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 31) {
                throw new OFParseError("Wrong subtype: Expected=0x1fL(0x1fL), got=" + subtype);
            }
            long txIntervalMs = U32.f(bb.readInt());
            OFPort portNo = OFPort.read4Bytes(bb);
            short slotNum = U8.f(bb.readByte());
            bb.skipBytes(3);
            byte[] data = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFBsnPduTxRequestVer11 bsnPduTxRequestVer11 = new OFBsnPduTxRequestVer11(xid, txIntervalMs, portNo, slotNum, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnPduTxRequestVer11);
            }
            return bsnPduTxRequestVer11;
        }
    }

    static class Builder
    implements OFBsnPduTxRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean txIntervalMsSet;
        private long txIntervalMs;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean slotNumSet;
        private short slotNum;
        private boolean dataSet;
        private byte[] data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnPduTxRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 31L;
        }

        @Override
        public long getTxIntervalMs() {
            return this.txIntervalMs;
        }

        @Override
        public OFBsnPduTxRequest.Builder setTxIntervalMs(long txIntervalMs) {
            this.txIntervalMs = txIntervalMs;
            this.txIntervalMsSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnPduTxRequest.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public short getSlotNum() {
            return this.slotNum;
        }

        @Override
        public OFBsnPduTxRequest.Builder setSlotNum(short slotNum) {
            this.slotNum = slotNum;
            this.slotNumSet = true;
            return this;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFBsnPduTxRequest.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFBsnPduTxRequest build() {
            byte[] data;
            OFPort portNo;
            long xid = this.xidSet ? this.xid : 0L;
            long txIntervalMs = this.txIntervalMsSet ? this.txIntervalMs : 0L;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            short slotNum = this.slotNumSet ? this.slotNum : (short)0;
            byte[] byArray = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBsnPduTxRequestVer11(xid, txIntervalMs, portNo, slotNum, data);
        }
    }

    static class BuilderWithParent
    implements OFBsnPduTxRequest.Builder {
        final OFBsnPduTxRequestVer11 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean txIntervalMsSet;
        private long txIntervalMs;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean slotNumSet;
        private short slotNum;
        private boolean dataSet;
        private byte[] data;

        BuilderWithParent(OFBsnPduTxRequestVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnPduTxRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 31L;
        }

        @Override
        public long getTxIntervalMs() {
            return this.txIntervalMs;
        }

        @Override
        public OFBsnPduTxRequest.Builder setTxIntervalMs(long txIntervalMs) {
            this.txIntervalMs = txIntervalMs;
            this.txIntervalMsSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnPduTxRequest.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public short getSlotNum() {
            return this.slotNum;
        }

        @Override
        public OFBsnPduTxRequest.Builder setSlotNum(short slotNum) {
            this.slotNum = slotNum;
            this.slotNumSet = true;
            return this;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFBsnPduTxRequest.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFBsnPduTxRequest build() {
            byte[] data;
            OFPort portNo;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long txIntervalMs = this.txIntervalMsSet ? this.txIntervalMs : this.parentMessage.txIntervalMs;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            short slotNum = this.slotNumSet ? this.slotNum : this.parentMessage.slotNum;
            byte[] byArray = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBsnPduTxRequestVer11(xid, txIntervalMs, portNo, slotNum, data);
        }
    }
}

