/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnVportQInQ;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnVportQInQVer11
implements OFBsnVportQInQ {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnVportQInQVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 32;
    private static final long DEFAULT_PORT_NO = 0L;
    private static final int DEFAULT_INGRESS_TPID = 0;
    private static final int DEFAULT_INGRESS_VLAN_ID = 0;
    private static final int DEFAULT_EGRESS_TPID = 0;
    private static final int DEFAULT_EGRESS_VLAN_ID = 0;
    private static final String DEFAULT_IF_NAME = "";
    private final long portNo;
    private final int ingressTpid;
    private final int ingressVlanId;
    private final int egressTpid;
    private final int egressVlanId;
    private final String ifName;
    static final OFBsnVportQInQVer11 DEFAULT = new OFBsnVportQInQVer11(0L, 0, 0, 0, 0, "");
    static final Reader READER = new Reader();
    static final OFBsnVportQInQVer11Funnel FUNNEL = new OFBsnVportQInQVer11Funnel();
    static final Writer WRITER = new Writer();

    OFBsnVportQInQVer11(long portNo, int ingressTpid, int ingressVlanId, int egressTpid, int egressVlanId, String ifName) {
        this.portNo = portNo;
        this.ingressTpid = ingressTpid;
        this.ingressVlanId = ingressVlanId;
        this.egressTpid = egressTpid;
        this.egressVlanId = egressVlanId;
        this.ifName = ifName;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public long getPortNo() {
        return this.portNo;
    }

    @Override
    public int getIngressTpid() {
        return this.ingressTpid;
    }

    @Override
    public int getIngressVlanId() {
        return this.ingressVlanId;
    }

    @Override
    public int getEgressTpid() {
        return this.egressTpid;
    }

    @Override
    public int getEgressVlanId() {
        return this.egressVlanId;
    }

    @Override
    public String getIfName() {
        return this.ifName;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFBsnVportQInQ.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnVportQInQVer11(");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("ingressTpid=").append(this.ingressTpid);
        b.append(", ");
        b.append("ingressVlanId=").append(this.ingressVlanId);
        b.append(", ");
        b.append("egressTpid=").append(this.egressTpid);
        b.append(", ");
        b.append("egressVlanId=").append(this.egressVlanId);
        b.append(", ");
        b.append("ifName=").append(this.ifName);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnVportQInQVer11 other = (OFBsnVportQInQVer11)obj;
        if (this.portNo != other.portNo) {
            return false;
        }
        if (this.ingressTpid != other.ingressTpid) {
            return false;
        }
        if (this.ingressVlanId != other.ingressVlanId) {
            return false;
        }
        if (this.egressTpid != other.egressTpid) {
            return false;
        }
        if (this.egressVlanId != other.egressVlanId) {
            return false;
        }
        return !(this.ifName == null ? other.ifName != null : !this.ifName.equals(other.ifName));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.portNo ^ this.portNo >>> 32);
        result = 31 * result + this.ingressTpid;
        result = 31 * result + this.ingressVlanId;
        result = 31 * result + this.egressTpid;
        result = 31 * result + this.egressVlanId;
        result = 31 * result + (this.ifName == null ? 0 : this.ifName.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnVportQInQVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnVportQInQVer11 message) {
            bb.writeShort(0);
            bb.writeShort(32);
            bb.writeInt(U32.t(message.portNo));
            bb.writeShort((int)U16.t(message.ingressTpid));
            bb.writeShort((int)U16.t(message.ingressVlanId));
            bb.writeShort((int)U16.t(message.egressTpid));
            bb.writeShort((int)U16.t(message.egressVlanId));
            ChannelUtils.writeFixedLengthString(bb, message.ifName, 16);
        }
    }

    static class OFBsnVportQInQVer11Funnel
    implements Funnel<OFBsnVportQInQVer11> {
        private static final long serialVersionUID = 1L;

        OFBsnVportQInQVer11Funnel() {
        }

        public void funnel(OFBsnVportQInQVer11 message, PrimitiveSink sink) {
            sink.putShort((short)0);
            sink.putShort((short)32);
            sink.putLong(message.portNo);
            sink.putInt(message.ingressTpid);
            sink.putInt(message.ingressVlanId);
            sink.putInt(message.egressTpid);
            sink.putInt(message.egressVlanId);
            sink.putUnencodedChars((CharSequence)message.ifName);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnVportQInQ> {
        Reader() {
        }

        @Override
        public OFBsnVportQInQ readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 0) {
                throw new OFParseError("Wrong type: Expected=0x0(0x0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 32) {
                throw new OFParseError("Wrong length: Expected=32(32), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long portNo = U32.f(bb.readInt());
            int ingressTpid = U16.f(bb.readShort());
            int ingressVlanId = U16.f(bb.readShort());
            int egressTpid = U16.f(bb.readShort());
            int egressVlanId = U16.f(bb.readShort());
            String ifName = ChannelUtils.readFixedLengthString(bb, 16);
            OFBsnVportQInQVer11 bsnVportQInQVer11 = new OFBsnVportQInQVer11(portNo, ingressTpid, ingressVlanId, egressTpid, egressVlanId, ifName);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnVportQInQVer11);
            }
            return bsnVportQInQVer11;
        }
    }

    static class Builder
    implements OFBsnVportQInQ.Builder {
        private boolean portNoSet;
        private long portNo;
        private boolean ingressTpidSet;
        private int ingressTpid;
        private boolean ingressVlanIdSet;
        private int ingressVlanId;
        private boolean egressTpidSet;
        private int egressTpid;
        private boolean egressVlanIdSet;
        private int egressVlanId;
        private boolean ifNameSet;
        private String ifName;

        Builder() {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public long getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnVportQInQ.Builder setPortNo(long portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public int getIngressTpid() {
            return this.ingressTpid;
        }

        @Override
        public OFBsnVportQInQ.Builder setIngressTpid(int ingressTpid) {
            this.ingressTpid = ingressTpid;
            this.ingressTpidSet = true;
            return this;
        }

        @Override
        public int getIngressVlanId() {
            return this.ingressVlanId;
        }

        @Override
        public OFBsnVportQInQ.Builder setIngressVlanId(int ingressVlanId) {
            this.ingressVlanId = ingressVlanId;
            this.ingressVlanIdSet = true;
            return this;
        }

        @Override
        public int getEgressTpid() {
            return this.egressTpid;
        }

        @Override
        public OFBsnVportQInQ.Builder setEgressTpid(int egressTpid) {
            this.egressTpid = egressTpid;
            this.egressTpidSet = true;
            return this;
        }

        @Override
        public int getEgressVlanId() {
            return this.egressVlanId;
        }

        @Override
        public OFBsnVportQInQ.Builder setEgressVlanId(int egressVlanId) {
            this.egressVlanId = egressVlanId;
            this.egressVlanIdSet = true;
            return this;
        }

        @Override
        public String getIfName() {
            return this.ifName;
        }

        @Override
        public OFBsnVportQInQ.Builder setIfName(String ifName) {
            this.ifName = ifName;
            this.ifNameSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFBsnVportQInQ build() {
            String ifName;
            long portNo = this.portNoSet ? this.portNo : 0L;
            int ingressTpid = this.ingressTpidSet ? this.ingressTpid : 0;
            int ingressVlanId = this.ingressVlanIdSet ? this.ingressVlanId : 0;
            int egressTpid = this.egressTpidSet ? this.egressTpid : 0;
            int egressVlanId = this.egressVlanIdSet ? this.egressVlanId : 0;
            String string = ifName = this.ifNameSet ? this.ifName : OFBsnVportQInQVer11.DEFAULT_IF_NAME;
            if (ifName == null) {
                throw new NullPointerException("Property ifName must not be null");
            }
            return new OFBsnVportQInQVer11(portNo, ingressTpid, ingressVlanId, egressTpid, egressVlanId, ifName);
        }
    }

    static class BuilderWithParent
    implements OFBsnVportQInQ.Builder {
        final OFBsnVportQInQVer11 parentMessage;
        private boolean portNoSet;
        private long portNo;
        private boolean ingressTpidSet;
        private int ingressTpid;
        private boolean ingressVlanIdSet;
        private int ingressVlanId;
        private boolean egressTpidSet;
        private int egressTpid;
        private boolean egressVlanIdSet;
        private int egressVlanId;
        private boolean ifNameSet;
        private String ifName;

        BuilderWithParent(OFBsnVportQInQVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public long getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnVportQInQ.Builder setPortNo(long portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public int getIngressTpid() {
            return this.ingressTpid;
        }

        @Override
        public OFBsnVportQInQ.Builder setIngressTpid(int ingressTpid) {
            this.ingressTpid = ingressTpid;
            this.ingressTpidSet = true;
            return this;
        }

        @Override
        public int getIngressVlanId() {
            return this.ingressVlanId;
        }

        @Override
        public OFBsnVportQInQ.Builder setIngressVlanId(int ingressVlanId) {
            this.ingressVlanId = ingressVlanId;
            this.ingressVlanIdSet = true;
            return this;
        }

        @Override
        public int getEgressTpid() {
            return this.egressTpid;
        }

        @Override
        public OFBsnVportQInQ.Builder setEgressTpid(int egressTpid) {
            this.egressTpid = egressTpid;
            this.egressTpidSet = true;
            return this;
        }

        @Override
        public int getEgressVlanId() {
            return this.egressVlanId;
        }

        @Override
        public OFBsnVportQInQ.Builder setEgressVlanId(int egressVlanId) {
            this.egressVlanId = egressVlanId;
            this.egressVlanIdSet = true;
            return this;
        }

        @Override
        public String getIfName() {
            return this.ifName;
        }

        @Override
        public OFBsnVportQInQ.Builder setIfName(String ifName) {
            this.ifName = ifName;
            this.ifNameSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFBsnVportQInQ build() {
            String ifName;
            long portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            int ingressTpid = this.ingressTpidSet ? this.ingressTpid : this.parentMessage.ingressTpid;
            int ingressVlanId = this.ingressVlanIdSet ? this.ingressVlanId : this.parentMessage.ingressVlanId;
            int egressTpid = this.egressTpidSet ? this.egressTpid : this.parentMessage.egressTpid;
            int egressVlanId = this.egressVlanIdSet ? this.egressVlanId : this.parentMessage.egressVlanId;
            String string = ifName = this.ifNameSet ? this.ifName : this.parentMessage.ifName;
            if (ifName == null) {
                throw new NullPointerException("Property ifName must not be null");
            }
            return new OFBsnVportQInQVer11(portNo, ingressTpid, ingressVlanId, egressTpid, egressVlanId, ifName);
        }
    }
}

