/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver11.OFStatsReplyFlagsSerializerVer11;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFDescStatsReplyVer11
implements OFDescStatsReply {
    private static final Logger logger = LoggerFactory.getLogger(OFDescStatsReplyVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 1072;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsReplyFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final String DEFAULT_MFR_DESC = "";
    private static final String DEFAULT_HW_DESC = "";
    private static final String DEFAULT_SW_DESC = "";
    private static final String DEFAULT_SERIAL_NUM = "";
    private static final String DEFAULT_DP_DESC = "";
    private final long xid;
    private final Set<OFStatsReplyFlags> flags;
    private final String mfrDesc;
    private final String hwDesc;
    private final String swDesc;
    private final String serialNum;
    private final String dpDesc;
    static final OFDescStatsReplyVer11 DEFAULT = new OFDescStatsReplyVer11(0L, DEFAULT_FLAGS, "", "", "", "", "");
    static final Reader READER = new Reader();
    static final OFDescStatsReplyVer11Funnel FUNNEL = new OFDescStatsReplyVer11Funnel();
    static final Writer WRITER = new Writer();

    OFDescStatsReplyVer11(long xid, Set<OFStatsReplyFlags> flags, String mfrDesc, String hwDesc, String swDesc, String serialNum, String dpDesc) {
        this.xid = xid;
        this.flags = flags;
        this.mfrDesc = mfrDesc;
        this.hwDesc = hwDesc;
        this.swDesc = swDesc;
        this.serialNum = serialNum;
        this.dpDesc = dpDesc;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.DESC;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return this.flags;
    }

    @Override
    public String getMfrDesc() {
        return this.mfrDesc;
    }

    @Override
    public String getHwDesc() {
        return this.hwDesc;
    }

    @Override
    public String getSwDesc() {
        return this.swDesc;
    }

    @Override
    public String getSerialNum() {
        return this.serialNum;
    }

    @Override
    public String getDpDesc() {
        return this.dpDesc;
    }

    @Override
    public OFDescStatsReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFDescStatsReplyVer11(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("mfrDesc=").append(this.mfrDesc);
        b.append(", ");
        b.append("hwDesc=").append(this.hwDesc);
        b.append(", ");
        b.append("swDesc=").append(this.swDesc);
        b.append(", ");
        b.append("serialNum=").append(this.serialNum);
        b.append(", ");
        b.append("dpDesc=").append(this.dpDesc);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFDescStatsReplyVer11 other = (OFDescStatsReplyVer11)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.mfrDesc == null ? other.mfrDesc != null : !this.mfrDesc.equals(other.mfrDesc)) {
            return false;
        }
        if (this.hwDesc == null ? other.hwDesc != null : !this.hwDesc.equals(other.hwDesc)) {
            return false;
        }
        if (this.swDesc == null ? other.swDesc != null : !this.swDesc.equals(other.swDesc)) {
            return false;
        }
        if (this.serialNum == null ? other.serialNum != null : !this.serialNum.equals(other.serialNum)) {
            return false;
        }
        return !(this.dpDesc == null ? other.dpDesc != null : !this.dpDesc.equals(other.dpDesc));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.mfrDesc == null ? 0 : this.mfrDesc.hashCode());
        result = 31 * result + (this.hwDesc == null ? 0 : this.hwDesc.hashCode());
        result = 31 * result + (this.swDesc == null ? 0 : this.swDesc.hashCode());
        result = 31 * result + (this.serialNum == null ? 0 : this.serialNum.hashCode());
        result = 31 * result + (this.dpDesc == null ? 0 : this.dpDesc.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFDescStatsReplyVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFDescStatsReplyVer11 message) {
            bb.writeByte(2);
            bb.writeByte(19);
            bb.writeShort(1072);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(0);
            OFStatsReplyFlagsSerializerVer11.writeTo(bb, message.flags);
            bb.writeZero(4);
            ChannelUtils.writeFixedLengthString(bb, message.mfrDesc, 256);
            ChannelUtils.writeFixedLengthString(bb, message.hwDesc, 256);
            ChannelUtils.writeFixedLengthString(bb, message.swDesc, 256);
            ChannelUtils.writeFixedLengthString(bb, message.serialNum, 32);
            ChannelUtils.writeFixedLengthString(bb, message.dpDesc, 256);
        }
    }

    static class OFDescStatsReplyVer11Funnel
    implements Funnel<OFDescStatsReplyVer11> {
        private static final long serialVersionUID = 1L;

        OFDescStatsReplyVer11Funnel() {
        }

        public void funnel(OFDescStatsReplyVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)19);
            sink.putShort((short)1072);
            sink.putLong(message.xid);
            sink.putShort((short)0);
            OFStatsReplyFlagsSerializerVer11.putTo(message.flags, sink);
            sink.putUnencodedChars((CharSequence)message.mfrDesc);
            sink.putUnencodedChars((CharSequence)message.hwDesc);
            sink.putUnencodedChars((CharSequence)message.swDesc);
            sink.putUnencodedChars((CharSequence)message.serialNum);
            sink.putUnencodedChars((CharSequence)message.dpDesc);
        }
    }

    static class Reader
    implements OFMessageReader<OFDescStatsReply> {
        Reader() {
        }

        @Override
        public OFDescStatsReply readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 1072) {
                throw new OFParseError("Wrong length: Expected=1072(1072), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 0) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.DESC(0), got=" + statsType);
            }
            Set<OFStatsReplyFlags> flags = OFStatsReplyFlagsSerializerVer11.readFrom(bb);
            bb.skipBytes(4);
            String mfrDesc = ChannelUtils.readFixedLengthString(bb, 256);
            String hwDesc = ChannelUtils.readFixedLengthString(bb, 256);
            String swDesc = ChannelUtils.readFixedLengthString(bb, 256);
            String serialNum = ChannelUtils.readFixedLengthString(bb, 32);
            String dpDesc = ChannelUtils.readFixedLengthString(bb, 256);
            OFDescStatsReplyVer11 descStatsReplyVer11 = new OFDescStatsReplyVer11(xid, flags, mfrDesc, hwDesc, swDesc, serialNum, dpDesc);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)descStatsReplyVer11);
            }
            return descStatsReplyVer11;
        }
    }

    static class Builder
    implements OFDescStatsReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean mfrDescSet;
        private String mfrDesc;
        private boolean hwDescSet;
        private String hwDesc;
        private boolean swDescSet;
        private String swDesc;
        private boolean serialNumSet;
        private String serialNum;
        private boolean dpDescSet;
        private String dpDesc;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFDescStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.DESC;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFDescStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public String getMfrDesc() {
            return this.mfrDesc;
        }

        @Override
        public OFDescStatsReply.Builder setMfrDesc(String mfrDesc) {
            this.mfrDesc = mfrDesc;
            this.mfrDescSet = true;
            return this;
        }

        @Override
        public String getHwDesc() {
            return this.hwDesc;
        }

        @Override
        public OFDescStatsReply.Builder setHwDesc(String hwDesc) {
            this.hwDesc = hwDesc;
            this.hwDescSet = true;
            return this;
        }

        @Override
        public String getSwDesc() {
            return this.swDesc;
        }

        @Override
        public OFDescStatsReply.Builder setSwDesc(String swDesc) {
            this.swDesc = swDesc;
            this.swDescSet = true;
            return this;
        }

        @Override
        public String getSerialNum() {
            return this.serialNum;
        }

        @Override
        public OFDescStatsReply.Builder setSerialNum(String serialNum) {
            this.serialNum = serialNum;
            this.serialNumSet = true;
            return this;
        }

        @Override
        public String getDpDesc() {
            return this.dpDesc;
        }

        @Override
        public OFDescStatsReply.Builder setDpDesc(String dpDesc) {
            this.dpDesc = dpDesc;
            this.dpDescSet = true;
            return this;
        }

        @Override
        public OFDescStatsReply build() {
            String dpDesc;
            String serialNum;
            String swDesc;
            String hwDesc;
            String mfrDesc;
            Set<OFStatsReplyFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsReplyFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            String string = mfrDesc = this.mfrDescSet ? this.mfrDesc : "";
            if (mfrDesc == null) {
                throw new NullPointerException("Property mfrDesc must not be null");
            }
            String string2 = hwDesc = this.hwDescSet ? this.hwDesc : "";
            if (hwDesc == null) {
                throw new NullPointerException("Property hwDesc must not be null");
            }
            String string3 = swDesc = this.swDescSet ? this.swDesc : "";
            if (swDesc == null) {
                throw new NullPointerException("Property swDesc must not be null");
            }
            String string4 = serialNum = this.serialNumSet ? this.serialNum : "";
            if (serialNum == null) {
                throw new NullPointerException("Property serialNum must not be null");
            }
            String string5 = dpDesc = this.dpDescSet ? this.dpDesc : "";
            if (dpDesc == null) {
                throw new NullPointerException("Property dpDesc must not be null");
            }
            return new OFDescStatsReplyVer11(xid, flags, mfrDesc, hwDesc, swDesc, serialNum, dpDesc);
        }
    }

    static class BuilderWithParent
    implements OFDescStatsReply.Builder {
        final OFDescStatsReplyVer11 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean mfrDescSet;
        private String mfrDesc;
        private boolean hwDescSet;
        private String hwDesc;
        private boolean swDescSet;
        private String swDesc;
        private boolean serialNumSet;
        private String serialNum;
        private boolean dpDescSet;
        private String dpDesc;

        BuilderWithParent(OFDescStatsReplyVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFDescStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.DESC;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFDescStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public String getMfrDesc() {
            return this.mfrDesc;
        }

        @Override
        public OFDescStatsReply.Builder setMfrDesc(String mfrDesc) {
            this.mfrDesc = mfrDesc;
            this.mfrDescSet = true;
            return this;
        }

        @Override
        public String getHwDesc() {
            return this.hwDesc;
        }

        @Override
        public OFDescStatsReply.Builder setHwDesc(String hwDesc) {
            this.hwDesc = hwDesc;
            this.hwDescSet = true;
            return this;
        }

        @Override
        public String getSwDesc() {
            return this.swDesc;
        }

        @Override
        public OFDescStatsReply.Builder setSwDesc(String swDesc) {
            this.swDesc = swDesc;
            this.swDescSet = true;
            return this;
        }

        @Override
        public String getSerialNum() {
            return this.serialNum;
        }

        @Override
        public OFDescStatsReply.Builder setSerialNum(String serialNum) {
            this.serialNum = serialNum;
            this.serialNumSet = true;
            return this;
        }

        @Override
        public String getDpDesc() {
            return this.dpDesc;
        }

        @Override
        public OFDescStatsReply.Builder setDpDesc(String dpDesc) {
            this.dpDesc = dpDesc;
            this.dpDescSet = true;
            return this;
        }

        @Override
        public OFDescStatsReply build() {
            String dpDesc;
            String serialNum;
            String swDesc;
            String hwDesc;
            String mfrDesc;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            String string = mfrDesc = this.mfrDescSet ? this.mfrDesc : this.parentMessage.mfrDesc;
            if (mfrDesc == null) {
                throw new NullPointerException("Property mfrDesc must not be null");
            }
            String string2 = hwDesc = this.hwDescSet ? this.hwDesc : this.parentMessage.hwDesc;
            if (hwDesc == null) {
                throw new NullPointerException("Property hwDesc must not be null");
            }
            String string3 = swDesc = this.swDescSet ? this.swDesc : this.parentMessage.swDesc;
            if (swDesc == null) {
                throw new NullPointerException("Property swDesc must not be null");
            }
            String string4 = serialNum = this.serialNumSet ? this.serialNum : this.parentMessage.serialNum;
            if (serialNum == null) {
                throw new NullPointerException("Property serialNum must not be null");
            }
            String string5 = dpDesc = this.dpDescSet ? this.dpDesc : this.parentMessage.dpDesc;
            if (dpDesc == null) {
                throw new NullPointerException("Property dpDesc must not be null");
            }
            return new OFDescStatsReplyVer11(xid, flags, mfrDesc, hwDesc, swDesc, serialNum, dpDesc);
        }
    }
}

