/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFExperimenter;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver11.OFBsnHeaderVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFNiciraHeaderVer11;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFExperimenterVer11 {
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 12;
    public static final Reader READER = new Reader();

    OFExperimenterVer11() {
    }

    static class Reader
    implements OFMessageReader<OFExperimenter> {
        Reader() {
        }

        @Override
        public OFExperimenter readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 12) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            U32.f(bb.readInt());
            int experimenter = bb.readInt();
            bb.readerIndex(start);
            switch (experimenter) {
                case 6035143: {
                    return OFBsnHeaderVer11.READER.readFrom(bb);
                }
                case 8992: {
                    return OFNiciraHeaderVer11.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator experimenter of class OFExperimenterVer11: " + experimenter);
        }
    }
}

