/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPacketIn;
import org.projectfloodlight.openflow.protocol.OFPacketInReason;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.ver11.OFPacketInReasonSerializerVer11;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPacketInVer11
implements OFPacketIn {
    private static final Logger logger = LoggerFactory.getLogger(OFPacketInVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final OFBufferId DEFAULT_BUFFER_ID = OFBufferId.NO_BUFFER;
    private static final OFPort DEFAULT_IN_PORT = OFPort.ANY;
    private static final OFPort DEFAULT_IN_PHY_PORT = OFPort.ANY;
    private static final int DEFAULT_TOTAL_LEN = 0;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final byte[] DEFAULT_DATA = new byte[0];
    private final long xid;
    private final OFBufferId bufferId;
    private final OFPort inPort;
    private final OFPort inPhyPort;
    private final int totalLen;
    private final OFPacketInReason reason;
    private final TableId tableId;
    private final byte[] data;
    static final Reader READER = new Reader();
    static final OFPacketInVer11Funnel FUNNEL = new OFPacketInVer11Funnel();
    static final Writer WRITER = new Writer();

    OFPacketInVer11(long xid, OFBufferId bufferId, OFPort inPort, OFPort inPhyPort, int totalLen, OFPacketInReason reason, TableId tableId, byte[] data) {
        this.xid = xid;
        this.bufferId = bufferId;
        this.inPort = inPort;
        this.inPhyPort = inPhyPort;
        this.totalLen = totalLen;
        this.reason = reason;
        this.tableId = tableId;
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.PACKET_IN;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFBufferId getBufferId() {
        return this.bufferId;
    }

    @Override
    public int getTotalLen() {
        return this.totalLen;
    }

    @Override
    public OFPacketInReason getReason() {
        return this.reason;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public Match getMatch() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property match not supported in version 1.1");
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public OFPort getInPort() {
        return this.inPort;
    }

    @Override
    public OFPort getInPhyPort() {
        return this.inPhyPort;
    }

    @Override
    public U64 getCookie() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property cookie not supported in version 1.1");
    }

    @Override
    public OFPacketIn.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPacketInVer11(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("bufferId=").append(this.bufferId);
        b.append(", ");
        b.append("inPort=").append(this.inPort);
        b.append(", ");
        b.append("inPhyPort=").append(this.inPhyPort);
        b.append(", ");
        b.append("totalLen=").append(this.totalLen);
        b.append(", ");
        b.append("reason=").append((Object)this.reason);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("data=").append(Arrays.toString(this.data));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPacketInVer11 other = (OFPacketInVer11)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.bufferId == null ? other.bufferId != null : !this.bufferId.equals(other.bufferId)) {
            return false;
        }
        if (this.inPort == null ? other.inPort != null : !this.inPort.equals(other.inPort)) {
            return false;
        }
        if (this.inPhyPort == null ? other.inPhyPort != null : !this.inPhyPort.equals(other.inPhyPort)) {
            return false;
        }
        if (this.totalLen != other.totalLen) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.bufferId == null ? 0 : this.bufferId.hashCode());
        result = 31 * result + (this.inPort == null ? 0 : this.inPort.hashCode());
        result = 31 * result + (this.inPhyPort == null ? 0 : this.inPhyPort.hashCode());
        result = 31 * result + this.totalLen;
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPacketInVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFPacketInVer11 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(2);
            bb.writeByte(10);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(message.bufferId.getInt());
            message.inPort.write4Bytes(bb);
            message.inPhyPort.write4Bytes(bb);
            bb.writeShort((int)U16.t(message.totalLen));
            OFPacketInReasonSerializerVer11.writeTo(bb, message.reason);
            message.tableId.writeByte(bb);
            bb.writeBytes(message.data);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFPacketInVer11Funnel
    implements Funnel<OFPacketInVer11> {
        private static final long serialVersionUID = 1L;

        OFPacketInVer11Funnel() {
        }

        public void funnel(OFPacketInVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)10);
            sink.putLong(message.xid);
            message.bufferId.putTo(sink);
            message.inPort.putTo(sink);
            message.inPhyPort.putTo(sink);
            sink.putInt(message.totalLen);
            OFPacketInReasonSerializerVer11.putTo(message.reason, sink);
            message.tableId.putTo(sink);
            sink.putBytes(message.data);
        }
    }

    static class Reader
    implements OFMessageReader<OFPacketIn> {
        Reader() {
        }

        @Override
        public OFPacketIn readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 10) {
                throw new OFParseError("Wrong type: Expected=OFType.PACKET_IN(10), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 24) {
                throw new OFParseError("Wrong length: Expected to be >= 24, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFBufferId bufferId = OFBufferId.of(bb.readInt());
            OFPort inPort = OFPort.read4Bytes(bb);
            OFPort inPhyPort = OFPort.read4Bytes(bb);
            int totalLen = U16.f(bb.readShort());
            OFPacketInReason reason = OFPacketInReasonSerializerVer11.readFrom(bb);
            TableId tableId = TableId.readByte(bb);
            byte[] data = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFPacketInVer11 packetInVer11 = new OFPacketInVer11(xid, bufferId, inPort, inPhyPort, totalLen, reason, tableId, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)packetInVer11);
            }
            return packetInVer11;
        }
    }

    static class Builder
    implements OFPacketIn.Builder {
        private boolean xidSet;
        private long xid;
        private boolean bufferIdSet;
        private OFBufferId bufferId;
        private boolean inPortSet;
        private OFPort inPort;
        private boolean inPhyPortSet;
        private OFPort inPhyPort;
        private boolean totalLenSet;
        private int totalLen;
        private boolean reasonSet;
        private OFPacketInReason reason;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean dataSet;
        private byte[] data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.PACKET_IN;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPacketIn.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFBufferId getBufferId() {
            return this.bufferId;
        }

        @Override
        public OFPacketIn.Builder setBufferId(OFBufferId bufferId) {
            this.bufferId = bufferId;
            this.bufferIdSet = true;
            return this;
        }

        @Override
        public int getTotalLen() {
            return this.totalLen;
        }

        @Override
        public OFPacketIn.Builder setTotalLen(int totalLen) {
            this.totalLen = totalLen;
            this.totalLenSet = true;
            return this;
        }

        @Override
        public OFPacketInReason getReason() {
            return this.reason;
        }

        @Override
        public OFPacketIn.Builder setReason(OFPacketInReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFPacketIn.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public Match getMatch() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property match not supported in version 1.1");
        }

        @Override
        public OFPacketIn.Builder setMatch(Match match) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property match not supported in version 1.1");
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFPacketIn.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFPort getInPort() {
            return this.inPort;
        }

        @Override
        public OFPacketIn.Builder setInPort(OFPort inPort) {
            this.inPort = inPort;
            this.inPortSet = true;
            return this;
        }

        @Override
        public OFPort getInPhyPort() {
            return this.inPhyPort;
        }

        @Override
        public OFPacketIn.Builder setInPhyPort(OFPort inPhyPort) {
            this.inPhyPort = inPhyPort;
            this.inPhyPortSet = true;
            return this;
        }

        @Override
        public U64 getCookie() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookie not supported in version 1.1");
        }

        @Override
        public OFPacketIn.Builder setCookie(U64 cookie) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookie not supported in version 1.1");
        }

        @Override
        public OFPacketIn build() {
            byte[] data;
            TableId tableId;
            int totalLen;
            OFPort inPhyPort;
            OFPort inPort;
            OFBufferId bufferId;
            long xid = this.xidSet ? this.xid : 0L;
            OFBufferId oFBufferId = bufferId = this.bufferIdSet ? this.bufferId : DEFAULT_BUFFER_ID;
            if (bufferId == null) {
                throw new NullPointerException("Property bufferId must not be null");
            }
            OFPort oFPort = inPort = this.inPortSet ? this.inPort : DEFAULT_IN_PORT;
            if (inPort == null) {
                throw new NullPointerException("Property inPort must not be null");
            }
            OFPort oFPort2 = inPhyPort = this.inPhyPortSet ? this.inPhyPort : DEFAULT_IN_PHY_PORT;
            if (inPhyPort == null) {
                throw new NullPointerException("Property inPhyPort must not be null");
            }
            int n = totalLen = this.totalLenSet ? this.totalLen : 0;
            if (!this.reasonSet) {
                throw new IllegalStateException("Property reason doesn't have default value -- must be set");
            }
            if (this.reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            byte[] byArray = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFPacketInVer11(xid, bufferId, inPort, inPhyPort, totalLen, this.reason, tableId, data);
        }
    }

    static class BuilderWithParent
    implements OFPacketIn.Builder {
        final OFPacketInVer11 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean bufferIdSet;
        private OFBufferId bufferId;
        private boolean inPortSet;
        private OFPort inPort;
        private boolean inPhyPortSet;
        private OFPort inPhyPort;
        private boolean totalLenSet;
        private int totalLen;
        private boolean reasonSet;
        private OFPacketInReason reason;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean dataSet;
        private byte[] data;

        BuilderWithParent(OFPacketInVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.PACKET_IN;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPacketIn.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFBufferId getBufferId() {
            return this.bufferId;
        }

        @Override
        public OFPacketIn.Builder setBufferId(OFBufferId bufferId) {
            this.bufferId = bufferId;
            this.bufferIdSet = true;
            return this;
        }

        @Override
        public int getTotalLen() {
            return this.totalLen;
        }

        @Override
        public OFPacketIn.Builder setTotalLen(int totalLen) {
            this.totalLen = totalLen;
            this.totalLenSet = true;
            return this;
        }

        @Override
        public OFPacketInReason getReason() {
            return this.reason;
        }

        @Override
        public OFPacketIn.Builder setReason(OFPacketInReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFPacketIn.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public Match getMatch() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property match not supported in version 1.1");
        }

        @Override
        public OFPacketIn.Builder setMatch(Match match) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property match not supported in version 1.1");
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFPacketIn.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFPort getInPort() {
            return this.inPort;
        }

        @Override
        public OFPacketIn.Builder setInPort(OFPort inPort) {
            this.inPort = inPort;
            this.inPortSet = true;
            return this;
        }

        @Override
        public OFPort getInPhyPort() {
            return this.inPhyPort;
        }

        @Override
        public OFPacketIn.Builder setInPhyPort(OFPort inPhyPort) {
            this.inPhyPort = inPhyPort;
            this.inPhyPortSet = true;
            return this;
        }

        @Override
        public U64 getCookie() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookie not supported in version 1.1");
        }

        @Override
        public OFPacketIn.Builder setCookie(U64 cookie) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookie not supported in version 1.1");
        }

        @Override
        public OFPacketIn build() {
            byte[] data;
            TableId tableId;
            OFPacketInReason reason;
            OFPort inPhyPort;
            OFPort inPort;
            OFBufferId bufferId;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFBufferId oFBufferId = bufferId = this.bufferIdSet ? this.bufferId : this.parentMessage.bufferId;
            if (bufferId == null) {
                throw new NullPointerException("Property bufferId must not be null");
            }
            OFPort oFPort = inPort = this.inPortSet ? this.inPort : this.parentMessage.inPort;
            if (inPort == null) {
                throw new NullPointerException("Property inPort must not be null");
            }
            OFPort oFPort2 = inPhyPort = this.inPhyPortSet ? this.inPhyPort : this.parentMessage.inPhyPort;
            if (inPhyPort == null) {
                throw new NullPointerException("Property inPhyPort must not be null");
            }
            int totalLen = this.totalLenSet ? this.totalLen : this.parentMessage.totalLen;
            OFPacketInReason oFPacketInReason = reason = this.reasonSet ? this.reason : this.parentMessage.reason;
            if (reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            byte[] byArray = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFPacketInVer11(xid, bufferId, inPort, inPhyPort, totalLen, reason, tableId, data);
        }
    }
}

