/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortStatsEntry;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortStatsEntryVer11
implements OFPortStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFPortStatsEntryVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 104;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final U64 DEFAULT_RX_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_TX_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_RX_BYTES = U64.ZERO;
    private static final U64 DEFAULT_TX_BYTES = U64.ZERO;
    private static final U64 DEFAULT_RX_DROPPED = U64.ZERO;
    private static final U64 DEFAULT_TX_DROPPED = U64.ZERO;
    private static final U64 DEFAULT_RX_ERRORS = U64.ZERO;
    private static final U64 DEFAULT_TX_ERRORS = U64.ZERO;
    private static final U64 DEFAULT_RX_FRAME_ERR = U64.ZERO;
    private static final U64 DEFAULT_RX_OVER_ERR = U64.ZERO;
    private static final U64 DEFAULT_RX_CRC_ERR = U64.ZERO;
    private static final U64 DEFAULT_COLLISIONS = U64.ZERO;
    private final OFPort portNo;
    private final U64 rxPackets;
    private final U64 txPackets;
    private final U64 rxBytes;
    private final U64 txBytes;
    private final U64 rxDropped;
    private final U64 txDropped;
    private final U64 rxErrors;
    private final U64 txErrors;
    private final U64 rxFrameErr;
    private final U64 rxOverErr;
    private final U64 rxCrcErr;
    private final U64 collisions;
    static final OFPortStatsEntryVer11 DEFAULT = new OFPortStatsEntryVer11(DEFAULT_PORT_NO, DEFAULT_RX_PACKETS, DEFAULT_TX_PACKETS, DEFAULT_RX_BYTES, DEFAULT_TX_BYTES, DEFAULT_RX_DROPPED, DEFAULT_TX_DROPPED, DEFAULT_RX_ERRORS, DEFAULT_TX_ERRORS, DEFAULT_RX_FRAME_ERR, DEFAULT_RX_OVER_ERR, DEFAULT_RX_CRC_ERR, DEFAULT_COLLISIONS);
    static final Reader READER = new Reader();
    static final OFPortStatsEntryVer11Funnel FUNNEL = new OFPortStatsEntryVer11Funnel();
    static final Writer WRITER = new Writer();

    OFPortStatsEntryVer11(OFPort portNo, U64 rxPackets, U64 txPackets, U64 rxBytes, U64 txBytes, U64 rxDropped, U64 txDropped, U64 rxErrors, U64 txErrors, U64 rxFrameErr, U64 rxOverErr, U64 rxCrcErr, U64 collisions) {
        this.portNo = portNo;
        this.rxPackets = rxPackets;
        this.txPackets = txPackets;
        this.rxBytes = rxBytes;
        this.txBytes = txBytes;
        this.rxDropped = rxDropped;
        this.txDropped = txDropped;
        this.rxErrors = rxErrors;
        this.txErrors = txErrors;
        this.rxFrameErr = rxFrameErr;
        this.rxOverErr = rxOverErr;
        this.rxCrcErr = rxCrcErr;
        this.collisions = collisions;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public U64 getRxPackets() {
        return this.rxPackets;
    }

    @Override
    public U64 getTxPackets() {
        return this.txPackets;
    }

    @Override
    public U64 getRxBytes() {
        return this.rxBytes;
    }

    @Override
    public U64 getTxBytes() {
        return this.txBytes;
    }

    @Override
    public U64 getRxDropped() {
        return this.rxDropped;
    }

    @Override
    public U64 getTxDropped() {
        return this.txDropped;
    }

    @Override
    public U64 getRxErrors() {
        return this.rxErrors;
    }

    @Override
    public U64 getTxErrors() {
        return this.txErrors;
    }

    @Override
    public U64 getRxFrameErr() {
        return this.rxFrameErr;
    }

    @Override
    public U64 getRxOverErr() {
        return this.rxOverErr;
    }

    @Override
    public U64 getRxCrcErr() {
        return this.rxCrcErr;
    }

    @Override
    public U64 getCollisions() {
        return this.collisions;
    }

    @Override
    public long getDurationSec() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationSec not supported in version 1.1");
    }

    @Override
    public long getDurationNsec() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationNsec not supported in version 1.1");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFPortStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortStatsEntryVer11(");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("rxPackets=").append(this.rxPackets);
        b.append(", ");
        b.append("txPackets=").append(this.txPackets);
        b.append(", ");
        b.append("rxBytes=").append(this.rxBytes);
        b.append(", ");
        b.append("txBytes=").append(this.txBytes);
        b.append(", ");
        b.append("rxDropped=").append(this.rxDropped);
        b.append(", ");
        b.append("txDropped=").append(this.txDropped);
        b.append(", ");
        b.append("rxErrors=").append(this.rxErrors);
        b.append(", ");
        b.append("txErrors=").append(this.txErrors);
        b.append(", ");
        b.append("rxFrameErr=").append(this.rxFrameErr);
        b.append(", ");
        b.append("rxOverErr=").append(this.rxOverErr);
        b.append(", ");
        b.append("rxCrcErr=").append(this.rxCrcErr);
        b.append(", ");
        b.append("collisions=").append(this.collisions);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortStatsEntryVer11 other = (OFPortStatsEntryVer11)obj;
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.rxPackets == null ? other.rxPackets != null : !this.rxPackets.equals(other.rxPackets)) {
            return false;
        }
        if (this.txPackets == null ? other.txPackets != null : !this.txPackets.equals(other.txPackets)) {
            return false;
        }
        if (this.rxBytes == null ? other.rxBytes != null : !this.rxBytes.equals(other.rxBytes)) {
            return false;
        }
        if (this.txBytes == null ? other.txBytes != null : !this.txBytes.equals(other.txBytes)) {
            return false;
        }
        if (this.rxDropped == null ? other.rxDropped != null : !this.rxDropped.equals(other.rxDropped)) {
            return false;
        }
        if (this.txDropped == null ? other.txDropped != null : !this.txDropped.equals(other.txDropped)) {
            return false;
        }
        if (this.rxErrors == null ? other.rxErrors != null : !this.rxErrors.equals(other.rxErrors)) {
            return false;
        }
        if (this.txErrors == null ? other.txErrors != null : !this.txErrors.equals(other.txErrors)) {
            return false;
        }
        if (this.rxFrameErr == null ? other.rxFrameErr != null : !this.rxFrameErr.equals(other.rxFrameErr)) {
            return false;
        }
        if (this.rxOverErr == null ? other.rxOverErr != null : !this.rxOverErr.equals(other.rxOverErr)) {
            return false;
        }
        if (this.rxCrcErr == null ? other.rxCrcErr != null : !this.rxCrcErr.equals(other.rxCrcErr)) {
            return false;
        }
        return !(this.collisions == null ? other.collisions != null : !this.collisions.equals(other.collisions));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + (this.rxPackets == null ? 0 : this.rxPackets.hashCode());
        result = 31 * result + (this.txPackets == null ? 0 : this.txPackets.hashCode());
        result = 31 * result + (this.rxBytes == null ? 0 : this.rxBytes.hashCode());
        result = 31 * result + (this.txBytes == null ? 0 : this.txBytes.hashCode());
        result = 31 * result + (this.rxDropped == null ? 0 : this.rxDropped.hashCode());
        result = 31 * result + (this.txDropped == null ? 0 : this.txDropped.hashCode());
        result = 31 * result + (this.rxErrors == null ? 0 : this.rxErrors.hashCode());
        result = 31 * result + (this.txErrors == null ? 0 : this.txErrors.hashCode());
        result = 31 * result + (this.rxFrameErr == null ? 0 : this.rxFrameErr.hashCode());
        result = 31 * result + (this.rxOverErr == null ? 0 : this.rxOverErr.hashCode());
        result = 31 * result + (this.rxCrcErr == null ? 0 : this.rxCrcErr.hashCode());
        result = 31 * result + (this.collisions == null ? 0 : this.collisions.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortStatsEntryVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFPortStatsEntryVer11 message) {
            message.portNo.write4Bytes(bb);
            bb.writeZero(4);
            bb.writeLong(message.rxPackets.getValue());
            bb.writeLong(message.txPackets.getValue());
            bb.writeLong(message.rxBytes.getValue());
            bb.writeLong(message.txBytes.getValue());
            bb.writeLong(message.rxDropped.getValue());
            bb.writeLong(message.txDropped.getValue());
            bb.writeLong(message.rxErrors.getValue());
            bb.writeLong(message.txErrors.getValue());
            bb.writeLong(message.rxFrameErr.getValue());
            bb.writeLong(message.rxOverErr.getValue());
            bb.writeLong(message.rxCrcErr.getValue());
            bb.writeLong(message.collisions.getValue());
        }
    }

    static class OFPortStatsEntryVer11Funnel
    implements Funnel<OFPortStatsEntryVer11> {
        private static final long serialVersionUID = 1L;

        OFPortStatsEntryVer11Funnel() {
        }

        public void funnel(OFPortStatsEntryVer11 message, PrimitiveSink sink) {
            message.portNo.putTo(sink);
            message.rxPackets.putTo(sink);
            message.txPackets.putTo(sink);
            message.rxBytes.putTo(sink);
            message.txBytes.putTo(sink);
            message.rxDropped.putTo(sink);
            message.txDropped.putTo(sink);
            message.rxErrors.putTo(sink);
            message.txErrors.putTo(sink);
            message.rxFrameErr.putTo(sink);
            message.rxOverErr.putTo(sink);
            message.rxCrcErr.putTo(sink);
            message.collisions.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortStatsEntry> {
        Reader() {
        }

        @Override
        public OFPortStatsEntry readFrom(ChannelBuffer bb) throws OFParseError {
            OFPort portNo = OFPort.read4Bytes(bb);
            bb.skipBytes(4);
            U64 rxPackets = U64.ofRaw(bb.readLong());
            U64 txPackets = U64.ofRaw(bb.readLong());
            U64 rxBytes = U64.ofRaw(bb.readLong());
            U64 txBytes = U64.ofRaw(bb.readLong());
            U64 rxDropped = U64.ofRaw(bb.readLong());
            U64 txDropped = U64.ofRaw(bb.readLong());
            U64 rxErrors = U64.ofRaw(bb.readLong());
            U64 txErrors = U64.ofRaw(bb.readLong());
            U64 rxFrameErr = U64.ofRaw(bb.readLong());
            U64 rxOverErr = U64.ofRaw(bb.readLong());
            U64 rxCrcErr = U64.ofRaw(bb.readLong());
            U64 collisions = U64.ofRaw(bb.readLong());
            OFPortStatsEntryVer11 portStatsEntryVer11 = new OFPortStatsEntryVer11(portNo, rxPackets, txPackets, rxBytes, txBytes, rxDropped, txDropped, rxErrors, txErrors, rxFrameErr, rxOverErr, rxCrcErr, collisions);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portStatsEntryVer11);
            }
            return portStatsEntryVer11;
        }
    }

    static class Builder
    implements OFPortStatsEntry.Builder {
        private boolean portNoSet;
        private OFPort portNo;
        private boolean rxPacketsSet;
        private U64 rxPackets;
        private boolean txPacketsSet;
        private U64 txPackets;
        private boolean rxBytesSet;
        private U64 rxBytes;
        private boolean txBytesSet;
        private U64 txBytes;
        private boolean rxDroppedSet;
        private U64 rxDropped;
        private boolean txDroppedSet;
        private U64 txDropped;
        private boolean rxErrorsSet;
        private U64 rxErrors;
        private boolean txErrorsSet;
        private U64 txErrors;
        private boolean rxFrameErrSet;
        private U64 rxFrameErr;
        private boolean rxOverErrSet;
        private U64 rxOverErr;
        private boolean rxCrcErrSet;
        private U64 rxCrcErr;
        private boolean collisionsSet;
        private U64 collisions;

        Builder() {
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFPortStatsEntry.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public U64 getRxPackets() {
            return this.rxPackets;
        }

        @Override
        public OFPortStatsEntry.Builder setRxPackets(U64 rxPackets) {
            this.rxPackets = rxPackets;
            this.rxPacketsSet = true;
            return this;
        }

        @Override
        public U64 getTxPackets() {
            return this.txPackets;
        }

        @Override
        public OFPortStatsEntry.Builder setTxPackets(U64 txPackets) {
            this.txPackets = txPackets;
            this.txPacketsSet = true;
            return this;
        }

        @Override
        public U64 getRxBytes() {
            return this.rxBytes;
        }

        @Override
        public OFPortStatsEntry.Builder setRxBytes(U64 rxBytes) {
            this.rxBytes = rxBytes;
            this.rxBytesSet = true;
            return this;
        }

        @Override
        public U64 getTxBytes() {
            return this.txBytes;
        }

        @Override
        public OFPortStatsEntry.Builder setTxBytes(U64 txBytes) {
            this.txBytes = txBytes;
            this.txBytesSet = true;
            return this;
        }

        @Override
        public U64 getRxDropped() {
            return this.rxDropped;
        }

        @Override
        public OFPortStatsEntry.Builder setRxDropped(U64 rxDropped) {
            this.rxDropped = rxDropped;
            this.rxDroppedSet = true;
            return this;
        }

        @Override
        public U64 getTxDropped() {
            return this.txDropped;
        }

        @Override
        public OFPortStatsEntry.Builder setTxDropped(U64 txDropped) {
            this.txDropped = txDropped;
            this.txDroppedSet = true;
            return this;
        }

        @Override
        public U64 getRxErrors() {
            return this.rxErrors;
        }

        @Override
        public OFPortStatsEntry.Builder setRxErrors(U64 rxErrors) {
            this.rxErrors = rxErrors;
            this.rxErrorsSet = true;
            return this;
        }

        @Override
        public U64 getTxErrors() {
            return this.txErrors;
        }

        @Override
        public OFPortStatsEntry.Builder setTxErrors(U64 txErrors) {
            this.txErrors = txErrors;
            this.txErrorsSet = true;
            return this;
        }

        @Override
        public U64 getRxFrameErr() {
            return this.rxFrameErr;
        }

        @Override
        public OFPortStatsEntry.Builder setRxFrameErr(U64 rxFrameErr) {
            this.rxFrameErr = rxFrameErr;
            this.rxFrameErrSet = true;
            return this;
        }

        @Override
        public U64 getRxOverErr() {
            return this.rxOverErr;
        }

        @Override
        public OFPortStatsEntry.Builder setRxOverErr(U64 rxOverErr) {
            this.rxOverErr = rxOverErr;
            this.rxOverErrSet = true;
            return this;
        }

        @Override
        public U64 getRxCrcErr() {
            return this.rxCrcErr;
        }

        @Override
        public OFPortStatsEntry.Builder setRxCrcErr(U64 rxCrcErr) {
            this.rxCrcErr = rxCrcErr;
            this.rxCrcErrSet = true;
            return this;
        }

        @Override
        public U64 getCollisions() {
            return this.collisions;
        }

        @Override
        public OFPortStatsEntry.Builder setCollisions(U64 collisions) {
            this.collisions = collisions;
            this.collisionsSet = true;
            return this;
        }

        @Override
        public long getDurationSec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.1");
        }

        @Override
        public OFPortStatsEntry.Builder setDurationSec(long durationSec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.1");
        }

        @Override
        public long getDurationNsec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.1");
        }

        @Override
        public OFPortStatsEntry.Builder setDurationNsec(long durationNsec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.1");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFPortStatsEntry build() {
            U64 collisions;
            U64 rxCrcErr;
            U64 rxOverErr;
            U64 rxFrameErr;
            U64 txErrors;
            U64 rxErrors;
            U64 txDropped;
            U64 rxDropped;
            U64 txBytes;
            U64 rxBytes;
            U64 txPackets;
            U64 rxPackets;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            U64 u64 = rxPackets = this.rxPacketsSet ? this.rxPackets : DEFAULT_RX_PACKETS;
            if (rxPackets == null) {
                throw new NullPointerException("Property rxPackets must not be null");
            }
            U64 u642 = txPackets = this.txPacketsSet ? this.txPackets : DEFAULT_TX_PACKETS;
            if (txPackets == null) {
                throw new NullPointerException("Property txPackets must not be null");
            }
            U64 u643 = rxBytes = this.rxBytesSet ? this.rxBytes : DEFAULT_RX_BYTES;
            if (rxBytes == null) {
                throw new NullPointerException("Property rxBytes must not be null");
            }
            U64 u644 = txBytes = this.txBytesSet ? this.txBytes : DEFAULT_TX_BYTES;
            if (txBytes == null) {
                throw new NullPointerException("Property txBytes must not be null");
            }
            U64 u645 = rxDropped = this.rxDroppedSet ? this.rxDropped : DEFAULT_RX_DROPPED;
            if (rxDropped == null) {
                throw new NullPointerException("Property rxDropped must not be null");
            }
            U64 u646 = txDropped = this.txDroppedSet ? this.txDropped : DEFAULT_TX_DROPPED;
            if (txDropped == null) {
                throw new NullPointerException("Property txDropped must not be null");
            }
            U64 u647 = rxErrors = this.rxErrorsSet ? this.rxErrors : DEFAULT_RX_ERRORS;
            if (rxErrors == null) {
                throw new NullPointerException("Property rxErrors must not be null");
            }
            U64 u648 = txErrors = this.txErrorsSet ? this.txErrors : DEFAULT_TX_ERRORS;
            if (txErrors == null) {
                throw new NullPointerException("Property txErrors must not be null");
            }
            U64 u649 = rxFrameErr = this.rxFrameErrSet ? this.rxFrameErr : DEFAULT_RX_FRAME_ERR;
            if (rxFrameErr == null) {
                throw new NullPointerException("Property rxFrameErr must not be null");
            }
            U64 u6410 = rxOverErr = this.rxOverErrSet ? this.rxOverErr : DEFAULT_RX_OVER_ERR;
            if (rxOverErr == null) {
                throw new NullPointerException("Property rxOverErr must not be null");
            }
            U64 u6411 = rxCrcErr = this.rxCrcErrSet ? this.rxCrcErr : DEFAULT_RX_CRC_ERR;
            if (rxCrcErr == null) {
                throw new NullPointerException("Property rxCrcErr must not be null");
            }
            U64 u6412 = collisions = this.collisionsSet ? this.collisions : DEFAULT_COLLISIONS;
            if (collisions == null) {
                throw new NullPointerException("Property collisions must not be null");
            }
            return new OFPortStatsEntryVer11(portNo, rxPackets, txPackets, rxBytes, txBytes, rxDropped, txDropped, rxErrors, txErrors, rxFrameErr, rxOverErr, rxCrcErr, collisions);
        }
    }

    static class BuilderWithParent
    implements OFPortStatsEntry.Builder {
        final OFPortStatsEntryVer11 parentMessage;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean rxPacketsSet;
        private U64 rxPackets;
        private boolean txPacketsSet;
        private U64 txPackets;
        private boolean rxBytesSet;
        private U64 rxBytes;
        private boolean txBytesSet;
        private U64 txBytes;
        private boolean rxDroppedSet;
        private U64 rxDropped;
        private boolean txDroppedSet;
        private U64 txDropped;
        private boolean rxErrorsSet;
        private U64 rxErrors;
        private boolean txErrorsSet;
        private U64 txErrors;
        private boolean rxFrameErrSet;
        private U64 rxFrameErr;
        private boolean rxOverErrSet;
        private U64 rxOverErr;
        private boolean rxCrcErrSet;
        private U64 rxCrcErr;
        private boolean collisionsSet;
        private U64 collisions;

        BuilderWithParent(OFPortStatsEntryVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFPortStatsEntry.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public U64 getRxPackets() {
            return this.rxPackets;
        }

        @Override
        public OFPortStatsEntry.Builder setRxPackets(U64 rxPackets) {
            this.rxPackets = rxPackets;
            this.rxPacketsSet = true;
            return this;
        }

        @Override
        public U64 getTxPackets() {
            return this.txPackets;
        }

        @Override
        public OFPortStatsEntry.Builder setTxPackets(U64 txPackets) {
            this.txPackets = txPackets;
            this.txPacketsSet = true;
            return this;
        }

        @Override
        public U64 getRxBytes() {
            return this.rxBytes;
        }

        @Override
        public OFPortStatsEntry.Builder setRxBytes(U64 rxBytes) {
            this.rxBytes = rxBytes;
            this.rxBytesSet = true;
            return this;
        }

        @Override
        public U64 getTxBytes() {
            return this.txBytes;
        }

        @Override
        public OFPortStatsEntry.Builder setTxBytes(U64 txBytes) {
            this.txBytes = txBytes;
            this.txBytesSet = true;
            return this;
        }

        @Override
        public U64 getRxDropped() {
            return this.rxDropped;
        }

        @Override
        public OFPortStatsEntry.Builder setRxDropped(U64 rxDropped) {
            this.rxDropped = rxDropped;
            this.rxDroppedSet = true;
            return this;
        }

        @Override
        public U64 getTxDropped() {
            return this.txDropped;
        }

        @Override
        public OFPortStatsEntry.Builder setTxDropped(U64 txDropped) {
            this.txDropped = txDropped;
            this.txDroppedSet = true;
            return this;
        }

        @Override
        public U64 getRxErrors() {
            return this.rxErrors;
        }

        @Override
        public OFPortStatsEntry.Builder setRxErrors(U64 rxErrors) {
            this.rxErrors = rxErrors;
            this.rxErrorsSet = true;
            return this;
        }

        @Override
        public U64 getTxErrors() {
            return this.txErrors;
        }

        @Override
        public OFPortStatsEntry.Builder setTxErrors(U64 txErrors) {
            this.txErrors = txErrors;
            this.txErrorsSet = true;
            return this;
        }

        @Override
        public U64 getRxFrameErr() {
            return this.rxFrameErr;
        }

        @Override
        public OFPortStatsEntry.Builder setRxFrameErr(U64 rxFrameErr) {
            this.rxFrameErr = rxFrameErr;
            this.rxFrameErrSet = true;
            return this;
        }

        @Override
        public U64 getRxOverErr() {
            return this.rxOverErr;
        }

        @Override
        public OFPortStatsEntry.Builder setRxOverErr(U64 rxOverErr) {
            this.rxOverErr = rxOverErr;
            this.rxOverErrSet = true;
            return this;
        }

        @Override
        public U64 getRxCrcErr() {
            return this.rxCrcErr;
        }

        @Override
        public OFPortStatsEntry.Builder setRxCrcErr(U64 rxCrcErr) {
            this.rxCrcErr = rxCrcErr;
            this.rxCrcErrSet = true;
            return this;
        }

        @Override
        public U64 getCollisions() {
            return this.collisions;
        }

        @Override
        public OFPortStatsEntry.Builder setCollisions(U64 collisions) {
            this.collisions = collisions;
            this.collisionsSet = true;
            return this;
        }

        @Override
        public long getDurationSec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.1");
        }

        @Override
        public OFPortStatsEntry.Builder setDurationSec(long durationSec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.1");
        }

        @Override
        public long getDurationNsec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.1");
        }

        @Override
        public OFPortStatsEntry.Builder setDurationNsec(long durationNsec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.1");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFPortStatsEntry build() {
            U64 collisions;
            U64 rxCrcErr;
            U64 rxOverErr;
            U64 rxFrameErr;
            U64 txErrors;
            U64 rxErrors;
            U64 txDropped;
            U64 rxDropped;
            U64 txBytes;
            U64 rxBytes;
            U64 txPackets;
            U64 rxPackets;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            U64 u64 = rxPackets = this.rxPacketsSet ? this.rxPackets : this.parentMessage.rxPackets;
            if (rxPackets == null) {
                throw new NullPointerException("Property rxPackets must not be null");
            }
            U64 u642 = txPackets = this.txPacketsSet ? this.txPackets : this.parentMessage.txPackets;
            if (txPackets == null) {
                throw new NullPointerException("Property txPackets must not be null");
            }
            U64 u643 = rxBytes = this.rxBytesSet ? this.rxBytes : this.parentMessage.rxBytes;
            if (rxBytes == null) {
                throw new NullPointerException("Property rxBytes must not be null");
            }
            U64 u644 = txBytes = this.txBytesSet ? this.txBytes : this.parentMessage.txBytes;
            if (txBytes == null) {
                throw new NullPointerException("Property txBytes must not be null");
            }
            U64 u645 = rxDropped = this.rxDroppedSet ? this.rxDropped : this.parentMessage.rxDropped;
            if (rxDropped == null) {
                throw new NullPointerException("Property rxDropped must not be null");
            }
            U64 u646 = txDropped = this.txDroppedSet ? this.txDropped : this.parentMessage.txDropped;
            if (txDropped == null) {
                throw new NullPointerException("Property txDropped must not be null");
            }
            U64 u647 = rxErrors = this.rxErrorsSet ? this.rxErrors : this.parentMessage.rxErrors;
            if (rxErrors == null) {
                throw new NullPointerException("Property rxErrors must not be null");
            }
            U64 u648 = txErrors = this.txErrorsSet ? this.txErrors : this.parentMessage.txErrors;
            if (txErrors == null) {
                throw new NullPointerException("Property txErrors must not be null");
            }
            U64 u649 = rxFrameErr = this.rxFrameErrSet ? this.rxFrameErr : this.parentMessage.rxFrameErr;
            if (rxFrameErr == null) {
                throw new NullPointerException("Property rxFrameErr must not be null");
            }
            U64 u6410 = rxOverErr = this.rxOverErrSet ? this.rxOverErr : this.parentMessage.rxOverErr;
            if (rxOverErr == null) {
                throw new NullPointerException("Property rxOverErr must not be null");
            }
            U64 u6411 = rxCrcErr = this.rxCrcErrSet ? this.rxCrcErr : this.parentMessage.rxCrcErr;
            if (rxCrcErr == null) {
                throw new NullPointerException("Property rxCrcErr must not be null");
            }
            U64 u6412 = collisions = this.collisionsSet ? this.collisions : this.parentMessage.collisions;
            if (collisions == null) {
                throw new NullPointerException("Property collisions must not be null");
            }
            return new OFPortStatsEntryVer11(portNo, rxPackets, txPackets, rxBytes, txBytes, rxDropped, txDropped, rxErrors, txErrors, rxFrameErr, rxOverErr, rxCrcErr, collisions);
        }
    }
}

