/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFQueueStatsRequest;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver11.OFStatsRequestFlagsSerializerVer11;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFQueueStatsRequestVer11
implements OFQueueStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFQueueStatsRequestVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final long DEFAULT_QUEUE_ID = 0L;
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    private final OFPort portNo;
    private final long queueId;
    static final OFQueueStatsRequestVer11 DEFAULT = new OFQueueStatsRequestVer11(0L, DEFAULT_FLAGS, DEFAULT_PORT_NO, 0L);
    static final Reader READER = new Reader();
    static final OFQueueStatsRequestVer11Funnel FUNNEL = new OFQueueStatsRequestVer11Funnel();
    static final Writer WRITER = new Writer();

    OFQueueStatsRequestVer11(long xid, Set<OFStatsRequestFlags> flags, OFPort portNo, long queueId) {
        this.xid = xid;
        this.flags = flags;
        this.portNo = portNo;
        this.queueId = queueId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.QUEUE;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public long getQueueId() {
        return this.queueId;
    }

    @Override
    public OFQueueStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFQueueStatsRequestVer11(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("queueId=").append(this.queueId);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFQueueStatsRequestVer11 other = (OFQueueStatsRequestVer11)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        return this.queueId == other.queueId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * (int)(this.queueId ^ this.queueId >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFQueueStatsRequestVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFQueueStatsRequestVer11 message) {
            bb.writeByte(2);
            bb.writeByte(18);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(5);
            OFStatsRequestFlagsSerializerVer11.writeTo(bb, message.flags);
            bb.writeZero(4);
            message.portNo.write4Bytes(bb);
            bb.writeInt(U32.t(message.queueId));
        }
    }

    static class OFQueueStatsRequestVer11Funnel
    implements Funnel<OFQueueStatsRequestVer11> {
        private static final long serialVersionUID = 1L;

        OFQueueStatsRequestVer11Funnel() {
        }

        public void funnel(OFQueueStatsRequestVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)18);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putShort((short)5);
            OFStatsRequestFlagsSerializerVer11.putTo(message.flags, sink);
            message.portNo.putTo(sink);
            sink.putLong(message.queueId);
        }
    }

    static class Reader
    implements OFMessageReader<OFQueueStatsRequest> {
        Reader() {
        }

        @Override
        public OFQueueStatsRequest readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 5) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.QUEUE(5), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer11.readFrom(bb);
            bb.skipBytes(4);
            OFPort portNo = OFPort.read4Bytes(bb);
            long queueId = U32.f(bb.readInt());
            OFQueueStatsRequestVer11 queueStatsRequestVer11 = new OFQueueStatsRequestVer11(xid, flags, portNo, queueId);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)queueStatsRequestVer11);
            }
            return queueStatsRequestVer11;
        }
    }

    static class Builder
    implements OFQueueStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean queueIdSet;
        private long queueId;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFQueueStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.QUEUE;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFQueueStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFQueueStatsRequest.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFQueueStatsRequest.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public OFQueueStatsRequest build() {
            OFPort portNo;
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            long queueId = this.queueIdSet ? this.queueId : 0L;
            return new OFQueueStatsRequestVer11(xid, flags, portNo, queueId);
        }
    }

    static class BuilderWithParent
    implements OFQueueStatsRequest.Builder {
        final OFQueueStatsRequestVer11 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean queueIdSet;
        private long queueId;

        BuilderWithParent(OFQueueStatsRequestVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFQueueStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.QUEUE;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFQueueStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFQueueStatsRequest.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFQueueStatsRequest.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public OFQueueStatsRequest build() {
            OFPort portNo;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            long queueId = this.queueIdSet ? this.queueId : this.parentMessage.queueId;
            return new OFQueueStatsRequestVer11(xid, flags, portNo, queueId);
        }
    }
}

