/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMatchBmap;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableStatsEntry;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver11.ChannelUtilsVer11;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableStatsEntryVer11
implements OFTableStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFTableStatsEntryVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 88;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final String DEFAULT_NAME = "";
    private static final int DEFAULT_WILDCARDS = 0;
    private static final long DEFAULT_INSTRUCTIONS = 0L;
    private static final long DEFAULT_WRITE_ACTIONS = 0L;
    private static final long DEFAULT_APPLY_ACTIONS = 0L;
    private static final long DEFAULT_CONFIG = 0L;
    private static final long DEFAULT_MAX_ENTRIES = 0L;
    private static final long DEFAULT_ACTIVE_COUNT = 0L;
    private static final U64 DEFAULT_LOOKUP_COUNT = U64.ZERO;
    private static final U64 DEFAULT_MATCHED_COUNT = U64.ZERO;
    private final TableId tableId;
    private final String name;
    private final int wildcards;
    private final OFMatchBmap match;
    private final long instructions;
    private final long writeActions;
    private final long applyActions;
    private final long config;
    private final long maxEntries;
    private final long activeCount;
    private final U64 lookupCount;
    private final U64 matchedCount;
    static final Reader READER = new Reader();
    static final OFTableStatsEntryVer11Funnel FUNNEL = new OFTableStatsEntryVer11Funnel();
    static final Writer WRITER = new Writer();

    OFTableStatsEntryVer11(TableId tableId, String name, int wildcards, OFMatchBmap match, long instructions, long writeActions, long applyActions, long config, long maxEntries, long activeCount, U64 lookupCount, U64 matchedCount) {
        this.tableId = tableId;
        this.name = name;
        this.wildcards = wildcards;
        this.match = match;
        this.instructions = instructions;
        this.writeActions = writeActions;
        this.applyActions = applyActions;
        this.config = config;
        this.maxEntries = maxEntries;
        this.activeCount = activeCount;
        this.lookupCount = lookupCount;
        this.matchedCount = matchedCount;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OFMatchBmap getMatch() {
        return this.match;
    }

    @Override
    public int getWildcards() {
        return this.wildcards;
    }

    @Override
    public long getWriteActions() {
        return this.writeActions;
    }

    @Override
    public long getApplyActions() {
        return this.applyActions;
    }

    @Override
    public U64 getWriteSetfields() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property writeSetfields not supported in version 1.1");
    }

    @Override
    public U64 getApplySetfields() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property applySetfields not supported in version 1.1");
    }

    @Override
    public U64 getMetadataMatch() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property metadataMatch not supported in version 1.1");
    }

    @Override
    public U64 getMetadataWrite() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property metadataWrite not supported in version 1.1");
    }

    @Override
    public long getInstructions() {
        return this.instructions;
    }

    @Override
    public long getConfig() {
        return this.config;
    }

    @Override
    public long getMaxEntries() {
        return this.maxEntries;
    }

    @Override
    public long getActiveCount() {
        return this.activeCount;
    }

    @Override
    public U64 getLookupCount() {
        return this.lookupCount;
    }

    @Override
    public U64 getMatchedCount() {
        return this.matchedCount;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFTableStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableStatsEntryVer11(");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("name=").append(this.name);
        b.append(", ");
        b.append("wildcards=").append(this.wildcards);
        b.append(", ");
        b.append("match=").append(this.match);
        b.append(", ");
        b.append("instructions=").append(this.instructions);
        b.append(", ");
        b.append("writeActions=").append(this.writeActions);
        b.append(", ");
        b.append("applyActions=").append(this.applyActions);
        b.append(", ");
        b.append("config=").append(this.config);
        b.append(", ");
        b.append("maxEntries=").append(this.maxEntries);
        b.append(", ");
        b.append("activeCount=").append(this.activeCount);
        b.append(", ");
        b.append("lookupCount=").append(this.lookupCount);
        b.append(", ");
        b.append("matchedCount=").append(this.matchedCount);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableStatsEntryVer11 other = (OFTableStatsEntryVer11)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.wildcards != other.wildcards) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        if (this.instructions != other.instructions) {
            return false;
        }
        if (this.writeActions != other.writeActions) {
            return false;
        }
        if (this.applyActions != other.applyActions) {
            return false;
        }
        if (this.config != other.config) {
            return false;
        }
        if (this.maxEntries != other.maxEntries) {
            return false;
        }
        if (this.activeCount != other.activeCount) {
            return false;
        }
        if (this.lookupCount == null ? other.lookupCount != null : !this.lookupCount.equals(other.lookupCount)) {
            return false;
        }
        return !(this.matchedCount == null ? other.matchedCount != null : !this.matchedCount.equals(other.matchedCount));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.wildcards;
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * (int)(this.instructions ^ this.instructions >>> 32);
        result = 31 * (int)(this.writeActions ^ this.writeActions >>> 32);
        result = 31 * (int)(this.applyActions ^ this.applyActions >>> 32);
        result = 31 * (int)(this.config ^ this.config >>> 32);
        result = 31 * (int)(this.maxEntries ^ this.maxEntries >>> 32);
        result = 31 * (int)(this.activeCount ^ this.activeCount >>> 32);
        result = 31 * result + (this.lookupCount == null ? 0 : this.lookupCount.hashCode());
        result = 31 * result + (this.matchedCount == null ? 0 : this.matchedCount.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableStatsEntryVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFTableStatsEntryVer11 message) {
            message.tableId.writeByte(bb);
            bb.writeZero(7);
            ChannelUtils.writeFixedLengthString(bb, message.name, 32);
            bb.writeInt(message.wildcards);
            ChannelUtilsVer11.writeOFMatchBmap(bb, message.match);
            bb.writeInt(U32.t(message.instructions));
            bb.writeInt(U32.t(message.writeActions));
            bb.writeInt(U32.t(message.applyActions));
            bb.writeInt(U32.t(message.config));
            bb.writeInt(U32.t(message.maxEntries));
            bb.writeInt(U32.t(message.activeCount));
            bb.writeLong(message.lookupCount.getValue());
            bb.writeLong(message.matchedCount.getValue());
        }
    }

    static class OFTableStatsEntryVer11Funnel
    implements Funnel<OFTableStatsEntryVer11> {
        private static final long serialVersionUID = 1L;

        OFTableStatsEntryVer11Funnel() {
        }

        public void funnel(OFTableStatsEntryVer11 message, PrimitiveSink sink) {
            message.tableId.putTo(sink);
            sink.putUnencodedChars((CharSequence)message.name);
            sink.putInt(message.wildcards);
            message.match.putTo(sink);
            sink.putLong(message.instructions);
            sink.putLong(message.writeActions);
            sink.putLong(message.applyActions);
            sink.putLong(message.config);
            sink.putLong(message.maxEntries);
            sink.putLong(message.activeCount);
            message.lookupCount.putTo(sink);
            message.matchedCount.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableStatsEntry> {
        Reader() {
        }

        @Override
        public OFTableStatsEntry readFrom(ChannelBuffer bb) throws OFParseError {
            TableId tableId = TableId.readByte(bb);
            bb.skipBytes(7);
            String name = ChannelUtils.readFixedLengthString(bb, 32);
            int wildcards = bb.readInt();
            OFMatchBmap match = ChannelUtilsVer11.readOFMatchBmap(bb);
            long instructions = U32.f(bb.readInt());
            long writeActions = U32.f(bb.readInt());
            long applyActions = U32.f(bb.readInt());
            long config = U32.f(bb.readInt());
            long maxEntries = U32.f(bb.readInt());
            long activeCount = U32.f(bb.readInt());
            U64 lookupCount = U64.ofRaw(bb.readLong());
            U64 matchedCount = U64.ofRaw(bb.readLong());
            OFTableStatsEntryVer11 tableStatsEntryVer11 = new OFTableStatsEntryVer11(tableId, name, wildcards, match, instructions, writeActions, applyActions, config, maxEntries, activeCount, lookupCount, matchedCount);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableStatsEntryVer11);
            }
            return tableStatsEntryVer11;
        }
    }

    static class Builder
    implements OFTableStatsEntry.Builder {
        private boolean tableIdSet;
        private TableId tableId;
        private boolean nameSet;
        private String name;
        private boolean wildcardsSet;
        private int wildcards;
        private boolean matchSet;
        private OFMatchBmap match;
        private boolean instructionsSet;
        private long instructions;
        private boolean writeActionsSet;
        private long writeActions;
        private boolean applyActionsSet;
        private long applyActions;
        private boolean configSet;
        private long config;
        private boolean maxEntriesSet;
        private long maxEntries;
        private boolean activeCountSet;
        private long activeCount;
        private boolean lookupCountSet;
        private U64 lookupCount;
        private boolean matchedCountSet;
        private U64 matchedCount;

        Builder() {
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFTableStatsEntry.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFTableStatsEntry.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public OFMatchBmap getMatch() {
            return this.match;
        }

        @Override
        public OFTableStatsEntry.Builder setMatch(OFMatchBmap match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public int getWildcards() {
            return this.wildcards;
        }

        @Override
        public OFTableStatsEntry.Builder setWildcards(int wildcards) {
            this.wildcards = wildcards;
            this.wildcardsSet = true;
            return this;
        }

        @Override
        public long getWriteActions() {
            return this.writeActions;
        }

        @Override
        public OFTableStatsEntry.Builder setWriteActions(long writeActions) {
            this.writeActions = writeActions;
            this.writeActionsSet = true;
            return this;
        }

        @Override
        public long getApplyActions() {
            return this.applyActions;
        }

        @Override
        public OFTableStatsEntry.Builder setApplyActions(long applyActions) {
            this.applyActions = applyActions;
            this.applyActionsSet = true;
            return this;
        }

        @Override
        public U64 getWriteSetfields() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property writeSetfields not supported in version 1.1");
        }

        @Override
        public OFTableStatsEntry.Builder setWriteSetfields(U64 writeSetfields) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property writeSetfields not supported in version 1.1");
        }

        @Override
        public U64 getApplySetfields() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property applySetfields not supported in version 1.1");
        }

        @Override
        public OFTableStatsEntry.Builder setApplySetfields(U64 applySetfields) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property applySetfields not supported in version 1.1");
        }

        @Override
        public U64 getMetadataMatch() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property metadataMatch not supported in version 1.1");
        }

        @Override
        public OFTableStatsEntry.Builder setMetadataMatch(U64 metadataMatch) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property metadataMatch not supported in version 1.1");
        }

        @Override
        public U64 getMetadataWrite() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property metadataWrite not supported in version 1.1");
        }

        @Override
        public OFTableStatsEntry.Builder setMetadataWrite(U64 metadataWrite) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property metadataWrite not supported in version 1.1");
        }

        @Override
        public long getInstructions() {
            return this.instructions;
        }

        @Override
        public OFTableStatsEntry.Builder setInstructions(long instructions) {
            this.instructions = instructions;
            this.instructionsSet = true;
            return this;
        }

        @Override
        public long getConfig() {
            return this.config;
        }

        @Override
        public OFTableStatsEntry.Builder setConfig(long config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public long getMaxEntries() {
            return this.maxEntries;
        }

        @Override
        public OFTableStatsEntry.Builder setMaxEntries(long maxEntries) {
            this.maxEntries = maxEntries;
            this.maxEntriesSet = true;
            return this;
        }

        @Override
        public long getActiveCount() {
            return this.activeCount;
        }

        @Override
        public OFTableStatsEntry.Builder setActiveCount(long activeCount) {
            this.activeCount = activeCount;
            this.activeCountSet = true;
            return this;
        }

        @Override
        public U64 getLookupCount() {
            return this.lookupCount;
        }

        @Override
        public OFTableStatsEntry.Builder setLookupCount(U64 lookupCount) {
            this.lookupCount = lookupCount;
            this.lookupCountSet = true;
            return this;
        }

        @Override
        public U64 getMatchedCount() {
            return this.matchedCount;
        }

        @Override
        public OFTableStatsEntry.Builder setMatchedCount(U64 matchedCount) {
            this.matchedCount = matchedCount;
            this.matchedCountSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFTableStatsEntry build() {
            U64 matchedCount;
            U64 lookupCount;
            int wildcards;
            String name;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            String string = name = this.nameSet ? this.name : OFTableStatsEntryVer11.DEFAULT_NAME;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            int n = wildcards = this.wildcardsSet ? this.wildcards : 0;
            if (!this.matchSet) {
                throw new IllegalStateException("Property match doesn't have default value -- must be set");
            }
            if (this.match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            long instructions = this.instructionsSet ? this.instructions : 0L;
            long writeActions = this.writeActionsSet ? this.writeActions : 0L;
            long applyActions = this.applyActionsSet ? this.applyActions : 0L;
            long config = this.configSet ? this.config : 0L;
            long maxEntries = this.maxEntriesSet ? this.maxEntries : 0L;
            long activeCount = this.activeCountSet ? this.activeCount : 0L;
            U64 u64 = lookupCount = this.lookupCountSet ? this.lookupCount : DEFAULT_LOOKUP_COUNT;
            if (lookupCount == null) {
                throw new NullPointerException("Property lookupCount must not be null");
            }
            U64 u642 = matchedCount = this.matchedCountSet ? this.matchedCount : DEFAULT_MATCHED_COUNT;
            if (matchedCount == null) {
                throw new NullPointerException("Property matchedCount must not be null");
            }
            return new OFTableStatsEntryVer11(tableId, name, wildcards, this.match, instructions, writeActions, applyActions, config, maxEntries, activeCount, lookupCount, matchedCount);
        }
    }

    static class BuilderWithParent
    implements OFTableStatsEntry.Builder {
        final OFTableStatsEntryVer11 parentMessage;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean nameSet;
        private String name;
        private boolean wildcardsSet;
        private int wildcards;
        private boolean matchSet;
        private OFMatchBmap match;
        private boolean instructionsSet;
        private long instructions;
        private boolean writeActionsSet;
        private long writeActions;
        private boolean applyActionsSet;
        private long applyActions;
        private boolean configSet;
        private long config;
        private boolean maxEntriesSet;
        private long maxEntries;
        private boolean activeCountSet;
        private long activeCount;
        private boolean lookupCountSet;
        private U64 lookupCount;
        private boolean matchedCountSet;
        private U64 matchedCount;

        BuilderWithParent(OFTableStatsEntryVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFTableStatsEntry.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFTableStatsEntry.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public OFMatchBmap getMatch() {
            return this.match;
        }

        @Override
        public OFTableStatsEntry.Builder setMatch(OFMatchBmap match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public int getWildcards() {
            return this.wildcards;
        }

        @Override
        public OFTableStatsEntry.Builder setWildcards(int wildcards) {
            this.wildcards = wildcards;
            this.wildcardsSet = true;
            return this;
        }

        @Override
        public long getWriteActions() {
            return this.writeActions;
        }

        @Override
        public OFTableStatsEntry.Builder setWriteActions(long writeActions) {
            this.writeActions = writeActions;
            this.writeActionsSet = true;
            return this;
        }

        @Override
        public long getApplyActions() {
            return this.applyActions;
        }

        @Override
        public OFTableStatsEntry.Builder setApplyActions(long applyActions) {
            this.applyActions = applyActions;
            this.applyActionsSet = true;
            return this;
        }

        @Override
        public U64 getWriteSetfields() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property writeSetfields not supported in version 1.1");
        }

        @Override
        public OFTableStatsEntry.Builder setWriteSetfields(U64 writeSetfields) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property writeSetfields not supported in version 1.1");
        }

        @Override
        public U64 getApplySetfields() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property applySetfields not supported in version 1.1");
        }

        @Override
        public OFTableStatsEntry.Builder setApplySetfields(U64 applySetfields) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property applySetfields not supported in version 1.1");
        }

        @Override
        public U64 getMetadataMatch() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property metadataMatch not supported in version 1.1");
        }

        @Override
        public OFTableStatsEntry.Builder setMetadataMatch(U64 metadataMatch) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property metadataMatch not supported in version 1.1");
        }

        @Override
        public U64 getMetadataWrite() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property metadataWrite not supported in version 1.1");
        }

        @Override
        public OFTableStatsEntry.Builder setMetadataWrite(U64 metadataWrite) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property metadataWrite not supported in version 1.1");
        }

        @Override
        public long getInstructions() {
            return this.instructions;
        }

        @Override
        public OFTableStatsEntry.Builder setInstructions(long instructions) {
            this.instructions = instructions;
            this.instructionsSet = true;
            return this;
        }

        @Override
        public long getConfig() {
            return this.config;
        }

        @Override
        public OFTableStatsEntry.Builder setConfig(long config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public long getMaxEntries() {
            return this.maxEntries;
        }

        @Override
        public OFTableStatsEntry.Builder setMaxEntries(long maxEntries) {
            this.maxEntries = maxEntries;
            this.maxEntriesSet = true;
            return this;
        }

        @Override
        public long getActiveCount() {
            return this.activeCount;
        }

        @Override
        public OFTableStatsEntry.Builder setActiveCount(long activeCount) {
            this.activeCount = activeCount;
            this.activeCountSet = true;
            return this;
        }

        @Override
        public U64 getLookupCount() {
            return this.lookupCount;
        }

        @Override
        public OFTableStatsEntry.Builder setLookupCount(U64 lookupCount) {
            this.lookupCount = lookupCount;
            this.lookupCountSet = true;
            return this;
        }

        @Override
        public U64 getMatchedCount() {
            return this.matchedCount;
        }

        @Override
        public OFTableStatsEntry.Builder setMatchedCount(U64 matchedCount) {
            this.matchedCount = matchedCount;
            this.matchedCountSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFTableStatsEntry build() {
            U64 matchedCount;
            U64 lookupCount;
            OFMatchBmap match;
            String name;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            String string = name = this.nameSet ? this.name : this.parentMessage.name;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            int wildcards = this.wildcardsSet ? this.wildcards : this.parentMessage.wildcards;
            OFMatchBmap oFMatchBmap = match = this.matchSet ? this.match : this.parentMessage.match;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            long instructions = this.instructionsSet ? this.instructions : this.parentMessage.instructions;
            long writeActions = this.writeActionsSet ? this.writeActions : this.parentMessage.writeActions;
            long applyActions = this.applyActionsSet ? this.applyActions : this.parentMessage.applyActions;
            long config = this.configSet ? this.config : this.parentMessage.config;
            long maxEntries = this.maxEntriesSet ? this.maxEntries : this.parentMessage.maxEntries;
            long activeCount = this.activeCountSet ? this.activeCount : this.parentMessage.activeCount;
            U64 u64 = lookupCount = this.lookupCountSet ? this.lookupCount : this.parentMessage.lookupCount;
            if (lookupCount == null) {
                throw new NullPointerException("Property lookupCount must not be null");
            }
            U64 u642 = matchedCount = this.matchedCountSet ? this.matchedCount : this.parentMessage.matchedCount;
            if (matchedCount == null) {
                throw new NullPointerException("Property matchedCount must not be null");
            }
            return new OFTableStatsEntryVer11(tableId, name, wildcards, match, instructions, writeActions, applyActions, config, maxEntries, activeCount, lookupCount, matchedCount);
        }
    }
}

