/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionDecMplsTtl;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionDecMplsTtlVer12
implements OFActionDecMplsTtl {
    private static final Logger logger = LoggerFactory.getLogger(OFActionDecMplsTtlVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 8;
    static final OFActionDecMplsTtlVer12 DEFAULT = new OFActionDecMplsTtlVer12();
    static final OFActionDecMplsTtlVer12 INSTANCE = new OFActionDecMplsTtlVer12();
    static final Reader READER = new Reader();
    static final OFActionDecMplsTtlVer12Funnel FUNNEL = new OFActionDecMplsTtlVer12Funnel();
    static final Writer WRITER = new Writer();

    private OFActionDecMplsTtlVer12() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.DEC_MPLS_TTL;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFActionDecMplsTtl.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionDecMplsTtlVer12 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionDecMplsTtlVer12(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionDecMplsTtlVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionDecMplsTtlVer12 message) {
            bb.writeShort(16);
            bb.writeShort(8);
            bb.writeZero(4);
        }
    }

    static class OFActionDecMplsTtlVer12Funnel
    implements Funnel<OFActionDecMplsTtlVer12> {
        private static final long serialVersionUID = 1L;

        OFActionDecMplsTtlVer12Funnel() {
        }

        public void funnel(OFActionDecMplsTtlVer12 message, PrimitiveSink sink) {
            sink.putShort((short)16);
            sink.putShort((short)8);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionDecMplsTtl> {
        Reader() {
        }

        @Override
        public OFActionDecMplsTtl readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 16) {
                throw new OFParseError("Wrong type: Expected=OFActionType.DEC_MPLS_TTL(16), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

