/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.ver12.OFOxmVer12;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetFieldVer12
implements OFActionSetField {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetFieldVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int MINIMUM_LENGTH = 8;
    private final OFOxm<?> field;
    static final Reader READER = new Reader();
    static final OFActionSetFieldVer12Funnel FUNNEL = new OFActionSetFieldVer12Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetFieldVer12(OFOxm<?> field) {
        this.field = field;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_FIELD;
    }

    @Override
    public OFOxm<?> getField() {
        return this.field;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFActionSetField.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetFieldVer12(");
        b.append("field=").append(this.field);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetFieldVer12 other = (OFActionSetFieldVer12)obj;
        return !(this.field == null ? other.field != null : !this.field.equals(other.field));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetFieldVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionSetFieldVer12 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(25);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            message.field.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            int alignedLength = (length + 7) / 8 * 8;
            bb.setShort(lengthIndex, alignedLength);
            bb.writeZero(alignedLength - length);
        }
    }

    static class OFActionSetFieldVer12Funnel
    implements Funnel<OFActionSetFieldVer12> {
        private static final long serialVersionUID = 1L;

        OFActionSetFieldVer12Funnel() {
        }

        public void funnel(OFActionSetFieldVer12 message, PrimitiveSink sink) {
            sink.putShort((short)25);
            message.field.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetField> {
        Reader() {
        }

        @Override
        public OFActionSetField readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 25) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_FIELD(25), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            Object field = OFOxmVer12.READER.readFrom(bb);
            bb.skipBytes(length - (bb.readerIndex() - start));
            OFActionSetFieldVer12 actionSetFieldVer12 = new OFActionSetFieldVer12((OFOxm<?>)field);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetFieldVer12);
            }
            return actionSetFieldVer12;
        }
    }

    static class Builder
    implements OFActionSetField.Builder {
        private boolean fieldSet;
        private OFOxm<?> field;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_FIELD;
        }

        @Override
        public OFOxm<?> getField() {
            return this.field;
        }

        @Override
        public OFActionSetField.Builder setField(OFOxm<?> field) {
            this.field = field;
            this.fieldSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFActionSetField build() {
            if (!this.fieldSet) {
                throw new IllegalStateException("Property field doesn't have default value -- must be set");
            }
            if (this.field == null) {
                throw new NullPointerException("Property field must not be null");
            }
            return new OFActionSetFieldVer12(this.field);
        }
    }

    static class BuilderWithParent
    implements OFActionSetField.Builder {
        final OFActionSetFieldVer12 parentMessage;
        private boolean fieldSet;
        private OFOxm<?> field;

        BuilderWithParent(OFActionSetFieldVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_FIELD;
        }

        @Override
        public OFOxm<?> getField() {
            return this.field;
        }

        @Override
        public OFActionSetField.Builder setField(OFOxm<?> field) {
            this.field = field;
            this.fieldSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFActionSetField build() {
            OFOxm field;
            OFOxm oFOxm = field = this.fieldSet ? this.field : this.parentMessage.field;
            if (field == null) {
                throw new NullPointerException("Property field must not be null");
            }
            return new OFActionSetFieldVer12(field);
        }
    }
}

