/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFErrorType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.errormsg.OFExperimenterErrorMsg;
import org.projectfloodlight.openflow.types.OFErrorCauseData;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFExperimenterErrorMsgVer12
implements OFExperimenterErrorMsg {
    private static final Logger logger = LoggerFactory.getLogger(OFExperimenterErrorMsgVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int MINIMUM_LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private static final int DEFAULT_SUBTYPE = 0;
    private static final long DEFAULT_EXPERIMENTER = 0L;
    private static final OFErrorCauseData DEFAULT_DATA = OFErrorCauseData.NONE;
    private final long xid;
    private final int subtype;
    private final long experimenter;
    private final OFErrorCauseData data;
    static final OFExperimenterErrorMsgVer12 DEFAULT = new OFExperimenterErrorMsgVer12(0L, 0, 0L, DEFAULT_DATA);
    static final Reader READER = new Reader();
    static final OFExperimenterErrorMsgVer12Funnel FUNNEL = new OFExperimenterErrorMsgVer12Funnel();
    static final Writer WRITER = new Writer();

    OFExperimenterErrorMsgVer12(long xid, int subtype, long experimenter, OFErrorCauseData data) {
        this.xid = xid;
        this.subtype = subtype;
        this.experimenter = experimenter;
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFType getType() {
        return OFType.ERROR;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFErrorType getErrType() {
        return OFErrorType.EXPERIMENTER;
    }

    @Override
    public int getSubtype() {
        return this.subtype;
    }

    @Override
    public long getExperimenter() {
        return this.experimenter;
    }

    @Override
    public OFErrorCauseData getData() {
        return this.data;
    }

    @Override
    public OFExperimenterErrorMsg.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFExperimenterErrorMsgVer12(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("subtype=").append(this.subtype);
        b.append(", ");
        b.append("experimenter=").append(this.experimenter);
        b.append(", ");
        b.append("data=").append(this.data);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFExperimenterErrorMsgVer12 other = (OFExperimenterErrorMsgVer12)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.subtype != other.subtype) {
            return false;
        }
        if (this.experimenter != other.experimenter) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + this.subtype;
        result = 31 * (int)(this.experimenter ^ this.experimenter >>> 32);
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFExperimenterErrorMsgVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFExperimenterErrorMsgVer12 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(3);
            bb.writeByte(1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(-1);
            bb.writeShort((int)U16.t(message.subtype));
            bb.writeInt(U32.t(message.experimenter));
            message.data.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFExperimenterErrorMsgVer12Funnel
    implements Funnel<OFExperimenterErrorMsgVer12> {
        private static final long serialVersionUID = 1L;

        OFExperimenterErrorMsgVer12Funnel() {
        }

        public void funnel(OFExperimenterErrorMsgVer12 message, PrimitiveSink sink) {
            sink.putByte((byte)3);
            sink.putByte((byte)1);
            sink.putLong(message.xid);
            sink.putShort((short)-1);
            sink.putInt(message.subtype);
            sink.putLong(message.experimenter);
            message.data.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFExperimenterErrorMsg> {
        Reader() {
        }

        @Override
        public OFExperimenterErrorMsg readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=OFType.ERROR(1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short errType = bb.readShort();
            if (errType != -1) {
                throw new OFParseError("Wrong errType: Expected=OFErrorType.EXPERIMENTER(65535), got=" + errType);
            }
            int subtype = U16.f(bb.readShort());
            long experimenter = U32.f(bb.readInt());
            OFErrorCauseData data = OFErrorCauseData.read(bb, length - (bb.readerIndex() - start), OFVersion.OF_12);
            OFExperimenterErrorMsgVer12 experimenterErrorMsgVer12 = new OFExperimenterErrorMsgVer12(xid, subtype, experimenter, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)experimenterErrorMsgVer12);
            }
            return experimenterErrorMsgVer12;
        }
    }

    static class Builder
    implements OFExperimenterErrorMsg.Builder {
        private boolean xidSet;
        private long xid;
        private boolean subtypeSet;
        private int subtype;
        private boolean experimenterSet;
        private long experimenter;
        private boolean dataSet;
        private OFErrorCauseData data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.ERROR;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFExperimenterErrorMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFErrorType getErrType() {
            return OFErrorType.EXPERIMENTER;
        }

        @Override
        public int getSubtype() {
            return this.subtype;
        }

        @Override
        public OFExperimenterErrorMsg.Builder setSubtype(int subtype) {
            this.subtype = subtype;
            this.subtypeSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return this.experimenter;
        }

        @Override
        public OFExperimenterErrorMsg.Builder setExperimenter(long experimenter) {
            this.experimenter = experimenter;
            this.experimenterSet = true;
            return this;
        }

        @Override
        public OFErrorCauseData getData() {
            return this.data;
        }

        @Override
        public OFExperimenterErrorMsg.Builder setData(OFErrorCauseData data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFExperimenterErrorMsg build() {
            OFErrorCauseData data;
            long xid = this.xidSet ? this.xid : 0L;
            int subtype = this.subtypeSet ? this.subtype : 0;
            long experimenter = this.experimenterSet ? this.experimenter : 0L;
            OFErrorCauseData oFErrorCauseData = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFExperimenterErrorMsgVer12(xid, subtype, experimenter, data);
        }
    }

    static class BuilderWithParent
    implements OFExperimenterErrorMsg.Builder {
        final OFExperimenterErrorMsgVer12 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean subtypeSet;
        private int subtype;
        private boolean experimenterSet;
        private long experimenter;
        private boolean dataSet;
        private OFErrorCauseData data;

        BuilderWithParent(OFExperimenterErrorMsgVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.ERROR;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFExperimenterErrorMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFErrorType getErrType() {
            return OFErrorType.EXPERIMENTER;
        }

        @Override
        public int getSubtype() {
            return this.subtype;
        }

        @Override
        public OFExperimenterErrorMsg.Builder setSubtype(int subtype) {
            this.subtype = subtype;
            this.subtypeSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return this.experimenter;
        }

        @Override
        public OFExperimenterErrorMsg.Builder setExperimenter(long experimenter) {
            this.experimenter = experimenter;
            this.experimenterSet = true;
            return this;
        }

        @Override
        public OFErrorCauseData getData() {
            return this.data;
        }

        @Override
        public OFExperimenterErrorMsg.Builder setData(OFErrorCauseData data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFExperimenterErrorMsg build() {
            OFErrorCauseData data;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            int subtype = this.subtypeSet ? this.subtype : this.parentMessage.subtype;
            long experimenter = this.experimenterSet ? this.experimenter : this.parentMessage.experimenter;
            OFErrorCauseData oFErrorCauseData = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFExperimenterErrorMsgVer12(xid, subtype, experimenter, data);
        }
    }
}

