/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFlowModFlags;
import org.projectfloodlight.openflow.protocol.OFFlowStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.projectfloodlight.openflow.protocol.instruction.OFInstruction;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.ver12.ChannelUtilsVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFFactoryVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFInstructionVer12;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFFlowStatsEntryVer12
implements OFFlowStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFFlowStatsEntryVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int MINIMUM_LENGTH = 56;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final long DEFAULT_DURATION_SEC = 0L;
    private static final long DEFAULT_DURATION_NSEC = 0L;
    private static final int DEFAULT_PRIORITY = 0;
    private static final int DEFAULT_IDLE_TIMEOUT = 0;
    private static final int DEFAULT_HARD_TIMEOUT = 0;
    private static final U64 DEFAULT_COOKIE = U64.ZERO;
    private static final U64 DEFAULT_PACKET_COUNT = U64.ZERO;
    private static final U64 DEFAULT_BYTE_COUNT = U64.ZERO;
    private static final Match DEFAULT_MATCH = OFFactoryVer12.MATCH_WILDCARD_ALL;
    private static final List<OFInstruction> DEFAULT_INSTRUCTIONS = ImmutableList.of();
    private final TableId tableId;
    private final long durationSec;
    private final long durationNsec;
    private final int priority;
    private final int idleTimeout;
    private final int hardTimeout;
    private final U64 cookie;
    private final U64 packetCount;
    private final U64 byteCount;
    private final Match match;
    private final List<OFInstruction> instructions;
    static final OFFlowStatsEntryVer12 DEFAULT = new OFFlowStatsEntryVer12(DEFAULT_TABLE_ID, 0L, 0L, 0, 0, 0, DEFAULT_COOKIE, DEFAULT_PACKET_COUNT, DEFAULT_BYTE_COUNT, DEFAULT_MATCH, DEFAULT_INSTRUCTIONS);
    static final Reader READER = new Reader();
    static final OFFlowStatsEntryVer12Funnel FUNNEL = new OFFlowStatsEntryVer12Funnel();
    static final Writer WRITER = new Writer();

    OFFlowStatsEntryVer12(TableId tableId, long durationSec, long durationNsec, int priority, int idleTimeout, int hardTimeout, U64 cookie, U64 packetCount, U64 byteCount, Match match, List<OFInstruction> instructions) {
        this.tableId = tableId;
        this.durationSec = durationSec;
        this.durationNsec = durationNsec;
        this.priority = priority;
        this.idleTimeout = idleTimeout;
        this.hardTimeout = hardTimeout;
        this.cookie = cookie;
        this.packetCount = packetCount;
        this.byteCount = byteCount;
        this.match = match;
        this.instructions = instructions;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public long getDurationSec() {
        return this.durationSec;
    }

    @Override
    public long getDurationNsec() {
        return this.durationNsec;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public int getHardTimeout() {
        return this.hardTimeout;
    }

    @Override
    public U64 getCookie() {
        return this.cookie;
    }

    @Override
    public U64 getPacketCount() {
        return this.packetCount;
    }

    @Override
    public U64 getByteCount() {
        return this.byteCount;
    }

    @Override
    public Match getMatch() {
        return this.match;
    }

    @Override
    public List<OFInstruction> getInstructions() {
        return this.instructions;
    }

    @Override
    public List<OFAction> getActions() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property actions not supported in version 1.2");
    }

    @Override
    public Set<OFFlowModFlags> getFlags() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property flags not supported in version 1.2");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFFlowStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFFlowStatsEntryVer12(");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("durationSec=").append(this.durationSec);
        b.append(", ");
        b.append("durationNsec=").append(this.durationNsec);
        b.append(", ");
        b.append("priority=").append(this.priority);
        b.append(", ");
        b.append("idleTimeout=").append(this.idleTimeout);
        b.append(", ");
        b.append("hardTimeout=").append(this.hardTimeout);
        b.append(", ");
        b.append("cookie=").append(this.cookie);
        b.append(", ");
        b.append("packetCount=").append(this.packetCount);
        b.append(", ");
        b.append("byteCount=").append(this.byteCount);
        b.append(", ");
        b.append("match=").append(this.match);
        b.append(", ");
        b.append("instructions=").append(this.instructions);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFlowStatsEntryVer12 other = (OFFlowStatsEntryVer12)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.durationSec != other.durationSec) {
            return false;
        }
        if (this.durationNsec != other.durationNsec) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.idleTimeout != other.idleTimeout) {
            return false;
        }
        if (this.hardTimeout != other.hardTimeout) {
            return false;
        }
        if (this.cookie == null ? other.cookie != null : !this.cookie.equals(other.cookie)) {
            return false;
        }
        if (this.packetCount == null ? other.packetCount != null : !this.packetCount.equals(other.packetCount)) {
            return false;
        }
        if (this.byteCount == null ? other.byteCount != null : !this.byteCount.equals(other.byteCount)) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        return !(this.instructions == null ? other.instructions != null : !this.instructions.equals(other.instructions));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * (int)(this.durationSec ^ this.durationSec >>> 32);
        result = 31 * (int)(this.durationNsec ^ this.durationNsec >>> 32);
        result = 31 * result + this.priority;
        result = 31 * result + this.idleTimeout;
        result = 31 * result + this.hardTimeout;
        result = 31 * result + (this.cookie == null ? 0 : this.cookie.hashCode());
        result = 31 * result + (this.packetCount == null ? 0 : this.packetCount.hashCode());
        result = 31 * result + (this.byteCount == null ? 0 : this.byteCount.hashCode());
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * result + (this.instructions == null ? 0 : this.instructions.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFFlowStatsEntryVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFFlowStatsEntryVer12 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            message.tableId.writeByte(bb);
            bb.writeZero(1);
            bb.writeInt(U32.t(message.durationSec));
            bb.writeInt(U32.t(message.durationNsec));
            bb.writeShort((int)U16.t(message.priority));
            bb.writeShort((int)U16.t(message.idleTimeout));
            bb.writeShort((int)U16.t(message.hardTimeout));
            bb.writeZero(6);
            bb.writeLong(message.cookie.getValue());
            bb.writeLong(message.packetCount.getValue());
            bb.writeLong(message.byteCount.getValue());
            message.match.writeTo(bb);
            ChannelUtils.writeList(bb, message.instructions);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFFlowStatsEntryVer12Funnel
    implements Funnel<OFFlowStatsEntryVer12> {
        private static final long serialVersionUID = 1L;

        OFFlowStatsEntryVer12Funnel() {
        }

        public void funnel(OFFlowStatsEntryVer12 message, PrimitiveSink sink) {
            message.tableId.putTo(sink);
            sink.putLong(message.durationSec);
            sink.putLong(message.durationNsec);
            sink.putInt(message.priority);
            sink.putInt(message.idleTimeout);
            sink.putInt(message.hardTimeout);
            message.cookie.putTo(sink);
            message.packetCount.putTo(sink);
            message.byteCount.putTo(sink);
            message.match.putTo(sink);
            FunnelUtils.putList(message.instructions, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFFlowStatsEntry> {
        Reader() {
        }

        @Override
        public OFFlowStatsEntry readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 56) {
                throw new OFParseError("Wrong length: Expected to be >= 56, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            TableId tableId = TableId.readByte(bb);
            bb.skipBytes(1);
            long durationSec = U32.f(bb.readInt());
            long durationNsec = U32.f(bb.readInt());
            int priority = U16.f(bb.readShort());
            int idleTimeout = U16.f(bb.readShort());
            int hardTimeout = U16.f(bb.readShort());
            bb.skipBytes(6);
            U64 cookie = U64.ofRaw(bb.readLong());
            U64 packetCount = U64.ofRaw(bb.readLong());
            U64 byteCount = U64.ofRaw(bb.readLong());
            Match match = ChannelUtilsVer12.readOFMatch(bb);
            List<OFInstruction> instructions = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFInstructionVer12.READER);
            OFFlowStatsEntryVer12 flowStatsEntryVer12 = new OFFlowStatsEntryVer12(tableId, durationSec, durationNsec, priority, idleTimeout, hardTimeout, cookie, packetCount, byteCount, match, instructions);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)flowStatsEntryVer12);
            }
            return flowStatsEntryVer12;
        }
    }

    static class Builder
    implements OFFlowStatsEntry.Builder {
        private boolean tableIdSet;
        private TableId tableId;
        private boolean durationSecSet;
        private long durationSec;
        private boolean durationNsecSet;
        private long durationNsec;
        private boolean prioritySet;
        private int priority;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean cookieSet;
        private U64 cookie;
        private boolean packetCountSet;
        private U64 packetCount;
        private boolean byteCountSet;
        private U64 byteCount;
        private boolean matchSet;
        private Match match;
        private boolean instructionsSet;
        private List<OFInstruction> instructions;

        Builder() {
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFFlowStatsEntry.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getDurationSec() {
            return this.durationSec;
        }

        @Override
        public OFFlowStatsEntry.Builder setDurationSec(long durationSec) {
            this.durationSec = durationSec;
            this.durationSecSet = true;
            return this;
        }

        @Override
        public long getDurationNsec() {
            return this.durationNsec;
        }

        @Override
        public OFFlowStatsEntry.Builder setDurationNsec(long durationNsec) {
            this.durationNsec = durationNsec;
            this.durationNsecSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFFlowStatsEntry.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public int getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public OFFlowStatsEntry.Builder setIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.idleTimeoutSet = true;
            return this;
        }

        @Override
        public int getHardTimeout() {
            return this.hardTimeout;
        }

        @Override
        public OFFlowStatsEntry.Builder setHardTimeout(int hardTimeout) {
            this.hardTimeout = hardTimeout;
            this.hardTimeoutSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFFlowStatsEntry.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public U64 getPacketCount() {
            return this.packetCount;
        }

        @Override
        public OFFlowStatsEntry.Builder setPacketCount(U64 packetCount) {
            this.packetCount = packetCount;
            this.packetCountSet = true;
            return this;
        }

        @Override
        public U64 getByteCount() {
            return this.byteCount;
        }

        @Override
        public OFFlowStatsEntry.Builder setByteCount(U64 byteCount) {
            this.byteCount = byteCount;
            this.byteCountSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFFlowStatsEntry.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public List<OFInstruction> getInstructions() {
            return this.instructions;
        }

        @Override
        public OFFlowStatsEntry.Builder setInstructions(List<OFInstruction> instructions) {
            this.instructions = instructions;
            this.instructionsSet = true;
            return this;
        }

        @Override
        public List<OFAction> getActions() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property actions not supported in version 1.2");
        }

        @Override
        public OFFlowStatsEntry.Builder setActions(List<OFAction> actions) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property actions not supported in version 1.2");
        }

        @Override
        public Set<OFFlowModFlags> getFlags() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flags not supported in version 1.2");
        }

        @Override
        public OFFlowStatsEntry.Builder setFlags(Set<OFFlowModFlags> flags) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flags not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFFlowStatsEntry build() {
            List<OFInstruction> instructions;
            Match match;
            U64 byteCount;
            U64 packetCount;
            U64 cookie;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            long durationSec = this.durationSecSet ? this.durationSec : 0L;
            long durationNsec = this.durationNsecSet ? this.durationNsec : 0L;
            int priority = this.prioritySet ? this.priority : 0;
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : 0;
            int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : 0;
            U64 u64 = cookie = this.cookieSet ? this.cookie : DEFAULT_COOKIE;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            U64 u642 = packetCount = this.packetCountSet ? this.packetCount : DEFAULT_PACKET_COUNT;
            if (packetCount == null) {
                throw new NullPointerException("Property packetCount must not be null");
            }
            U64 u643 = byteCount = this.byteCountSet ? this.byteCount : DEFAULT_BYTE_COUNT;
            if (byteCount == null) {
                throw new NullPointerException("Property byteCount must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : DEFAULT_MATCH;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            List<OFInstruction> list = instructions = this.instructionsSet ? this.instructions : DEFAULT_INSTRUCTIONS;
            if (instructions == null) {
                throw new NullPointerException("Property instructions must not be null");
            }
            return new OFFlowStatsEntryVer12(tableId, durationSec, durationNsec, priority, idleTimeout, hardTimeout, cookie, packetCount, byteCount, match, instructions);
        }
    }

    static class BuilderWithParent
    implements OFFlowStatsEntry.Builder {
        final OFFlowStatsEntryVer12 parentMessage;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean durationSecSet;
        private long durationSec;
        private boolean durationNsecSet;
        private long durationNsec;
        private boolean prioritySet;
        private int priority;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean cookieSet;
        private U64 cookie;
        private boolean packetCountSet;
        private U64 packetCount;
        private boolean byteCountSet;
        private U64 byteCount;
        private boolean matchSet;
        private Match match;
        private boolean instructionsSet;
        private List<OFInstruction> instructions;

        BuilderWithParent(OFFlowStatsEntryVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFFlowStatsEntry.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getDurationSec() {
            return this.durationSec;
        }

        @Override
        public OFFlowStatsEntry.Builder setDurationSec(long durationSec) {
            this.durationSec = durationSec;
            this.durationSecSet = true;
            return this;
        }

        @Override
        public long getDurationNsec() {
            return this.durationNsec;
        }

        @Override
        public OFFlowStatsEntry.Builder setDurationNsec(long durationNsec) {
            this.durationNsec = durationNsec;
            this.durationNsecSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFFlowStatsEntry.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public int getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public OFFlowStatsEntry.Builder setIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.idleTimeoutSet = true;
            return this;
        }

        @Override
        public int getHardTimeout() {
            return this.hardTimeout;
        }

        @Override
        public OFFlowStatsEntry.Builder setHardTimeout(int hardTimeout) {
            this.hardTimeout = hardTimeout;
            this.hardTimeoutSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFFlowStatsEntry.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public U64 getPacketCount() {
            return this.packetCount;
        }

        @Override
        public OFFlowStatsEntry.Builder setPacketCount(U64 packetCount) {
            this.packetCount = packetCount;
            this.packetCountSet = true;
            return this;
        }

        @Override
        public U64 getByteCount() {
            return this.byteCount;
        }

        @Override
        public OFFlowStatsEntry.Builder setByteCount(U64 byteCount) {
            this.byteCount = byteCount;
            this.byteCountSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFFlowStatsEntry.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public List<OFInstruction> getInstructions() {
            return this.instructions;
        }

        @Override
        public OFFlowStatsEntry.Builder setInstructions(List<OFInstruction> instructions) {
            this.instructions = instructions;
            this.instructionsSet = true;
            return this;
        }

        @Override
        public List<OFAction> getActions() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property actions not supported in version 1.2");
        }

        @Override
        public OFFlowStatsEntry.Builder setActions(List<OFAction> actions) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property actions not supported in version 1.2");
        }

        @Override
        public Set<OFFlowModFlags> getFlags() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flags not supported in version 1.2");
        }

        @Override
        public OFFlowStatsEntry.Builder setFlags(Set<OFFlowModFlags> flags) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flags not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFFlowStatsEntry build() {
            List instructions;
            Match match;
            U64 byteCount;
            U64 packetCount;
            U64 cookie;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            long durationSec = this.durationSecSet ? this.durationSec : this.parentMessage.durationSec;
            long durationNsec = this.durationNsecSet ? this.durationNsec : this.parentMessage.durationNsec;
            int priority = this.prioritySet ? this.priority : this.parentMessage.priority;
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : this.parentMessage.idleTimeout;
            int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : this.parentMessage.hardTimeout;
            U64 u64 = cookie = this.cookieSet ? this.cookie : this.parentMessage.cookie;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            U64 u642 = packetCount = this.packetCountSet ? this.packetCount : this.parentMessage.packetCount;
            if (packetCount == null) {
                throw new NullPointerException("Property packetCount must not be null");
            }
            U64 u643 = byteCount = this.byteCountSet ? this.byteCount : this.parentMessage.byteCount;
            if (byteCount == null) {
                throw new NullPointerException("Property byteCount must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : this.parentMessage.match;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            List list = instructions = this.instructionsSet ? this.instructions : this.parentMessage.instructions;
            if (instructions == null) {
                throw new NullPointerException("Property instructions must not be null");
            }
            return new OFFlowStatsEntryVer12(tableId, durationSec, durationNsec, priority, idleTimeout, hardTimeout, cookie, packetCount, byteCount, match, instructions);
        }
    }
}

