/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFMatchV3;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFOxmList;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.ver12.OFOxmVer12;
import org.projectfloodlight.openflow.types.Masked;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFMatchV3Ver12
implements OFMatchV3 {
    private static final Logger logger = LoggerFactory.getLogger(OFMatchV3Ver12.class);
    static final byte WIRE_VERSION = 3;
    static final int MINIMUM_LENGTH = 4;
    private static final OFOxmList DEFAULT_OXM_LIST = OFOxmList.EMPTY;
    private final OFOxmList oxmList;
    static final OFMatchV3Ver12 DEFAULT = new OFMatchV3Ver12(DEFAULT_OXM_LIST);
    static final Reader READER = new Reader();
    static final OFMatchV3Ver12Funnel FUNNEL = new OFMatchV3Ver12Funnel();
    static final Writer WRITER = new Writer();

    OFMatchV3Ver12(OFOxmList oxmList) {
        this.oxmList = oxmList;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public OFOxmList getOxmList() {
        return this.oxmList;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public <F extends OFValueType<F>> F get(MatchField<F> field) throws UnsupportedOperationException {
        if (!this.supports(field)) {
            throw new UnsupportedOperationException("OFMatchV3Ver13 does not support matching on field " + field.getName());
        }
        OFOxm<F> oxm = this.oxmList.get(field);
        if (oxm == null || !field.arePrerequisitesOK(this)) {
            return null;
        }
        return oxm.getValue();
    }

    @Override
    public <F extends OFValueType<F>> Masked<F> getMasked(MatchField<F> field) throws UnsupportedOperationException {
        if (!this.supportsMasked(field)) {
            throw new UnsupportedOperationException("OFMatchV3Ver13 does not support masked matching on field " + field.getName());
        }
        OFOxm<F> oxm = this.oxmList.get(field);
        if (oxm == null || !field.arePrerequisitesOK(this)) {
            return null;
        }
        if (oxm.getMask() == null) {
            return null;
        }
        return Masked.of(oxm.getValue(), oxm.getMask());
    }

    private static boolean supportsField(MatchField<?> field) {
        switch (field.id) {
            case IN_PORT: 
            case IN_PHY_PORT: 
            case METADATA: 
            case ETH_DST: 
            case ETH_SRC: 
            case ETH_TYPE: 
            case VLAN_VID: 
            case VLAN_PCP: 
            case IP_DSCP: 
            case IP_ECN: 
            case IP_PROTO: 
            case IPV4_SRC: 
            case IPV4_DST: 
            case TCP_SRC: 
            case TCP_DST: 
            case UDP_SRC: 
            case UDP_DST: 
            case SCTP_SRC: 
            case SCTP_DST: 
            case ICMPV4_TYPE: 
            case ICMPV4_CODE: 
            case ARP_OP: 
            case ARP_SPA: 
            case ARP_TPA: 
            case ARP_SHA: 
            case ARP_THA: 
            case IPV6_SRC: 
            case IPV6_DST: 
            case IPV6_FLABEL: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supports(MatchField<?> field) {
        return OFMatchV3Ver12.supportsField(field);
    }

    @Override
    public boolean supportsMasked(MatchField<?> field) {
        return OFMatchV3Ver12.supportsField(field);
    }

    @Override
    public boolean isExact(MatchField<?> field) {
        if (!this.supports(field)) {
            throw new UnsupportedOperationException("OFMatchV3Ver13 does not support matching on field " + field.getName());
        }
        OFOxm<?> oxm = this.oxmList.get(field);
        return oxm != null && !oxm.isMasked();
    }

    @Override
    public boolean isFullyWildcarded(MatchField<?> field) {
        if (!this.supports(field)) {
            throw new UnsupportedOperationException("OFMatchV3Ver13 does not support matching on field " + field.getName());
        }
        OFOxm<?> oxm = this.oxmList.get(field);
        return oxm == null;
    }

    @Override
    public boolean isPartiallyMasked(MatchField<?> field) {
        if (!this.supports(field)) {
            throw new UnsupportedOperationException("OFMatchV3Ver13 does not support matching on field " + field.getName());
        }
        OFOxm<?> oxm = this.oxmList.get(field);
        return oxm != null && oxm.isMasked();
    }

    @Override
    public Iterable<MatchField<?>> getMatchFields() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OFMatchV3.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFMatchV3Ver12(");
        b.append("oxmList=").append(this.oxmList);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMatchV3Ver12 other = (OFMatchV3Ver12)obj;
        return !(this.oxmList == null ? other.oxmList != null : !this.oxmList.equals(other.oxmList));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.oxmList == null ? 0 : this.oxmList.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFMatchV3Ver12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFMatchV3Ver12 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            message.oxmList.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            int alignedLength = (length + 7) / 8 * 8;
            bb.setShort(lengthIndex, length);
            bb.writeZero(alignedLength - length);
        }
    }

    static class OFMatchV3Ver12Funnel
    implements Funnel<OFMatchV3Ver12> {
        private static final long serialVersionUID = 1L;

        OFMatchV3Ver12Funnel() {
        }

        public void funnel(OFMatchV3Ver12 message, PrimitiveSink sink) {
            sink.putShort((short)1);
            message.oxmList.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFMatchV3> {
        Reader() {
        }

        @Override
        public OFMatchV3 readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=0x1(0x1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFOxmList oxmList = OFOxmList.readFrom(bb, length - (bb.readerIndex() - start), OFOxmVer12.READER);
            bb.skipBytes((length + 7) / 8 * 8 - length);
            OFMatchV3Ver12 matchV3Ver12 = new OFMatchV3Ver12(oxmList);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)matchV3Ver12);
            }
            return matchV3Ver12;
        }
    }

    static class Builder
    implements OFMatchV3.Builder {
        private boolean oxmListSet;
        private OFOxmList oxmList;
        private OFOxmList.Builder oxmListBuilder;

        Builder() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public OFOxmList getOxmList() {
            return this.oxmList;
        }

        @Override
        public OFMatchV3.Builder setOxmList(OFOxmList oxmList) {
            this.oxmList = oxmList;
            this.oxmListSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFMatchV3 build() {
            OFOxmList oxmList;
            OFOxmList oFOxmList = oxmList = this.oxmListSet ? this.oxmList : DEFAULT_OXM_LIST;
            if (oxmList == null) {
                throw new NullPointerException("Property oxmList must not be null");
            }
            return new OFMatchV3Ver12(oxmList);
        }

        private synchronized void initBuilder() {
            if (this.oxmListBuilder != null) {
                return;
            }
            this.oxmListBuilder = new OFOxmList.Builder();
        }

        private synchronized void updateOxmList() {
            this.oxmList = this.oxmListBuilder.build();
            this.oxmListSet = true;
        }

        private <F extends OFValueType<F>> OFOxm<F> getOxm(MatchField<F> field) {
            return this.oxmListSet ? this.oxmList.get(field) : null;
        }

        @Override
        public synchronized <F extends OFValueType<F>> F get(MatchField<F> field) throws UnsupportedOperationException {
            OFOxm<F> value = this.getOxm(field);
            if (value == null) {
                return null;
            }
            return value.getValue();
        }

        @Override
        public synchronized <F extends OFValueType<F>> Masked<F> getMasked(MatchField<F> field) throws UnsupportedOperationException {
            OFOxm<F> value = this.getOxm(field);
            if (value == null || !value.isMasked()) {
                return null;
            }
            return Masked.of(value.getValue(), value.getMask());
        }

        @Override
        public boolean supports(MatchField<?> field) {
            return OFMatchV3Ver12.supportsField(field);
        }

        @Override
        public boolean supportsMasked(MatchField<?> field) {
            return OFMatchV3Ver12.supportsField(field);
        }

        @Override
        public synchronized boolean isExact(MatchField<?> field) {
            OFOxm<?> value = this.getOxm(field);
            return value != null && !value.isMasked();
        }

        @Override
        public synchronized boolean isFullyWildcarded(MatchField<?> field) {
            OFOxm<?> value = this.getOxm(field);
            return value == null;
        }

        @Override
        public synchronized boolean isPartiallyMasked(MatchField<?> field) {
            OFOxm<?> value = this.getOxm(field);
            return value != null && value.isMasked();
        }

        @Override
        public synchronized <F extends OFValueType<F>> Match.Builder setExact(MatchField<F> field, F value) {
            this.initBuilder();
            OFOxm<F> oxm = OFFactories.getFactory(OFVersion.OF_13).oxms().fromValue(value, field);
            this.oxmListBuilder.set(oxm);
            this.updateOxmList();
            return this;
        }

        @Override
        public synchronized <F extends OFValueType<F>> Match.Builder setMasked(MatchField<F> field, F value, F mask) {
            this.initBuilder();
            OFOxm<F> oxm = OFFactories.getFactory(OFVersion.OF_13).oxms().fromValueAndMask(value, mask, field);
            this.oxmListBuilder.set(oxm);
            this.updateOxmList();
            return this;
        }

        @Override
        public synchronized <F extends OFValueType<F>> Match.Builder setMasked(MatchField<F> field, Masked<F> valueWithMask) {
            this.initBuilder();
            OFOxm<F> oxm = OFFactories.getFactory(OFVersion.OF_13).oxms().fromMasked(valueWithMask, field);
            this.oxmListBuilder.set(oxm);
            this.updateOxmList();
            return this;
        }

        @Override
        public synchronized <F extends OFValueType<F>> Match.Builder wildcard(MatchField<F> field) {
            this.initBuilder();
            this.oxmListBuilder.unset(field);
            this.updateOxmList();
            return this;
        }
    }

    static class BuilderWithParent
    implements OFMatchV3.Builder {
        final OFMatchV3Ver12 parentMessage;
        private boolean oxmListSet;
        private OFOxmList oxmList;
        private OFOxmList.Builder oxmListBuilder;

        BuilderWithParent(OFMatchV3Ver12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public OFOxmList getOxmList() {
            return this.oxmList;
        }

        @Override
        public OFMatchV3.Builder setOxmList(OFOxmList oxmList) {
            this.oxmList = oxmList;
            this.oxmListSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFMatchV3 build() {
            OFOxmList oxmList;
            OFOxmList oFOxmList = oxmList = this.oxmListSet ? this.oxmList : this.parentMessage.oxmList;
            if (oxmList == null) {
                throw new NullPointerException("Property oxmList must not be null");
            }
            return new OFMatchV3Ver12(oxmList);
        }

        private synchronized void initBuilder() {
            if (this.oxmListBuilder != null) {
                return;
            }
            this.oxmListBuilder = new OFOxmList.Builder();
        }

        private synchronized void updateOxmList() {
            this.oxmList = this.oxmListBuilder.build();
            this.oxmListSet = true;
        }

        private <F extends OFValueType<F>> OFOxm<F> getOxm(MatchField<F> field) {
            return this.oxmListSet ? this.oxmList.get(field) : this.parentMessage.oxmList.get(field);
        }

        @Override
        public synchronized <F extends OFValueType<F>> F get(MatchField<F> field) throws UnsupportedOperationException {
            OFOxm<F> value = this.getOxm(field);
            if (value == null) {
                return null;
            }
            return value.getValue();
        }

        @Override
        public synchronized <F extends OFValueType<F>> Masked<F> getMasked(MatchField<F> field) throws UnsupportedOperationException {
            OFOxm<F> value = this.getOxm(field);
            if (value == null || !value.isMasked()) {
                return null;
            }
            return Masked.of(value.getValue(), value.getMask());
        }

        @Override
        public boolean supports(MatchField<?> field) {
            return OFMatchV3Ver12.supportsField(field);
        }

        @Override
        public boolean supportsMasked(MatchField<?> field) {
            return OFMatchV3Ver12.supportsField(field);
        }

        @Override
        public synchronized boolean isExact(MatchField<?> field) {
            OFOxm<?> value = this.getOxm(field);
            return value != null && !value.isMasked();
        }

        @Override
        public synchronized boolean isFullyWildcarded(MatchField<?> field) {
            OFOxm<?> value = this.getOxm(field);
            return value == null;
        }

        @Override
        public synchronized boolean isPartiallyMasked(MatchField<?> field) {
            OFOxm<?> value = this.getOxm(field);
            return value != null && value.isMasked();
        }

        @Override
        public synchronized <F extends OFValueType<F>> Match.Builder setExact(MatchField<F> field, F value) {
            this.initBuilder();
            OFOxm<F> oxm = OFFactories.getFactory(OFVersion.OF_13).oxms().fromValue(value, field);
            this.oxmListBuilder.set(oxm);
            this.updateOxmList();
            return this;
        }

        @Override
        public synchronized <F extends OFValueType<F>> Match.Builder setMasked(MatchField<F> field, F value, F mask) {
            this.initBuilder();
            OFOxm<F> oxm = OFFactories.getFactory(OFVersion.OF_13).oxms().fromValueAndMask(value, mask, field);
            this.oxmListBuilder.set(oxm);
            this.updateOxmList();
            return this;
        }

        @Override
        public synchronized <F extends OFValueType<F>> Match.Builder setMasked(MatchField<F> field, Masked<F> valueWithMask) {
            this.initBuilder();
            OFOxm<F> oxm = OFFactories.getFactory(OFVersion.OF_13).oxms().fromMasked(valueWithMask, field);
            this.oxmListBuilder.set(oxm);
            this.updateOxmList();
            return this;
        }

        @Override
        public synchronized <F extends OFValueType<F>> Match.Builder wildcard(MatchField<F> field) {
            this.initBuilder();
            this.oxmListBuilder.unset(field);
            this.updateOxmList();
            return this;
        }
    }
}

