/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmArpTpaMasked;
import org.projectfloodlight.openflow.protocol.ver12.OFOxmArpTpaVer12;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmArpTpaMaskedVer12
implements OFOxmArpTpaMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmArpTpaMaskedVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 12;
    private static final IPv4Address DEFAULT_VALUE = IPv4Address.NONE;
    private static final IPv4Address DEFAULT_VALUE_MASK = IPv4Address.NONE;
    private final IPv4Address value;
    private final IPv4Address mask;
    static final OFOxmArpTpaMaskedVer12 DEFAULT = new OFOxmArpTpaMaskedVer12(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmArpTpaMaskedVer12Funnel FUNNEL = new OFOxmArpTpaMaskedVer12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmArpTpaMaskedVer12(IPv4Address value, IPv4Address mask) {
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147495688L;
    }

    @Override
    public IPv4Address getValue() {
        return this.value;
    }

    @Override
    public IPv4Address getMask() {
        return this.mask;
    }

    @Override
    public MatchField<IPv4Address> getMatchField() {
        return MatchField.ARP_TPA;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<IPv4Address> getCanonical() {
        if (IPv4Address.NO_MASK.equals(this.mask)) {
            return new OFOxmArpTpaVer12(this.value);
        }
        if (IPv4Address.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmArpTpaMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmArpTpaMaskedVer12(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmArpTpaMaskedVer12 other = (OFOxmArpTpaMaskedVer12)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmArpTpaMaskedVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmArpTpaMaskedVer12 message) {
            bb.writeInt(-2147471608);
            message.value.write4Bytes(bb);
            message.mask.write4Bytes(bb);
        }
    }

    static class OFOxmArpTpaMaskedVer12Funnel
    implements Funnel<OFOxmArpTpaMaskedVer12> {
        private static final long serialVersionUID = 1L;

        OFOxmArpTpaMaskedVer12Funnel() {
        }

        public void funnel(OFOxmArpTpaMaskedVer12 message, PrimitiveSink sink) {
            sink.putInt(-2147471608);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmArpTpaMasked> {
        Reader() {
        }

        @Override
        public OFOxmArpTpaMasked readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147471608) {
                throw new OFParseError("Wrong typeLen: Expected=0x80002f08L(0x80002f08L), got=" + typeLen);
            }
            IPv4Address value = IPv4Address.read4Bytes(bb);
            IPv4Address mask = IPv4Address.read4Bytes(bb);
            OFOxmArpTpaMaskedVer12 oxmArpTpaMaskedVer12 = new OFOxmArpTpaMaskedVer12(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmArpTpaMaskedVer12);
            }
            return oxmArpTpaMaskedVer12;
        }
    }

    static class Builder
    implements OFOxmArpTpaMasked.Builder {
        private boolean valueSet;
        private IPv4Address value;
        private boolean maskSet;
        private IPv4Address mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147495688L;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmArpTpaMasked.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public IPv4Address getMask() {
            return this.mask;
        }

        @Override
        public OFOxmArpTpaMasked.Builder setMask(IPv4Address mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<IPv4Address> getMatchField() {
            return MatchField.ARP_TPA;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<IPv4Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmArpTpaMasked build() {
            IPv4Address mask;
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            IPv4Address iPv4Address2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmArpTpaMaskedVer12(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmArpTpaMasked.Builder {
        final OFOxmArpTpaMaskedVer12 parentMessage;
        private boolean valueSet;
        private IPv4Address value;
        private boolean maskSet;
        private IPv4Address mask;

        BuilderWithParent(OFOxmArpTpaMaskedVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147495688L;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmArpTpaMasked.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public IPv4Address getMask() {
            return this.mask;
        }

        @Override
        public OFOxmArpTpaMasked.Builder setMask(IPv4Address mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<IPv4Address> getMatchField() {
            return MatchField.ARP_TPA;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<IPv4Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmArpTpaMasked build() {
            IPv4Address mask;
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            IPv4Address iPv4Address2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmArpTpaMaskedVer12(value, mask);
        }
    }
}

