/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnTcpFlags;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnTcpFlagsVer12
implements OFOxmBsnTcpFlags {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnTcpFlagsVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 6;
    private static final U16 DEFAULT_VALUE = U16.ZERO;
    private final U16 value;
    static final OFOxmBsnTcpFlagsVer12 DEFAULT = new OFOxmBsnTcpFlagsVer12(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnTcpFlagsVer12Funnel FUNNEL = new OFOxmBsnTcpFlagsVer12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnTcpFlagsVer12(U16 value) {
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 204802L;
    }

    @Override
    public U16 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U16> getMatchField() {
        return MatchField.BSN_TCP_FLAGS;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U16> getCanonical() {
        return this;
    }

    @Override
    public U16 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.2");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmBsnTcpFlags.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnTcpFlagsVer12(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnTcpFlagsVer12 other = (OFOxmBsnTcpFlagsVer12)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnTcpFlagsVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmBsnTcpFlagsVer12 message) {
            bb.writeInt(204802);
            bb.writeShort((int)message.value.getRaw());
        }
    }

    static class OFOxmBsnTcpFlagsVer12Funnel
    implements Funnel<OFOxmBsnTcpFlagsVer12> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnTcpFlagsVer12Funnel() {
        }

        public void funnel(OFOxmBsnTcpFlagsVer12 message, PrimitiveSink sink) {
            sink.putInt(204802);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnTcpFlags> {
        Reader() {
        }

        @Override
        public OFOxmBsnTcpFlags readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 204802) {
                throw new OFParseError("Wrong typeLen: Expected=0x32002L(0x32002L), got=" + typeLen);
            }
            U16 value = U16.of(bb.readShort());
            OFOxmBsnTcpFlagsVer12 oxmBsnTcpFlagsVer12 = new OFOxmBsnTcpFlagsVer12(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnTcpFlagsVer12);
            }
            return oxmBsnTcpFlagsVer12;
        }
    }

    static class Builder
    implements OFOxmBsnTcpFlags.Builder {
        private boolean valueSet;
        private U16 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 204802L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnTcpFlags.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.BSN_TCP_FLAGS;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U16 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmBsnTcpFlags build() {
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnTcpFlagsVer12(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnTcpFlags.Builder {
        final OFOxmBsnTcpFlagsVer12 parentMessage;
        private boolean valueSet;
        private U16 value;

        BuilderWithParent(OFOxmBsnTcpFlagsVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 204802L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnTcpFlags.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.BSN_TCP_FLAGS;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U16 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmBsnTcpFlags build() {
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnTcpFlagsVer12(value);
        }
    }
}

