/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpDscpMasked;
import org.projectfloodlight.openflow.protocol.ver12.OFOxmIpDscpVer12;
import org.projectfloodlight.openflow.types.IpDscp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIpDscpMaskedVer12
implements OFOxmIpDscpMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIpDscpMaskedVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 6;
    private static final IpDscp DEFAULT_VALUE = IpDscp.NONE;
    private static final IpDscp DEFAULT_VALUE_MASK = IpDscp.NONE;
    private final IpDscp value;
    private final IpDscp mask;
    static final OFOxmIpDscpMaskedVer12 DEFAULT = new OFOxmIpDscpMaskedVer12(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmIpDscpMaskedVer12Funnel FUNNEL = new OFOxmIpDscpMaskedVer12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIpDscpMaskedVer12(IpDscp value, IpDscp mask) {
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147488002L;
    }

    @Override
    public IpDscp getValue() {
        return this.value;
    }

    @Override
    public IpDscp getMask() {
        return this.mask;
    }

    @Override
    public MatchField<IpDscp> getMatchField() {
        return MatchField.IP_DSCP;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<IpDscp> getCanonical() {
        if (IpDscp.NO_MASK.equals(this.mask)) {
            return new OFOxmIpDscpVer12(this.value);
        }
        if (IpDscp.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmIpDscpMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIpDscpMaskedVer12(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIpDscpMaskedVer12 other = (OFOxmIpDscpMaskedVer12)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIpDscpMaskedVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmIpDscpMaskedVer12 message) {
            bb.writeInt(-2147479294);
            message.value.writeByte(bb);
            message.mask.writeByte(bb);
        }
    }

    static class OFOxmIpDscpMaskedVer12Funnel
    implements Funnel<OFOxmIpDscpMaskedVer12> {
        private static final long serialVersionUID = 1L;

        OFOxmIpDscpMaskedVer12Funnel() {
        }

        public void funnel(OFOxmIpDscpMaskedVer12 message, PrimitiveSink sink) {
            sink.putInt(-2147479294);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIpDscpMasked> {
        Reader() {
        }

        @Override
        public OFOxmIpDscpMasked readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147479294) {
                throw new OFParseError("Wrong typeLen: Expected=0x80001102L(0x80001102L), got=" + typeLen);
            }
            IpDscp value = IpDscp.readByte(bb);
            IpDscp mask = IpDscp.readByte(bb);
            OFOxmIpDscpMaskedVer12 oxmIpDscpMaskedVer12 = new OFOxmIpDscpMaskedVer12(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIpDscpMaskedVer12);
            }
            return oxmIpDscpMaskedVer12;
        }
    }

    static class Builder
    implements OFOxmIpDscpMasked.Builder {
        private boolean valueSet;
        private IpDscp value;
        private boolean maskSet;
        private IpDscp mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147488002L;
        }

        @Override
        public IpDscp getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpDscpMasked.Builder setValue(IpDscp value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public IpDscp getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIpDscpMasked.Builder setMask(IpDscp mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<IpDscp> getMatchField() {
            return MatchField.IP_DSCP;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<IpDscp> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmIpDscpMasked build() {
            IpDscp mask;
            IpDscp value;
            IpDscp ipDscp = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            IpDscp ipDscp2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIpDscpMaskedVer12(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmIpDscpMasked.Builder {
        final OFOxmIpDscpMaskedVer12 parentMessage;
        private boolean valueSet;
        private IpDscp value;
        private boolean maskSet;
        private IpDscp mask;

        BuilderWithParent(OFOxmIpDscpMaskedVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147488002L;
        }

        @Override
        public IpDscp getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpDscpMasked.Builder setValue(IpDscp value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public IpDscp getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIpDscpMasked.Builder setMask(IpDscp mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<IpDscp> getMatchField() {
            return MatchField.IP_DSCP;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<IpDscp> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmIpDscpMasked build() {
            IpDscp mask;
            IpDscp value;
            IpDscp ipDscp = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            IpDscp ipDscp2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIpDscpMaskedVer12(value, mask);
        }
    }
}

