/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortStatsRequest;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver12.OFStatsRequestFlagsSerializerVer12;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortStatsRequestVer12
implements OFPortStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFPortStatsRequestVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    private final OFPort portNo;
    static final OFPortStatsRequestVer12 DEFAULT = new OFPortStatsRequestVer12(0L, DEFAULT_FLAGS, DEFAULT_PORT_NO);
    static final Reader READER = new Reader();
    static final OFPortStatsRequestVer12Funnel FUNNEL = new OFPortStatsRequestVer12Funnel();
    static final Writer WRITER = new Writer();

    OFPortStatsRequestVer12(long xid, Set<OFStatsRequestFlags> flags, OFPort portNo) {
        this.xid = xid;
        this.flags = flags;
        this.portNo = portNo;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.PORT;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public OFPortStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortStatsRequestVer12(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("portNo=").append(this.portNo);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortStatsRequestVer12 other = (OFPortStatsRequestVer12)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortStatsRequestVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFPortStatsRequestVer12 message) {
            bb.writeByte(3);
            bb.writeByte(18);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(4);
            OFStatsRequestFlagsSerializerVer12.writeTo(bb, message.flags);
            bb.writeZero(4);
            message.portNo.write4Bytes(bb);
            bb.writeZero(4);
        }
    }

    static class OFPortStatsRequestVer12Funnel
    implements Funnel<OFPortStatsRequestVer12> {
        private static final long serialVersionUID = 1L;

        OFPortStatsRequestVer12Funnel() {
        }

        public void funnel(OFPortStatsRequestVer12 message, PrimitiveSink sink) {
            sink.putByte((byte)3);
            sink.putByte((byte)18);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putShort((short)4);
            OFStatsRequestFlagsSerializerVer12.putTo(message.flags, sink);
            message.portNo.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortStatsRequest> {
        Reader() {
        }

        @Override
        public OFPortStatsRequest readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 4) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.PORT(4), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer12.readFrom(bb);
            bb.skipBytes(4);
            OFPort portNo = OFPort.read4Bytes(bb);
            bb.skipBytes(4);
            OFPortStatsRequestVer12 portStatsRequestVer12 = new OFPortStatsRequestVer12(xid, flags, portNo);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portStatsRequestVer12);
            }
            return portStatsRequestVer12;
        }
    }

    static class Builder
    implements OFPortStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean portNoSet;
        private OFPort portNo;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPortStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.PORT;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFPortStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFPortStatsRequest.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public OFPortStatsRequest build() {
            OFPort portNo;
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            return new OFPortStatsRequestVer12(xid, flags, portNo);
        }
    }

    static class BuilderWithParent
    implements OFPortStatsRequest.Builder {
        final OFPortStatsRequestVer12 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean portNoSet;
        private OFPort portNo;

        BuilderWithParent(OFPortStatsRequestVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPortStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.PORT;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFPortStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFPortStatsRequest.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public OFPortStatsRequest build() {
            OFPort portNo;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            return new OFPortStatsRequestVer12(xid, flags, portNo);
        }
    }
}

