/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFControllerRole;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFRoleRequest;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver12.OFControllerRoleSerializerVer12;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFRoleRequestVer12
implements OFRoleRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFRoleRequestVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final U64 DEFAULT_GENERATION_ID = U64.ZERO;
    private final long xid;
    private final OFControllerRole role;
    private final U64 generationId;
    static final Reader READER = new Reader();
    static final OFRoleRequestVer12Funnel FUNNEL = new OFRoleRequestVer12Funnel();
    static final Writer WRITER = new Writer();

    OFRoleRequestVer12(long xid, OFControllerRole role, U64 generationId) {
        this.xid = xid;
        this.role = role;
        this.generationId = generationId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFType getType() {
        return OFType.ROLE_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFControllerRole getRole() {
        return this.role;
    }

    @Override
    public U64 getGenerationId() {
        return this.generationId;
    }

    @Override
    public OFRoleRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFRoleRequestVer12(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("role=").append((Object)this.role);
        b.append(", ");
        b.append("generationId=").append(this.generationId);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFRoleRequestVer12 other = (OFRoleRequestVer12)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.role == null ? other.role != null : !this.role.equals((Object)other.role)) {
            return false;
        }
        return !(this.generationId == null ? other.generationId != null : !this.generationId.equals(other.generationId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + (this.generationId == null ? 0 : this.generationId.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFRoleRequestVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFRoleRequestVer12 message) {
            bb.writeByte(3);
            bb.writeByte(24);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            OFControllerRoleSerializerVer12.writeTo(bb, message.role);
            bb.writeZero(4);
            bb.writeLong(message.generationId.getValue());
        }
    }

    static class OFRoleRequestVer12Funnel
    implements Funnel<OFRoleRequestVer12> {
        private static final long serialVersionUID = 1L;

        OFRoleRequestVer12Funnel() {
        }

        public void funnel(OFRoleRequestVer12 message, PrimitiveSink sink) {
            sink.putByte((byte)3);
            sink.putByte((byte)24);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            OFControllerRoleSerializerVer12.putTo(message.role, sink);
            message.generationId.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFRoleRequest> {
        Reader() {
        }

        @Override
        public OFRoleRequest readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 24) {
                throw new OFParseError("Wrong type: Expected=OFType.ROLE_REQUEST(24), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFControllerRole role = OFControllerRoleSerializerVer12.readFrom(bb);
            bb.skipBytes(4);
            U64 generationId = U64.ofRaw(bb.readLong());
            OFRoleRequestVer12 roleRequestVer12 = new OFRoleRequestVer12(xid, role, generationId);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)roleRequestVer12);
            }
            return roleRequestVer12;
        }
    }

    static class Builder
    implements OFRoleRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean roleSet;
        private OFControllerRole role;
        private boolean generationIdSet;
        private U64 generationId;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.ROLE_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFRoleRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFControllerRole getRole() {
            return this.role;
        }

        @Override
        public OFRoleRequest.Builder setRole(OFControllerRole role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public U64 getGenerationId() {
            return this.generationId;
        }

        @Override
        public OFRoleRequest.Builder setGenerationId(U64 generationId) {
            this.generationId = generationId;
            this.generationIdSet = true;
            return this;
        }

        @Override
        public OFRoleRequest build() {
            U64 generationId;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.roleSet) {
                throw new IllegalStateException("Property role doesn't have default value -- must be set");
            }
            if (this.role == null) {
                throw new NullPointerException("Property role must not be null");
            }
            U64 u64 = generationId = this.generationIdSet ? this.generationId : DEFAULT_GENERATION_ID;
            if (generationId == null) {
                throw new NullPointerException("Property generationId must not be null");
            }
            return new OFRoleRequestVer12(xid, this.role, generationId);
        }
    }

    static class BuilderWithParent
    implements OFRoleRequest.Builder {
        final OFRoleRequestVer12 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean roleSet;
        private OFControllerRole role;
        private boolean generationIdSet;
        private U64 generationId;

        BuilderWithParent(OFRoleRequestVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.ROLE_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFRoleRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFControllerRole getRole() {
            return this.role;
        }

        @Override
        public OFRoleRequest.Builder setRole(OFControllerRole role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public U64 getGenerationId() {
            return this.generationId;
        }

        @Override
        public OFRoleRequest.Builder setGenerationId(U64 generationId) {
            this.generationId = generationId;
            this.generationIdSet = true;
            return this;
        }

        @Override
        public OFRoleRequest build() {
            U64 generationId;
            OFControllerRole role;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFControllerRole oFControllerRole = role = this.roleSet ? this.role : this.parentMessage.role;
            if (role == null) {
                throw new NullPointerException("Property role must not be null");
            }
            U64 u64 = generationId = this.generationIdSet ? this.generationId : this.parentMessage.generationId;
            if (generationId == null) {
                throw new NullPointerException("Property generationId must not be null");
            }
            return new OFRoleRequestVer12(xid, role, generationId);
        }
    }
}

