/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAsyncSet;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAsyncSetVer13
implements OFAsyncSet {
    private static final Logger logger = LoggerFactory.getLogger(OFAsyncSetVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 32;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_PACKET_IN_MASK_EQUAL_MASTER = 0L;
    private static final long DEFAULT_PACKET_IN_MASK_SLAVE = 0L;
    private static final long DEFAULT_PORT_STATUS_MASK_EQUAL_MASTER = 0L;
    private static final long DEFAULT_PORT_STATUS_MASK_SLAVE = 0L;
    private static final long DEFAULT_FLOW_REMOVED_MASK_EQUAL_MASTER = 0L;
    private static final long DEFAULT_FLOW_REMOVED_MASK_SLAVE = 0L;
    private final long xid;
    private final long packetInMaskEqualMaster;
    private final long packetInMaskSlave;
    private final long portStatusMaskEqualMaster;
    private final long portStatusMaskSlave;
    private final long flowRemovedMaskEqualMaster;
    private final long flowRemovedMaskSlave;
    static final OFAsyncSetVer13 DEFAULT = new OFAsyncSetVer13(0L, 0L, 0L, 0L, 0L, 0L, 0L);
    static final Reader READER = new Reader();
    static final OFAsyncSetVer13Funnel FUNNEL = new OFAsyncSetVer13Funnel();
    static final Writer WRITER = new Writer();

    OFAsyncSetVer13(long xid, long packetInMaskEqualMaster, long packetInMaskSlave, long portStatusMaskEqualMaster, long portStatusMaskSlave, long flowRemovedMaskEqualMaster, long flowRemovedMaskSlave) {
        this.xid = xid;
        this.packetInMaskEqualMaster = packetInMaskEqualMaster;
        this.packetInMaskSlave = packetInMaskSlave;
        this.portStatusMaskEqualMaster = portStatusMaskEqualMaster;
        this.portStatusMaskSlave = portStatusMaskSlave;
        this.flowRemovedMaskEqualMaster = flowRemovedMaskEqualMaster;
        this.flowRemovedMaskSlave = flowRemovedMaskSlave;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.SET_ASYNC;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getPacketInMaskEqualMaster() {
        return this.packetInMaskEqualMaster;
    }

    @Override
    public long getPacketInMaskSlave() {
        return this.packetInMaskSlave;
    }

    @Override
    public long getPortStatusMaskEqualMaster() {
        return this.portStatusMaskEqualMaster;
    }

    @Override
    public long getPortStatusMaskSlave() {
        return this.portStatusMaskSlave;
    }

    @Override
    public long getFlowRemovedMaskEqualMaster() {
        return this.flowRemovedMaskEqualMaster;
    }

    @Override
    public long getFlowRemovedMaskSlave() {
        return this.flowRemovedMaskSlave;
    }

    @Override
    public OFAsyncSet.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAsyncSetVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("packetInMaskEqualMaster=").append(this.packetInMaskEqualMaster);
        b.append(", ");
        b.append("packetInMaskSlave=").append(this.packetInMaskSlave);
        b.append(", ");
        b.append("portStatusMaskEqualMaster=").append(this.portStatusMaskEqualMaster);
        b.append(", ");
        b.append("portStatusMaskSlave=").append(this.portStatusMaskSlave);
        b.append(", ");
        b.append("flowRemovedMaskEqualMaster=").append(this.flowRemovedMaskEqualMaster);
        b.append(", ");
        b.append("flowRemovedMaskSlave=").append(this.flowRemovedMaskSlave);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncSetVer13 other = (OFAsyncSetVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.packetInMaskEqualMaster != other.packetInMaskEqualMaster) {
            return false;
        }
        if (this.packetInMaskSlave != other.packetInMaskSlave) {
            return false;
        }
        if (this.portStatusMaskEqualMaster != other.portStatusMaskEqualMaster) {
            return false;
        }
        if (this.portStatusMaskSlave != other.portStatusMaskSlave) {
            return false;
        }
        if (this.flowRemovedMaskEqualMaster != other.flowRemovedMaskEqualMaster) {
            return false;
        }
        return this.flowRemovedMaskSlave == other.flowRemovedMaskSlave;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.packetInMaskEqualMaster ^ this.packetInMaskEqualMaster >>> 32);
        result = 31 * (int)(this.packetInMaskSlave ^ this.packetInMaskSlave >>> 32);
        result = 31 * (int)(this.portStatusMaskEqualMaster ^ this.portStatusMaskEqualMaster >>> 32);
        result = 31 * (int)(this.portStatusMaskSlave ^ this.portStatusMaskSlave >>> 32);
        result = 31 * (int)(this.flowRemovedMaskEqualMaster ^ this.flowRemovedMaskEqualMaster >>> 32);
        result = 31 * (int)(this.flowRemovedMaskSlave ^ this.flowRemovedMaskSlave >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAsyncSetVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFAsyncSetVer13 message) {
            bb.writeByte(4);
            bb.writeByte(28);
            bb.writeShort(32);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(U32.t(message.packetInMaskEqualMaster));
            bb.writeInt(U32.t(message.packetInMaskSlave));
            bb.writeInt(U32.t(message.portStatusMaskEqualMaster));
            bb.writeInt(U32.t(message.portStatusMaskSlave));
            bb.writeInt(U32.t(message.flowRemovedMaskEqualMaster));
            bb.writeInt(U32.t(message.flowRemovedMaskSlave));
        }
    }

    static class OFAsyncSetVer13Funnel
    implements Funnel<OFAsyncSetVer13> {
        private static final long serialVersionUID = 1L;

        OFAsyncSetVer13Funnel() {
        }

        public void funnel(OFAsyncSetVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)28);
            sink.putShort((short)32);
            sink.putLong(message.xid);
            sink.putLong(message.packetInMaskEqualMaster);
            sink.putLong(message.packetInMaskSlave);
            sink.putLong(message.portStatusMaskEqualMaster);
            sink.putLong(message.portStatusMaskSlave);
            sink.putLong(message.flowRemovedMaskEqualMaster);
            sink.putLong(message.flowRemovedMaskSlave);
        }
    }

    static class Reader
    implements OFMessageReader<OFAsyncSet> {
        Reader() {
        }

        @Override
        public OFAsyncSet readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 28) {
                throw new OFParseError("Wrong type: Expected=OFType.SET_ASYNC(28), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 32) {
                throw new OFParseError("Wrong length: Expected=32(32), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            long packetInMaskEqualMaster = U32.f(bb.readInt());
            long packetInMaskSlave = U32.f(bb.readInt());
            long portStatusMaskEqualMaster = U32.f(bb.readInt());
            long portStatusMaskSlave = U32.f(bb.readInt());
            long flowRemovedMaskEqualMaster = U32.f(bb.readInt());
            long flowRemovedMaskSlave = U32.f(bb.readInt());
            OFAsyncSetVer13 asyncSetVer13 = new OFAsyncSetVer13(xid, packetInMaskEqualMaster, packetInMaskSlave, portStatusMaskEqualMaster, portStatusMaskSlave, flowRemovedMaskEqualMaster, flowRemovedMaskSlave);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)asyncSetVer13);
            }
            return asyncSetVer13;
        }
    }

    static class Builder
    implements OFAsyncSet.Builder {
        private boolean xidSet;
        private long xid;
        private boolean packetInMaskEqualMasterSet;
        private long packetInMaskEqualMaster;
        private boolean packetInMaskSlaveSet;
        private long packetInMaskSlave;
        private boolean portStatusMaskEqualMasterSet;
        private long portStatusMaskEqualMaster;
        private boolean portStatusMaskSlaveSet;
        private long portStatusMaskSlave;
        private boolean flowRemovedMaskEqualMasterSet;
        private long flowRemovedMaskEqualMaster;
        private boolean flowRemovedMaskSlaveSet;
        private long flowRemovedMaskSlave;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.SET_ASYNC;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFAsyncSet.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getPacketInMaskEqualMaster() {
            return this.packetInMaskEqualMaster;
        }

        @Override
        public OFAsyncSet.Builder setPacketInMaskEqualMaster(long packetInMaskEqualMaster) {
            this.packetInMaskEqualMaster = packetInMaskEqualMaster;
            this.packetInMaskEqualMasterSet = true;
            return this;
        }

        @Override
        public long getPacketInMaskSlave() {
            return this.packetInMaskSlave;
        }

        @Override
        public OFAsyncSet.Builder setPacketInMaskSlave(long packetInMaskSlave) {
            this.packetInMaskSlave = packetInMaskSlave;
            this.packetInMaskSlaveSet = true;
            return this;
        }

        @Override
        public long getPortStatusMaskEqualMaster() {
            return this.portStatusMaskEqualMaster;
        }

        @Override
        public OFAsyncSet.Builder setPortStatusMaskEqualMaster(long portStatusMaskEqualMaster) {
            this.portStatusMaskEqualMaster = portStatusMaskEqualMaster;
            this.portStatusMaskEqualMasterSet = true;
            return this;
        }

        @Override
        public long getPortStatusMaskSlave() {
            return this.portStatusMaskSlave;
        }

        @Override
        public OFAsyncSet.Builder setPortStatusMaskSlave(long portStatusMaskSlave) {
            this.portStatusMaskSlave = portStatusMaskSlave;
            this.portStatusMaskSlaveSet = true;
            return this;
        }

        @Override
        public long getFlowRemovedMaskEqualMaster() {
            return this.flowRemovedMaskEqualMaster;
        }

        @Override
        public OFAsyncSet.Builder setFlowRemovedMaskEqualMaster(long flowRemovedMaskEqualMaster) {
            this.flowRemovedMaskEqualMaster = flowRemovedMaskEqualMaster;
            this.flowRemovedMaskEqualMasterSet = true;
            return this;
        }

        @Override
        public long getFlowRemovedMaskSlave() {
            return this.flowRemovedMaskSlave;
        }

        @Override
        public OFAsyncSet.Builder setFlowRemovedMaskSlave(long flowRemovedMaskSlave) {
            this.flowRemovedMaskSlave = flowRemovedMaskSlave;
            this.flowRemovedMaskSlaveSet = true;
            return this;
        }

        @Override
        public OFAsyncSet build() {
            long xid = this.xidSet ? this.xid : 0L;
            long packetInMaskEqualMaster = this.packetInMaskEqualMasterSet ? this.packetInMaskEqualMaster : 0L;
            long packetInMaskSlave = this.packetInMaskSlaveSet ? this.packetInMaskSlave : 0L;
            long portStatusMaskEqualMaster = this.portStatusMaskEqualMasterSet ? this.portStatusMaskEqualMaster : 0L;
            long portStatusMaskSlave = this.portStatusMaskSlaveSet ? this.portStatusMaskSlave : 0L;
            long flowRemovedMaskEqualMaster = this.flowRemovedMaskEqualMasterSet ? this.flowRemovedMaskEqualMaster : 0L;
            long flowRemovedMaskSlave = this.flowRemovedMaskSlaveSet ? this.flowRemovedMaskSlave : 0L;
            return new OFAsyncSetVer13(xid, packetInMaskEqualMaster, packetInMaskSlave, portStatusMaskEqualMaster, portStatusMaskSlave, flowRemovedMaskEqualMaster, flowRemovedMaskSlave);
        }
    }

    static class BuilderWithParent
    implements OFAsyncSet.Builder {
        final OFAsyncSetVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean packetInMaskEqualMasterSet;
        private long packetInMaskEqualMaster;
        private boolean packetInMaskSlaveSet;
        private long packetInMaskSlave;
        private boolean portStatusMaskEqualMasterSet;
        private long portStatusMaskEqualMaster;
        private boolean portStatusMaskSlaveSet;
        private long portStatusMaskSlave;
        private boolean flowRemovedMaskEqualMasterSet;
        private long flowRemovedMaskEqualMaster;
        private boolean flowRemovedMaskSlaveSet;
        private long flowRemovedMaskSlave;

        BuilderWithParent(OFAsyncSetVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.SET_ASYNC;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFAsyncSet.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getPacketInMaskEqualMaster() {
            return this.packetInMaskEqualMaster;
        }

        @Override
        public OFAsyncSet.Builder setPacketInMaskEqualMaster(long packetInMaskEqualMaster) {
            this.packetInMaskEqualMaster = packetInMaskEqualMaster;
            this.packetInMaskEqualMasterSet = true;
            return this;
        }

        @Override
        public long getPacketInMaskSlave() {
            return this.packetInMaskSlave;
        }

        @Override
        public OFAsyncSet.Builder setPacketInMaskSlave(long packetInMaskSlave) {
            this.packetInMaskSlave = packetInMaskSlave;
            this.packetInMaskSlaveSet = true;
            return this;
        }

        @Override
        public long getPortStatusMaskEqualMaster() {
            return this.portStatusMaskEqualMaster;
        }

        @Override
        public OFAsyncSet.Builder setPortStatusMaskEqualMaster(long portStatusMaskEqualMaster) {
            this.portStatusMaskEqualMaster = portStatusMaskEqualMaster;
            this.portStatusMaskEqualMasterSet = true;
            return this;
        }

        @Override
        public long getPortStatusMaskSlave() {
            return this.portStatusMaskSlave;
        }

        @Override
        public OFAsyncSet.Builder setPortStatusMaskSlave(long portStatusMaskSlave) {
            this.portStatusMaskSlave = portStatusMaskSlave;
            this.portStatusMaskSlaveSet = true;
            return this;
        }

        @Override
        public long getFlowRemovedMaskEqualMaster() {
            return this.flowRemovedMaskEqualMaster;
        }

        @Override
        public OFAsyncSet.Builder setFlowRemovedMaskEqualMaster(long flowRemovedMaskEqualMaster) {
            this.flowRemovedMaskEqualMaster = flowRemovedMaskEqualMaster;
            this.flowRemovedMaskEqualMasterSet = true;
            return this;
        }

        @Override
        public long getFlowRemovedMaskSlave() {
            return this.flowRemovedMaskSlave;
        }

        @Override
        public OFAsyncSet.Builder setFlowRemovedMaskSlave(long flowRemovedMaskSlave) {
            this.flowRemovedMaskSlave = flowRemovedMaskSlave;
            this.flowRemovedMaskSlaveSet = true;
            return this;
        }

        @Override
        public OFAsyncSet build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long packetInMaskEqualMaster = this.packetInMaskEqualMasterSet ? this.packetInMaskEqualMaster : this.parentMessage.packetInMaskEqualMaster;
            long packetInMaskSlave = this.packetInMaskSlaveSet ? this.packetInMaskSlave : this.parentMessage.packetInMaskSlave;
            long portStatusMaskEqualMaster = this.portStatusMaskEqualMasterSet ? this.portStatusMaskEqualMaster : this.parentMessage.portStatusMaskEqualMaster;
            long portStatusMaskSlave = this.portStatusMaskSlaveSet ? this.portStatusMaskSlave : this.parentMessage.portStatusMaskSlave;
            long flowRemovedMaskEqualMaster = this.flowRemovedMaskEqualMasterSet ? this.flowRemovedMaskEqualMaster : this.parentMessage.flowRemovedMaskEqualMaster;
            long flowRemovedMaskSlave = this.flowRemovedMaskSlaveSet ? this.flowRemovedMaskSlave : this.parentMessage.flowRemovedMaskSlave;
            return new OFAsyncSetVer13(xid, packetInMaskEqualMaster, packetInMaskSlave, portStatusMaskEqualMaster, portStatusMaskSlave, flowRemovedMaskEqualMaster, flowRemovedMaskSlave);
        }
    }
}

