/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnFlowIdleEnableSetReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnFlowIdleEnableSetReplyVer13
implements OFBsnFlowIdleEnableSetReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnFlowIdleEnableSetReplyVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_ENABLE = 0L;
    private static final long DEFAULT_STATUS = 0L;
    private final long xid;
    private final long enable;
    private final long status;
    static final OFBsnFlowIdleEnableSetReplyVer13 DEFAULT = new OFBsnFlowIdleEnableSetReplyVer13(0L, 0L, 0L);
    static final Reader READER = new Reader();
    static final OFBsnFlowIdleEnableSetReplyVer13Funnel FUNNEL = new OFBsnFlowIdleEnableSetReplyVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnFlowIdleEnableSetReplyVer13(long xid, long enable, long status) {
        this.xid = xid;
        this.enable = enable;
        this.status = status;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 37L;
    }

    @Override
    public long getEnable() {
        return this.enable;
    }

    @Override
    public long getStatus() {
        return this.status;
    }

    @Override
    public OFBsnFlowIdleEnableSetReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnFlowIdleEnableSetReplyVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("enable=").append(this.enable);
        b.append(", ");
        b.append("status=").append(this.status);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnFlowIdleEnableSetReplyVer13 other = (OFBsnFlowIdleEnableSetReplyVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.enable != other.enable) {
            return false;
        }
        return this.status == other.status;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.enable ^ this.enable >>> 32);
        result = 31 * (int)(this.status ^ this.status >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnFlowIdleEnableSetReplyVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnFlowIdleEnableSetReplyVer13 message) {
            bb.writeByte(4);
            bb.writeByte(4);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(37);
            bb.writeInt(U32.t(message.enable));
            bb.writeInt(U32.t(message.status));
        }
    }

    static class OFBsnFlowIdleEnableSetReplyVer13Funnel
    implements Funnel<OFBsnFlowIdleEnableSetReplyVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnFlowIdleEnableSetReplyVer13Funnel() {
        }

        public void funnel(OFBsnFlowIdleEnableSetReplyVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(37);
            sink.putLong(message.enable);
            sink.putLong(message.status);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnFlowIdleEnableSetReply> {
        Reader() {
        }

        @Override
        public OFBsnFlowIdleEnableSetReply readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 37) {
                throw new OFParseError("Wrong subtype: Expected=0x25L(0x25L), got=" + subtype);
            }
            long enable = U32.f(bb.readInt());
            long status = U32.f(bb.readInt());
            OFBsnFlowIdleEnableSetReplyVer13 bsnFlowIdleEnableSetReplyVer13 = new OFBsnFlowIdleEnableSetReplyVer13(xid, enable, status);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnFlowIdleEnableSetReplyVer13);
            }
            return bsnFlowIdleEnableSetReplyVer13;
        }
    }

    static class Builder
    implements OFBsnFlowIdleEnableSetReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean enableSet;
        private long enable;
        private boolean statusSet;
        private long status;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnFlowIdleEnableSetReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 37L;
        }

        @Override
        public long getEnable() {
            return this.enable;
        }

        @Override
        public OFBsnFlowIdleEnableSetReply.Builder setEnable(long enable) {
            this.enable = enable;
            this.enableSet = true;
            return this;
        }

        @Override
        public long getStatus() {
            return this.status;
        }

        @Override
        public OFBsnFlowIdleEnableSetReply.Builder setStatus(long status) {
            this.status = status;
            this.statusSet = true;
            return this;
        }

        @Override
        public OFBsnFlowIdleEnableSetReply build() {
            long xid = this.xidSet ? this.xid : 0L;
            long enable = this.enableSet ? this.enable : 0L;
            long status = this.statusSet ? this.status : 0L;
            return new OFBsnFlowIdleEnableSetReplyVer13(xid, enable, status);
        }
    }

    static class BuilderWithParent
    implements OFBsnFlowIdleEnableSetReply.Builder {
        final OFBsnFlowIdleEnableSetReplyVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean enableSet;
        private long enable;
        private boolean statusSet;
        private long status;

        BuilderWithParent(OFBsnFlowIdleEnableSetReplyVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnFlowIdleEnableSetReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 37L;
        }

        @Override
        public long getEnable() {
            return this.enable;
        }

        @Override
        public OFBsnFlowIdleEnableSetReply.Builder setEnable(long enable) {
            this.enable = enable;
            this.enableSet = true;
            return this;
        }

        @Override
        public long getStatus() {
            return this.status;
        }

        @Override
        public OFBsnFlowIdleEnableSetReply.Builder setStatus(long status) {
            this.status = status;
            this.statusSet = true;
            return this;
        }

        @Override
        public OFBsnFlowIdleEnableSetReply build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long enable = this.enableSet ? this.enable : this.parentMessage.enable;
            long status = this.statusSet ? this.status : this.parentMessage.status;
            return new OFBsnFlowIdleEnableSetReplyVer13(xid, enable, status);
        }
    }
}

