/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGentableBucketStatsEntry;
import org.projectfloodlight.openflow.protocol.OFBsnGentableBucketStatsReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnGentableBucketStatsEntryVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFStatsReplyFlagsSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGentableBucketStatsReplyVer13
implements OFBsnGentableBucketStatsReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGentableBucketStatsReplyVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsReplyFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final List<OFBsnGentableBucketStatsEntry> DEFAULT_ENTRIES = ImmutableList.of();
    private final long xid;
    private final Set<OFStatsReplyFlags> flags;
    private final List<OFBsnGentableBucketStatsEntry> entries;
    static final OFBsnGentableBucketStatsReplyVer13 DEFAULT = new OFBsnGentableBucketStatsReplyVer13(0L, DEFAULT_FLAGS, DEFAULT_ENTRIES);
    static final Reader READER = new Reader();
    static final OFBsnGentableBucketStatsReplyVer13Funnel FUNNEL = new OFBsnGentableBucketStatsReplyVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGentableBucketStatsReplyVer13(long xid, Set<OFStatsReplyFlags> flags, List<OFBsnGentableBucketStatsEntry> entries) {
        this.xid = xid;
        this.flags = flags;
        this.entries = entries;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.EXPERIMENTER;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 5L;
    }

    @Override
    public List<OFBsnGentableBucketStatsEntry> getEntries() {
        return this.entries;
    }

    @Override
    public OFBsnGentableBucketStatsReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGentableBucketStatsReplyVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("entries=").append(this.entries);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableBucketStatsReplyVer13 other = (OFBsnGentableBucketStatsReplyVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGentableBucketStatsReplyVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnGentableBucketStatsReplyVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(4);
            bb.writeByte(19);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(-1);
            OFStatsReplyFlagsSerializerVer13.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeInt(6035143);
            bb.writeInt(5);
            ChannelUtils.writeList(bb, message.entries);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnGentableBucketStatsReplyVer13Funnel
    implements Funnel<OFBsnGentableBucketStatsReplyVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnGentableBucketStatsReplyVer13Funnel() {
        }

        public void funnel(OFBsnGentableBucketStatsReplyVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)19);
            sink.putLong(message.xid);
            sink.putShort((short)-1);
            OFStatsReplyFlagsSerializerVer13.putTo(message.flags, sink);
            sink.putInt(6035143);
            sink.putInt(5);
            FunnelUtils.putList(message.entries, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGentableBucketStatsReply> {
        Reader() {
        }

        @Override
        public OFBsnGentableBucketStatsReply readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 24) {
                throw new OFParseError("Wrong length: Expected to be >= 24, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != -1) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got=" + statsType);
            }
            Set<OFStatsReplyFlags> flags = OFStatsReplyFlagsSerializerVer13.readFrom(bb);
            bb.skipBytes(4);
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 5) {
                throw new OFParseError("Wrong subtype: Expected=0x5L(0x5L), got=" + subtype);
            }
            List<OFBsnGentableBucketStatsEntry> entries = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBsnGentableBucketStatsEntryVer13.READER);
            OFBsnGentableBucketStatsReplyVer13 bsnGentableBucketStatsReplyVer13 = new OFBsnGentableBucketStatsReplyVer13(xid, flags, entries);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGentableBucketStatsReplyVer13);
            }
            return bsnGentableBucketStatsReplyVer13;
        }
    }

    static class Builder
    implements OFBsnGentableBucketStatsReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean entriesSet;
        private List<OFBsnGentableBucketStatsEntry> entries;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGentableBucketStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnGentableBucketStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 5L;
        }

        @Override
        public List<OFBsnGentableBucketStatsEntry> getEntries() {
            return this.entries;
        }

        @Override
        public OFBsnGentableBucketStatsReply.Builder setEntries(List<OFBsnGentableBucketStatsEntry> entries) {
            this.entries = entries;
            this.entriesSet = true;
            return this;
        }

        @Override
        public OFBsnGentableBucketStatsReply build() {
            List<OFBsnGentableBucketStatsEntry> entries;
            Set<OFStatsReplyFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsReplyFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List<OFBsnGentableBucketStatsEntry> list = entries = this.entriesSet ? this.entries : DEFAULT_ENTRIES;
            if (entries == null) {
                throw new NullPointerException("Property entries must not be null");
            }
            return new OFBsnGentableBucketStatsReplyVer13(xid, flags, entries);
        }
    }

    static class BuilderWithParent
    implements OFBsnGentableBucketStatsReply.Builder {
        final OFBsnGentableBucketStatsReplyVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean entriesSet;
        private List<OFBsnGentableBucketStatsEntry> entries;

        BuilderWithParent(OFBsnGentableBucketStatsReplyVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGentableBucketStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnGentableBucketStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 5L;
        }

        @Override
        public List<OFBsnGentableBucketStatsEntry> getEntries() {
            return this.entries;
        }

        @Override
        public OFBsnGentableBucketStatsReply.Builder setEntries(List<OFBsnGentableBucketStatsEntry> entries) {
            this.entries = entries;
            this.entriesSet = true;
            return this;
        }

        @Override
        public OFBsnGentableBucketStatsReply build() {
            List entries;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List list = entries = this.entriesSet ? this.entries : this.parentMessage.entries;
            if (entries == null) {
                throw new NullPointerException("Property entries must not be null");
            }
            return new OFBsnGentableBucketStatsReplyVer13(xid, flags, entries);
        }
    }
}

