/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnLog;
import org.projectfloodlight.openflow.protocol.OFBsnLoglevel;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnLoglevelSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnLogVer13
implements OFBsnLog {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnLogVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 17;
    private static final long DEFAULT_XID = 0L;
    private static final String DEFAULT_DATA = "";
    private final long xid;
    private final OFBsnLoglevel loglevel;
    private final String data;
    static final Reader READER = new Reader();
    static final OFBsnLogVer13Funnel FUNNEL = new OFBsnLogVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnLogVer13(long xid, OFBsnLoglevel loglevel, String data) {
        this.xid = xid;
        this.loglevel = loglevel;
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 63L;
    }

    @Override
    public OFBsnLoglevel getLoglevel() {
        return this.loglevel;
    }

    @Override
    public String getData() {
        return this.data;
    }

    @Override
    public OFBsnLog.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnLogVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("loglevel=").append((Object)this.loglevel);
        b.append(", ");
        b.append("data=").append(this.data);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnLogVer13 other = (OFBsnLogVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.loglevel == null ? other.loglevel != null : !this.loglevel.equals((Object)other.loglevel)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.loglevel == null ? 0 : this.loglevel.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnLogVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnLogVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(4);
            bb.writeByte(4);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(63);
            OFBsnLoglevelSerializerVer13.writeTo(bb, message.loglevel);
            ChannelUtils.writeFixedLengthString(bb, message.data, message.data.length());
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnLogVer13Funnel
    implements Funnel<OFBsnLogVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnLogVer13Funnel() {
        }

        public void funnel(OFBsnLogVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(63);
            OFBsnLoglevelSerializerVer13.putTo(message.loglevel, sink);
            sink.putUnencodedChars((CharSequence)message.data);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnLog> {
        Reader() {
        }

        @Override
        public OFBsnLog readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 17) {
                throw new OFParseError("Wrong length: Expected to be >= 17, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 63) {
                throw new OFParseError("Wrong subtype: Expected=0x3fL(0x3fL), got=" + subtype);
            }
            OFBsnLoglevel loglevel = OFBsnLoglevelSerializerVer13.readFrom(bb);
            String data = ChannelUtils.readFixedLengthString(bb, length - (bb.readerIndex() - start));
            OFBsnLogVer13 bsnLogVer13 = new OFBsnLogVer13(xid, loglevel, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnLogVer13);
            }
            return bsnLogVer13;
        }
    }

    static class Builder
    implements OFBsnLog.Builder {
        private boolean xidSet;
        private long xid;
        private boolean loglevelSet;
        private OFBsnLoglevel loglevel;
        private boolean dataSet;
        private String data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnLog.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 63L;
        }

        @Override
        public OFBsnLoglevel getLoglevel() {
            return this.loglevel;
        }

        @Override
        public OFBsnLog.Builder setLoglevel(OFBsnLoglevel loglevel) {
            this.loglevel = loglevel;
            this.loglevelSet = true;
            return this;
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        public OFBsnLog.Builder setData(String data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFBsnLog build() {
            String data;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.loglevelSet) {
                throw new IllegalStateException("Property loglevel doesn't have default value -- must be set");
            }
            if (this.loglevel == null) {
                throw new NullPointerException("Property loglevel must not be null");
            }
            String string = data = this.dataSet ? this.data : OFBsnLogVer13.DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBsnLogVer13(xid, this.loglevel, data);
        }
    }

    static class BuilderWithParent
    implements OFBsnLog.Builder {
        final OFBsnLogVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean loglevelSet;
        private OFBsnLoglevel loglevel;
        private boolean dataSet;
        private String data;

        BuilderWithParent(OFBsnLogVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnLog.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 63L;
        }

        @Override
        public OFBsnLoglevel getLoglevel() {
            return this.loglevel;
        }

        @Override
        public OFBsnLog.Builder setLoglevel(OFBsnLoglevel loglevel) {
            this.loglevel = loglevel;
            this.loglevelSet = true;
            return this;
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        public OFBsnLog.Builder setData(String data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFBsnLog build() {
            String data;
            OFBsnLoglevel loglevel;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFBsnLoglevel oFBsnLoglevel = loglevel = this.loglevelSet ? this.loglevel : this.parentMessage.loglevel;
            if (loglevel == null) {
                throw new NullPointerException("Property loglevel must not be null");
            }
            String string = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBsnLogVer13(xid, loglevel, data);
        }
    }
}

