/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvUnicastQueryTimeout;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvUnicastQueryTimeoutVer13
implements OFBsnTlvUnicastQueryTimeout {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvUnicastQueryTimeoutVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvUnicastQueryTimeoutVer13 DEFAULT = new OFBsnTlvUnicastQueryTimeoutVer13(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvUnicastQueryTimeoutVer13Funnel FUNNEL = new OFBsnTlvUnicastQueryTimeoutVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvUnicastQueryTimeoutVer13(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 9;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvUnicastQueryTimeout.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvUnicastQueryTimeoutVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvUnicastQueryTimeoutVer13 other = (OFBsnTlvUnicastQueryTimeoutVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvUnicastQueryTimeoutVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnTlvUnicastQueryTimeoutVer13 message) {
            bb.writeShort(9);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvUnicastQueryTimeoutVer13Funnel
    implements Funnel<OFBsnTlvUnicastQueryTimeoutVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvUnicastQueryTimeoutVer13Funnel() {
        }

        public void funnel(OFBsnTlvUnicastQueryTimeoutVer13 message, PrimitiveSink sink) {
            sink.putShort((short)9);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvUnicastQueryTimeout> {
        Reader() {
        }

        @Override
        public OFBsnTlvUnicastQueryTimeout readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 9) {
                throw new OFParseError("Wrong type: Expected=0x9(0x9), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvUnicastQueryTimeoutVer13 bsnTlvUnicastQueryTimeoutVer13 = new OFBsnTlvUnicastQueryTimeoutVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvUnicastQueryTimeoutVer13);
            }
            return bsnTlvUnicastQueryTimeoutVer13;
        }
    }

    static class Builder
    implements OFBsnTlvUnicastQueryTimeout.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 9;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUnicastQueryTimeout.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvUnicastQueryTimeout build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvUnicastQueryTimeoutVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvUnicastQueryTimeout.Builder {
        final OFBsnTlvUnicastQueryTimeoutVer13 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvUnicastQueryTimeoutVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 9;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUnicastQueryTimeout.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvUnicastQueryTimeout build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvUnicastQueryTimeoutVer13(value);
        }
    }
}

